/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle"), "createcircle", I18n.tr("Create a circle from three selected nodes."), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle")), 79, 3, 1), true);
    }

    private double calcang(double xc, double yc, double x, double y) {
        if (xc == x && yc == y) {
            return 0.0;
        }
        double yd = Math.abs(y - yc);
        if (yd == 0.0 && xc < x) {
            return 0.0;
        }
        if (yd == 0.0 && xc > x) {
            return Math.PI;
        }
        double xd = Math.abs(x - xc);
        double a = Math.atan2(xd, yd);
        if (y > yc) {
            a = Math.PI - a;
        }
        if (x < xc) {
            a = -a;
        }
        if ((a = 4.71238898038469 + a) < 0.0) {
            a += Math.PI * 2;
        }
        if (a >= Math.PI * 2) {
            a -= Math.PI * 2;
        }
        return a;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Node n1;
        if (!this.isEnabled()) {
            return;
        }
        int numberOfNodesInCircle = Main.pref.getInteger("createcircle.nodecount", 8);
        if (numberOfNodesInCircle < 1) {
            numberOfNodesInCircle = 1;
        } else if (numberOfNodesInCircle > 100) {
            numberOfNodesInCircle = 100;
        }
        Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Way existingWay = null;
        for (OsmPrimitive osm : sel) {
            if (!(osm instanceof Node)) continue;
            nodes.add((Node)osm);
        }
        if (nodes.size() == 0 && sel.size() == 1) {
            for (OsmPrimitive osm : sel) {
                if (!(osm instanceof Way)) continue;
                existingWay = (Way)osm;
                for (Node n : ((Way)osm).getNodes()) {
                    if (nodes.contains(n)) continue;
                    nodes.add(n);
                }
            }
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        if (nodes.size() == 2) {
            Way newWay;
            double a2;
            n1 = (Node)nodes.get(0);
            double x1 = n1.getEastNorth().east();
            double y1 = n1.getEastNorth().north();
            Node n2 = (Node)nodes.get(1);
            double x2 = n2.getEastNorth().east();
            double y2 = n2.getEastNorth().north();
            double xc = 0.5 * (x1 + x2);
            double yc = 0.5 * (y1 + y2);
            double r = Math.sqrt(Math.pow(xc - x1, 2.0) + Math.pow(yc - y1, 2.0));
            double a1 = this.calcang(xc, yc, x1, y1);
            if (a1 < (a2 = this.calcang(xc, yc, x2, y2))) {
                double at = a1;
                Node nt = n1;
                a1 = a2;
                n1 = n2;
                a2 = at;
                n2 = nt;
            }
            ArrayList<Node> wayToAdd = new ArrayList<Node>();
            for (int i = 1; i <= numberOfNodesInCircle; ++i) {
                double a = a2 + Math.PI * 2 * (1.0 - (double)i / (double)numberOfNodesInCircle);
                if (a1 < 999.0 && a1 > a - 1.0E-9 && a1 < a + 1.0E-9) {
                    wayToAdd.add(n1);
                    a1 = 999.0;
                    continue;
                }
                if (a2 < 999.0 && a2 > a - 1.0E-9 && a2 < a + 1.0E-9) {
                    wayToAdd.add(n2);
                    a2 = 999.0;
                    continue;
                }
                double x = xc + r * Math.cos(a);
                double y = yc + r * Math.sin(a);
                Node n = new Node(Main.proj.eastNorth2latlon(new EastNorth(x, y)));
                wayToAdd.add(n);
                cmds.add(new AddCommand(n));
            }
            wayToAdd.add((Node)wayToAdd.get(0));
            if (existingWay == null) {
                newWay = new Way();
                newWay.setNodes(wayToAdd);
                cmds.add(new AddCommand(newWay));
            } else {
                newWay = new Way(existingWay);
                newWay.setNodes(wayToAdd);
                cmds.add(new ChangeCommand(existingWay, newWay));
            }
            if (a1 < 999.0) {
                CollectBackReferencesVisitor refs = new CollectBackReferencesVisitor(this.getCurrentDataSet());
                refs.initialize();
                refs.visit(n1);
                if (refs.getData().isEmpty() || refs.getData().size() == 1 && refs.getData().contains(existingWay)) {
                    cmds.add(new DeleteCommand(n1));
                }
            }
        } else if (nodes.size() == 3) {
            Node nt;
            double at;
            n1 = (Node)nodes.get(0);
            double x1 = n1.getEastNorth().east();
            double y1 = n1.getEastNorth().north();
            Node n2 = (Node)nodes.get(1);
            double x2 = n2.getEastNorth().east();
            double y2 = n2.getEastNorth().north();
            Node n3 = (Node)nodes.get(2);
            double x3 = n3.getEastNorth().east();
            double y3 = n3.getEastNorth().north();
            double s = 0.5 * ((x2 - x3) * (x1 - x3) - (y2 - y3) * (y3 - y1));
            double sUnder = (x1 - x2) * (y3 - y1) - (y2 - y1) * (x1 - x3);
            if (sUnder == 0.0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Those nodes are not in a circle. Aborting."), I18n.tr("Warning"), 2);
                return;
            }
            double xc = 0.5 * (x1 + x2) + (s /= sUnder) * (y2 - y1);
            double yc = 0.5 * (y1 + y2) + s * (x1 - x2);
            double r = Math.sqrt(Math.pow(xc - x1, 2.0) + Math.pow(yc - y1, 2.0));
            double a1 = this.calcang(xc, yc, x1, y1);
            double a2 = this.calcang(xc, yc, x2, y2);
            double a3 = this.calcang(xc, yc, x3, y3);
            if (a1 < a2) {
                at = a1;
                nt = n1;
                a1 = a2;
                n1 = n2;
                a2 = at;
                n2 = nt;
            }
            if (a2 < a3) {
                at = a2;
                nt = n2;
                a2 = a3;
                n2 = n3;
                a3 = at;
                n3 = nt;
            }
            if (a1 < a2) {
                at = a1;
                nt = n1;
                a1 = a2;
                n1 = n2;
                a2 = at;
                n2 = nt;
            }
            ArrayList<Node> wayToAdd = new ArrayList<Node>();
            for (int i = 1; i <= numberOfNodesInCircle; ++i) {
                double a = Math.PI * 2 * (1.0 - (double)i / (double)numberOfNodesInCircle);
                if (a1 < 999.0 && a1 > a) {
                    wayToAdd.add(n1);
                    a1 = 999.0;
                }
                if (a2 < 999.0 && a2 > a) {
                    wayToAdd.add(n2);
                    a2 = 999.0;
                }
                if (a3 < 999.0 && a3 > a) {
                    wayToAdd.add(n3);
                    a3 = 999.0;
                }
                double x = xc + r * Math.cos(a);
                double y = yc + r * Math.sin(a);
                Node n = new Node(Main.proj.eastNorth2latlon(new EastNorth(x, y)));
                wayToAdd.add(n);
                cmds.add(new AddCommand(n));
            }
            wayToAdd.add((Node)wayToAdd.get(0));
            if (existingWay == null) {
                Way newWay = new Way();
                newWay.setNodes(wayToAdd);
                cmds.add(new AddCommand(newWay));
            } else {
                Way newWay = new Way(existingWay);
                newWay.setNodes(wayToAdd);
                cmds.add(new ChangeCommand(existingWay, newWay));
            }
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select exactly two or three nodes or one way with exactly two or three nodes."), I18n.tr("Information"), 1);
            return;
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle"), cmds));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

