/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoScaleAction
extends JosmAction {
    public static final String[] modes = new String[]{I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download")};
    private final String mode;

    private static int getModeShortcut(String mode) {
        int shortcut = -1;
        if (mode.equals("data")) {
            shortcut = 49;
        }
        if (mode.equals("layer")) {
            shortcut = 50;
        }
        if (mode.equals("selection")) {
            shortcut = 51;
        }
        if (mode.equals("conflict")) {
            shortcut = 52;
        }
        if (mode.equals("download")) {
            shortcut = 53;
        }
        return shortcut;
    }

    public AutoScaleAction(String mode) {
        super(I18n.tr("Zoom to {0}", I18n.tr(mode)), "dialogs/autoscale/" + mode, I18n.tr("Zoom the view to {0}.", I18n.tr(mode)), Shortcut.registerShortcut("view:zoom" + mode, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(mode))), AutoScaleAction.getModeShortcut(mode), 3), true);
        String modeHelp = Character.toUpperCase(mode.charAt(0)) + mode.substring(1);
        this.putValue("help", "Action/AutoScale/" + modeHelp);
        this.mode = mode;
    }

    public void autoScale() {
        BoundingXYVisitor bbox;
        if (Main.map != null && (bbox = this.getBoundingBox()) != null && bbox.getBounds() != null) {
            Main.map.mapView.recalculateCenterScale(bbox);
        }
        this.putValue("active", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.autoScale();
    }

    protected Layer getActiveLayer() {
        try {
            return Main.map.mapView.getActiveLayer();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected Layer getFirstSelectedLayer() {
        if (LayerListDialog.getInstance() == null) {
            return null;
        }
        List<Layer> layers = LayerListDialog.getInstance().getModel().getSelectedLayers();
        if (layers.isEmpty()) {
            return null;
        }
        return layers.get(0);
    }

    private BoundingXYVisitor getBoundingBox() {
        BoundingXYVisitor v;
        block11: {
            block13: {
                block12: {
                    block10: {
                        v = new BoundingXYVisitor();
                        if (!this.mode.equals("data")) break block10;
                        for (Layer l : Main.map.mapView.getAllLayers()) {
                            l.visitBoundingBox(v);
                        }
                        break block11;
                    }
                    if (!this.mode.equals("layer")) break block12;
                    if (this.getActiveLayer() == null) {
                        return null;
                    }
                    Layer l = this.getFirstSelectedLayer();
                    if (l == null) {
                        return null;
                    }
                    l.visitBoundingBox(v);
                    break block11;
                }
                if (!this.mode.equals("selection") && !this.mode.equals("conflict")) break block13;
                Collection<Object> sel = new HashSet();
                if (this.mode.equals("selection")) {
                    sel = this.getCurrentDataSet().getSelected();
                } else if (this.mode.equals("conflict") && Main.map.conflictDialog.getConflicts() != null) {
                    sel = Main.map.conflictDialog.getConflicts().getMyConflictParties();
                }
                if (sel.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, this.mode.equals("selection") ? I18n.tr("Nothing selected to zoom to.") : I18n.tr("No conflicts to zoom to"), I18n.tr("Information"), 1);
                    return null;
                }
                for (OsmPrimitive osmPrimitive : sel) {
                    osmPrimitive.visit(v);
                }
                v.enlargeBoundingBox();
                break block11;
            }
            if (!this.mode.equals("download") || !Main.pref.hasKey("osm-download.bounds")) break block11;
            try {
                String[] bounds = Main.pref.get("osm-download.bounds").split(";");
                double minlat = Double.parseDouble(bounds[0]);
                double minlon = Double.parseDouble(bounds[1]);
                double maxlat = Double.parseDouble(bounds[2]);
                double maxlon = Double.parseDouble(bounds[3]);
                v.visit(Main.proj.latlon2eastNorth(new LatLon(minlat, minlon)));
                v.visit(Main.proj.latlon2eastNorth(new LatLon(maxlat, maxlon)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return v;
    }

    @Override
    protected void updateEnabledState() {
        if ("selection".equals(this.mode)) {
            this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
        } else if ("layer".equals(this.mode)) {
            if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getAllLayersAsList().isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.hasLayers());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if ("selection".equals(this.mode)) {
            this.setEnabled(selection != null && !selection.isEmpty());
        }
    }
}

