/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UrlLabel;

public class AboutAction
extends JosmAction {
    private static final String version;
    private static final JTextArea revision;
    private static String time;

    public static String getVersionString() {
        return version;
    }

    public static String getTextBlock() {
        return revision.getText();
    }

    public static void setUserAgent() {
        Properties sysProp = System.getProperties();
        sysProp.put("http.agent", "JOSM/1.5 (" + (version.equals(I18n.tr("UNKNOWN")) ? "UNKNOWN" : version) + " " + LanguageInfo.getJOSMLocaleCode() + ")");
        System.setProperties(sysProp);
    }

    public static int getVersionNumber() {
        int myVersion = Integer.MAX_VALUE;
        try {
            myVersion = Integer.parseInt(version.split(" ")[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return myVersion;
    }

    public static boolean isDevelopmentVersion() {
        return version.endsWith(" SVN") || version.equals(I18n.tr("UNKNOWN"));
    }

    public AboutAction() {
        super(I18n.tr("About"), "about", I18n.tr("Display the about screen."), Shortcut.registerShortcut("system:about", I18n.tr("About"), 112, 5, 1), true);
    }

    public void actionPerformed(ActionEvent e) {
        JTabbedPane about = new JTabbedPane();
        JTextArea readme = AboutAction.loadFile(Main.class.getResource("/README"), false);
        JTextArea contribution = AboutAction.loadFile(Main.class.getResource("/CONTRIBUTION"), false);
        JTextArea license = AboutAction.loadFile(Main.class.getResource("/LICENSE"), false);
        JPanel info = new JPanel(new GridBagLayout());
        JLabel caption = new JLabel("JOSM - " + I18n.tr("Java OpenStreetMap Editor"));
        caption.setFont(new Font("Helvetica", 1, 20));
        info.add((Component)caption, GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 10), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Version {0}", version)), GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 5), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Last change at {0}", time)), GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 5), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Java Version {0}", System.getProperty("java.version"))), GBC.eol().fill(2).insets(10, 0, 0, 0));
        info.add(GBC.glue(0, 10), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Homepage")), GBC.std().insets(10, 0, 10, 0));
        info.add((Component)new UrlLabel("http://josm.openstreetmap.de"), GBC.eol().fill(2));
        info.add((Component)new JLabel(I18n.tr("Bug Reports")), GBC.std().insets(10, 0, 10, 0));
        info.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket"), GBC.eol().fill(2));
        about.addTab(I18n.tr("Info"), info);
        about.addTab(I18n.tr("Readme"), this.createScrollPane(readme));
        about.addTab(I18n.tr("Revision"), this.createScrollPane(revision));
        about.addTab(I18n.tr("Contribution"), this.createScrollPane(contribution));
        about.addTab(I18n.tr("License"), this.createScrollPane(license));
        about.addTab(I18n.tr("Plugins"), new JScrollPane(PluginHandler.getInfoPanel()));
        about.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(Main.parent, about, I18n.tr("About JOSM..."), 1, ImageProvider.get("logo"));
    }

    private JScrollPane createScrollPane(JTextArea area) {
        area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        area.setOpaque(false);
        JScrollPane sp = new JScrollPane(area);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    public static String checkLatestVersion() {
        String latest;
        try {
            InputStream s = new URL("http://josm.openstreetmap.de/current").openStream();
            latest = new BufferedReader(new InputStreamReader(s)).readLine();
            s.close();
        }
        catch (IOException x) {
            x.printStackTrace();
            return I18n.tr("UNKNOWN");
        }
        return latest;
    }

    private static JTextArea loadFile(URL resource, boolean manifest) {
        JTextArea area = new JTextArea(I18n.tr("File could not be found."));
        area.setEditable(false);
        Font font = Font.getFont("monospaced");
        if (font != null) {
            area.setFont(font);
        }
        if (resource == null) {
            return area;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(resource.openStream()));
            String s = "";
            String line = in.readLine();
            while (line != null) {
                s = s + line + "\n";
                line = in.readLine();
            }
            if (manifest) {
                s = Pattern.compile("\n ", 32).matcher(s).replaceAll("");
                s = Pattern.compile("^(SHA1-Digest|Name): .*?$", 40).matcher(s).replaceAll("");
                s = Pattern.compile("\n+$", 32).matcher(s).replaceAll("");
            }
            area.setText(s);
            area.setCaretPosition(0);
        }
        catch (IOException e) {
            System.err.println("Cannot load resource " + resource + ": " + e.getMessage());
        }
        return area;
    }

    static {
        boolean manifest = false;
        URL u = Main.class.getResource("/REVISION");
        if (u == null) {
            try {
                manifest = true;
                u = new URL("jar:" + Main.class.getProtectionDomain().getCodeSource().getLocation().toString() + "!/META-INF/MANIFEST.MF");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        revision = AboutAction.loadFile(u, manifest);
        System.out.println("Revision: " + revision.getText());
        Pattern versionPattern = Pattern.compile(".*?(?:Revision|Main-Version): ([0-9]*(?: SVN)?).*", 34);
        Matcher match = versionPattern.matcher(revision.getText());
        version = match.matches() ? match.group(1) : I18n.tr("UNKNOWN");
        Pattern timePattern = Pattern.compile(".*?(?:Last Changed Date|Main-Date): ([^\n]*).*", 34);
        match = timePattern.matcher(revision.getText());
        time = match.matches() ? match.group(1) : I18n.tr("UNKNOWN");
    }
}

