/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.PointerFinder;
import sun.jvm.hotspot.utilities.PointerLocation;

public class FindPanel
extends JPanel {
    private JTextField addressField;
    private JTextArea textArea;
    private JLabel statusLabel;

    public FindPanel() {
        this.setLayout(new BorderLayout());
        Box hbox = Box.createHorizontalBox();
        hbox.add(new JLabel("Address: "));
        this.addressField = new JTextField(20);
        hbox.add(this.addressField);
        this.statusLabel = new JLabel();
        hbox.add(this.statusLabel);
        this.add((Component)hbox, "North");
        JScrollPane scroller = new JScrollPane();
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        scroller.getViewport().add(this.textArea);
        this.add((Component)scroller, "Center");
        this.addressField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Address a = VM.getVM().getDebugger().parseAddress(FindPanel.this.addressField.getText());
                    PointerLocation loc = PointerFinder.find(a);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    loc.printOn(new PrintStream(bos));
                    FindPanel.this.clear();
                    FindPanel.this.textArea.append(bos.toString());
                    FindPanel.this.statusLabel.setText("");
                }
                catch (NumberFormatException ex) {
                    FindPanel.this.statusLabel.setText("<parse error>");
                }
                catch (AddressException ex) {
                    FindPanel.this.statusLabel.setText("<bad address>");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    FindPanel.this.statusLabel.setText("<error during find>");
                }
            }
        });
    }

    private void clear() {
        Document doc = this.textArea.getDocument();
        if (doc.getLength() > 0) {
            try {
                doc.remove(0, doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

