/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.dbx;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.InputLexer;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.dbx.DbxAddress;
import sun.jvm.hotspot.debugger.dbx.DbxDebugger;
import sun.jvm.hotspot.debugger.dbx.DbxOopHandle;
import sun.jvm.hotspot.debugger.dbx.DbxThreadFactory;
import sun.jvm.hotspot.debugger.dbx.sparc.DbxSPARCThreadFactory;
import sun.jvm.hotspot.debugger.dbx.x86.DbxX86ThreadFactory;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.PlatformInfo;
import sun.jvm.hotspot.utilities.StreamMonitor;

public class DbxDebuggerLocal
extends DebuggerBase
implements DbxDebugger {
    protected boolean unalignedAccessesOkay;
    protected DbxThreadFactory threadFactory;
    private String dbxPathName;
    private String[] dbxSvcAgentDSOPathNames;
    private Process dbxProcess;
    private StreamMonitor dbxOutStreamMonitor;
    private StreamMonitor dbxErrStreamMonitor;
    private PrintWriter dbxOstr;
    private PrintWriter out;
    private InputLexer in;
    private Socket importModuleSocket;
    private static final int PORT = 21928;
    private static final int LONG_TIMEOUT = 60000;
    private static final int DBX_MODULE_NOT_FOUND = 101;
    private static final int DBX_MODULE_LOADED = 102;

    public DbxDebuggerLocal(MachineDescription machDesc, String dbxPathName, String[] dbxSvcAgentDSOPathNames, boolean useCache) {
        int cachePageSize;
        int cacheNumPages;
        this.machDesc = machDesc;
        this.dbxPathName = dbxPathName;
        this.dbxSvcAgentDSOPathNames = dbxSvcAgentDSOPathNames;
        if (PlatformInfo.getCPU().equals("sparc")) {
            cacheNumPages = this.parseCacheNumPagesProperty(2048);
            cachePageSize = 8192;
            this.threadFactory = new DbxSPARCThreadFactory(this);
        } else if (PlatformInfo.getCPU().equals("x86")) {
            cacheNumPages = 4096;
            cachePageSize = 4096;
            this.threadFactory = new DbxX86ThreadFactory(this);
            this.unalignedAccessesOkay = true;
        } else {
            throw new RuntimeException("Thread access for CPU architecture " + PlatformInfo.getCPU() + " not yet supported");
        }
        if (useCache) {
            this.initCache(cachePageSize, cacheNumPages);
        }
    }

    protected DbxDebuggerLocal() {
    }

    public boolean hasProcessList() throws DebuggerException {
        return false;
    }

    public List getProcessList() throws DebuggerException {
        throw new DebuggerException("Not yet supported");
    }

    public synchronized void attach(int processID) throws DebuggerException {
        try {
            this.launchProcess();
            this.dbxErrStreamMonitor.addTrigger("dbx: no process", 1);
            this.dbxErrStreamMonitor.addTrigger("dbx: Cannot open", 1);
            this.dbxErrStreamMonitor.addTrigger("dbx: Cannot find", 101);
            this.dbxOstr = new PrintWriter(this.dbxProcess.getOutputStream(), true);
            this.dbxOstr.println("debug - " + processID);
            this.dbxOstr.println("kprint -u2 \\(ready\\)");
            boolean seen = this.dbxErrStreamMonitor.waitFor("(ready)", 60000L);
            if (!seen) {
                this.detach();
                throw new DebuggerException("Timed out while connecting to process " + processID);
            }
            List retVals = this.dbxErrStreamMonitor.getTriggersSeen();
            if (retVals.contains(new Integer(1))) {
                this.detach();
                throw new DebuggerException("No such process " + processID);
            }
            this.importDbxModule();
            this.dbxOstr.println("svc_agent_run");
            this.connectToImportModule();
            this.printlnToOutput("peek_fail_fast 1");
        }
        catch (IOException e) {
            this.detach();
            throw new DebuggerException("Error while connecting to dbx process", e);
        }
    }

    public synchronized void attach(String executableName, String coreFileName) throws DebuggerException {
        try {
            this.launchProcess();
            this.dbxErrStreamMonitor.addTrigger("dbx: Cannot open", 1);
            this.dbxErrStreamMonitor.addTrigger("dbx: can't read", 2);
            this.dbxErrStreamMonitor.addTrigger("dbx: File", 3);
            this.dbxErrStreamMonitor.addTrigger("dbx: Unable to read", 4);
            this.dbxErrStreamMonitor.addTrigger("dbx: core object name", 5);
            this.dbxErrStreamMonitor.addTrigger("dbx: can't stat", 6);
            this.dbxOstr = new PrintWriter(this.dbxProcess.getOutputStream(), true);
            this.dbxOstr.println("debug " + executableName + " " + coreFileName);
            this.dbxOstr.println("kprint -u2 \\(ready\\)");
            boolean seen = this.dbxErrStreamMonitor.waitFor("(ready)", 60000L);
            if (!seen) {
                this.detach();
                throw new DebuggerException("Timed out while attaching to core file");
            }
            List retVals = this.dbxErrStreamMonitor.getTriggersSeen();
            if (retVals.size() > 0) {
                this.detach();
                if (retVals.contains(new Integer(1))) {
                    throw new DebuggerException("Can not find executable \"" + executableName + "\"");
                }
                if (retVals.contains(new Integer(2))) {
                    throw new DebuggerException("Can not find core file \"" + coreFileName + "\"");
                }
                if (retVals.contains(new Integer(3))) {
                    throw new DebuggerException("Corrupt executable \"" + executableName + "\"");
                }
                if (retVals.contains(new Integer(4))) {
                    throw new DebuggerException("Corrupt core file \"" + coreFileName + "\"");
                }
                if (retVals.contains(new Integer(5))) {
                    throw new DebuggerException("Mismatched core file/executable \"" + coreFileName + "\"/\"" + executableName + "\"");
                }
                throw new DebuggerException("Couldn't find all loaded libraries for executable \"" + executableName + "\"");
            }
            this.importDbxModule();
            this.dbxOstr.println("svc_agent_run");
            this.connectToImportModule();
            this.printlnToOutput("peek_fail_fast 1");
        }
        catch (IOException e) {
            this.detach();
            throw new DebuggerException("Error while connecting to dbx process", e);
        }
    }

    public synchronized boolean detach() {
        try {
            if (this.dbxProcess == null) {
                return false;
            }
            if (this.out != null && this.dbxOstr != null) {
                this.printlnToOutput("exit");
                this.dbxOstr.println("exit");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.shutdown();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Address parseAddress(String addressString) throws NumberFormatException {
        long addr = this.utils.scanAddress(addressString);
        if (addr == 0L) {
            return null;
        }
        return new DbxAddress(this, addr);
    }

    public String getOS() {
        return PlatformInfo.getOS();
    }

    public String getCPU() {
        return PlatformInfo.getCPU();
    }

    public boolean hasConsole() throws DebuggerException {
        return true;
    }

    public synchronized String consoleExecuteCommand(String cmd) throws DebuggerException {
        try {
            this.printlnToOutput("exit");
            this.importModuleSocket.close();
            this.importModuleSocket = null;
            this.out = null;
            this.in = null;
            this.dbxOstr.println("kprint \\(ready\\)");
            this.dbxOstr.flush();
            this.dbxOutStreamMonitor.waitFor("(ready)", 60000L);
            this.dbxOutStreamMonitor.startCapture();
            this.dbxErrStreamMonitor.startCapture();
            this.dbxOstr.println(cmd);
            this.dbxOstr.println("kprint \\(ready\\)");
            this.dbxOutStreamMonitor.waitFor("(ready)", 60000L);
            String result = this.dbxOutStreamMonitor.stopCapture();
            String result2 = this.dbxErrStreamMonitor.stopCapture();
            result = result + result2;
            StringBuffer outBuf = new StringBuffer(result.length());
            BufferedReader reader = new BufferedReader(new StringReader(result));
            String line = null;
            do {
                if ((line = reader.readLine()) == null || line.equals("(ready)")) continue;
                outBuf.append(line);
                outBuf.append("\n");
            } while (line != null);
            this.dbxOstr.println("svc_agent_run");
            this.dbxOstr.flush();
            this.connectToImportModule();
            return outBuf.toString();
        }
        catch (IOException e) {
            this.detach();
            throw new DebuggerException("Error while executing command on dbx console", e);
        }
    }

    public String getConsolePrompt() throws DebuggerException {
        return "(dbx) ";
    }

    public CDebugger getCDebugger() throws DebuggerException {
        return null;
    }

    public synchronized Address lookup(String objectName, String symbol) {
        long addr = this.lookupInProcess(objectName, symbol);
        if (addr == 0L) {
            return null;
        }
        return new DbxAddress(this, addr);
    }

    public synchronized OopHandle lookupOop(String objectName, String symbol) {
        long addr = this.lookupInProcess(objectName, symbol);
        if (addr == 0L) {
            return null;
        }
        return new DbxOopHandle(this, addr);
    }

    public MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    public void setMachineDescription(MachineDescription machDesc) {
        this.machDesc = machDesc;
        this.setBigEndian(machDesc.isBigEndian());
        this.utils = new DebuggerUtilities(machDesc.getAddressSize(), machDesc.isBigEndian());
    }

    public int getRemoteProcessAddressSize() {
        if (this.dbxProcess == null) {
            throw new RuntimeException("Not attached to remote process");
        }
        try {
            this.printlnToOutput("address_size");
            int i = this.in.parseInt();
            return i;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return this.threadFactory.createThreadWrapper(addr);
    }

    public ThreadProxy getThreadForThreadId(long id) {
        return this.threadFactory.createThreadWrapper(id);
    }

    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        if (this.unalignedAccessesOkay) {
            this.utils.checkAlignment(address, this.jintSize);
        } else {
            this.utils.checkAlignment(address, this.jlongSize);
        }
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    public String addressValueToString(long address) {
        return this.utils.addressValueToString(address);
    }

    public long readCInteger(long address, long numBytes, boolean isUnsigned) throws UnmappedAddressException, UnalignedAddressException {
        this.checkConfigured();
        if (!this.unalignedAccessesOkay) {
            this.utils.checkAlignment(address, numBytes);
        } else if (numBytes == 8L) {
            this.utils.checkAlignment(address, 4L);
        } else {
            this.utils.checkAlignment(address, numBytes);
        }
        byte[] data = this.readBytes(address, numBytes);
        return this.utils.dataToCInteger(data, isUnsigned);
    }

    public DbxAddress readAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new DbxAddress(this, value);
    }

    public DbxAddress readCompOopAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new DbxAddress(this, value);
    }

    public DbxOopHandle readOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new DbxOopHandle(this, value);
    }

    public DbxOopHandle readCompOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readCompOopAddressValue(address);
        return value == 0L ? null : new DbxOopHandle(this, value);
    }

    public synchronized long[] getThreadIntegerRegisterSet(int tid) {
        try {
            this.printlnToOutput("thr_gregs " + tid);
            int num = this.in.parseInt();
            long[] res = new long[num];
            for (int i = 0; i < num; ++i) {
                res[i] = this.in.parseAddress();
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getAddressValue(Address addr) {
        if (addr == null) {
            return 0L;
        }
        return ((DbxAddress)addr).getValue();
    }

    public Address newAddress(long value) {
        if (value == 0L) {
            return null;
        }
        return new DbxAddress(this, value);
    }

    private void launchProcess() throws IOException {
        this.dbxProcess = Runtime.getRuntime().exec(this.dbxPathName);
        this.dbxOutStreamMonitor = new StreamMonitor(this.dbxProcess.getInputStream(), "dbx stdout", true);
        this.dbxErrStreamMonitor = new StreamMonitor(this.dbxProcess.getErrorStream(), "dbx stderr", true);
    }

    private void importDbxModule() throws DebuggerException {
        this.dbxOutStreamMonitor.addTrigger("Defining svc_agent_run", 102);
        for (int i = 0; i < this.dbxSvcAgentDSOPathNames.length; ++i) {
            this.dbxOstr.println("import " + this.dbxSvcAgentDSOPathNames[i]);
            this.dbxOstr.println("kprint -u2 \\(Ready\\)");
            boolean seen = this.dbxErrStreamMonitor.waitFor("(Ready)", 60000L);
            if (!seen) {
                this.detach();
                throw new DebuggerException("Timed out while importing dbx module from file\n" + this.dbxSvcAgentDSOPathNames[i]);
            }
            List retVals = this.dbxErrStreamMonitor.getTriggersSeen();
            if (retVals.contains(new Integer(101))) {
                this.detach();
                throw new DebuggerException("Unable to find the Serviceability Agent's dbx import module at pathname \"" + this.dbxSvcAgentDSOPathNames[i] + "\"");
            }
            retVals = this.dbxOutStreamMonitor.getTriggersSeen();
            if (!retVals.contains(new Integer(102))) continue;
            System.out.println("importDbxModule: imported " + this.dbxSvcAgentDSOPathNames[i]);
            return;
        }
        this.detach();
        String errMsg = "Unable to find a version of the Serviceability Agent's dbx import module\nmatching the architecture of dbx at any of the following locations:";
        for (int i = 0; i < this.dbxSvcAgentDSOPathNames.length; ++i) {
            errMsg = errMsg + "\n" + this.dbxSvcAgentDSOPathNames[i];
        }
        throw new DebuggerException(errMsg);
    }

    private void shutdown() {
        if (this.dbxProcess != null) {
            try {
                this.dbxProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.dbxProcess.destroy();
            }
        }
        try {
            if (this.importModuleSocket != null) {
                this.importModuleSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.clear();
        this.clearCache();
    }

    synchronized long lookupInProcess(String objectName, String symbol) {
        try {
            this.printlnToOutput("lookup " + objectName + " " + symbol);
            return this.in.parseAddress();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public synchronized ReadResult readBytesFromProcess(long address, long numBytes) throws DebuggerException {
        if (numBytes < 0L) {
            throw new DebuggerException("Can not read negative number (" + numBytes + ") of bytes from process");
        }
        try {
            String cmd = "peek " + this.utils.addressValueToString(address) + " " + numBytes;
            this.printlnToOutput(cmd);
            while (this.in.readByte() != 66) {
            }
            byte res = this.in.readByte();
            if (res == 0) {
                System.err.println("Failing command: " + cmd);
                throw new DebuggerException("Read of remote process address space failed");
            }
            byte[] buf = new byte[(int)numBytes];
            boolean bailOut = false;
            long failureAddress = 0L;
            int numReads = 0;
            while (numBytes > 0L) {
                boolean isMapped;
                long len = this.in.readUnsignedInt();
                boolean bl = isMapped = this.in.readByte() != 0;
                if (!isMapped) {
                    if (!bailOut) {
                        bailOut = true;
                        failureAddress = address;
                    }
                } else {
                    this.in.readBytes(buf, 0, (int)len);
                }
                numBytes -= len;
                address += len;
                ++numReads;
            }
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(numBytes == 0L, "Bug in debug server's implementation of peek: numBytesLeft == " + numBytes + ", should be 0 (did " + numReads + " reads)");
            }
            if (bailOut) {
                return new ReadResult(failureAddress);
            }
            return new ReadResult(buf);
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public void writeBytesToProcess(long address, long numBytes, byte[] data) throws UnmappedAddressException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    ReadResult readBytesFromProcessInternal(long address, long numBytes) throws DebuggerException {
        return this.readBytesFromProcess(address, numBytes);
    }

    private void printlnToOutput(String s) throws IOException {
        this.out.println(s);
        if (this.out.checkError()) {
            throw new IOException("Error occurred while writing to debug server");
        }
    }

    private void clear() {
        this.dbxProcess = null;
        this.dbxOstr = null;
        this.out = null;
        this.in = null;
        this.importModuleSocket = null;
    }

    private void connectToImportModule() throws IOException {
        this.importModuleSocket = null;
        long endTime = System.currentTimeMillis() + 60000L;
        while (this.importModuleSocket == null && System.currentTimeMillis() < endTime) {
            try {
                this.importModuleSocket = new Socket(InetAddress.getLocalHost(), 21928);
                this.importModuleSocket.setTcpNoDelay(true);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
        }
        if (this.importModuleSocket == null) {
            this.detach();
            throw new DebuggerException("Timed out while attempting to connect to remote dbx process");
        }
        this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.importModuleSocket.getOutputStream(), "US-ASCII")), true);
        this.in = new InputLexer(new BufferedInputStream(this.importModuleSocket.getInputStream()));
    }
}

