/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.debugger.cdbg.LocalSym;
import sun.jvm.hotspot.debugger.cdbg.NamedFieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;

public abstract class BasicCFrame
implements CFrame {
    private CDebugger dbg;

    protected BasicCFrame(CDebugger dbg) {
        this.dbg = dbg;
    }

    protected CDebugger dbg() {
        return this.dbg;
    }

    public LoadObject loadObjectForPC() {
        return this.dbg.loadObjectContainingPC(this.pc());
    }

    public BlockSym blockForPC() {
        LoadObject lo = this.loadObjectForPC();
        if (lo == null) {
            return null;
        }
        return lo.debugInfoForPC(this.pc());
    }

    public ClosestSymbol closestSymbolToPC() {
        LoadObject lo = this.loadObjectForPC();
        if (lo == null) {
            return null;
        }
        return lo.closestSymbolToPC(this.pc());
    }

    public void iterateLocals(ObjectVisitor v) {
        for (BlockSym block = this.blockForPC(); block != null; block = block.getParent()) {
            for (int i = 0; i < block.getNumLocals(); ++i) {
                final LocalSym local = block.getLocal(i);
                Type t = local.getType();
                if (t == null) continue;
                t.iterateObject(this.localVariableBase().addOffsetTo(local.getFrameOffset()), v, new NamedFieldIdentifier(){

                    public Type getType() {
                        return local.getType();
                    }

                    public String getName() {
                        return local.getName();
                    }

                    public String toString() {
                        return this.getName();
                    }
                });
            }
        }
    }
}

