/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import sun.jvm.hotspot.bugspot.PCFinder;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;

public class ThreadListPanel
extends JPanel {
    private List threadList;
    private JTable table;
    private AbstractTableModel dataModel;
    private List listeners;

    public ThreadListPanel(CDebugger dbg, final boolean displayJavaThreads) {
        Object threads;
        HashMap<ThreadProxy, JavaThread> threadToJavaThreadMap = null;
        if (displayJavaThreads) {
            threadToJavaThreadMap = new HashMap<ThreadProxy, JavaThread>();
            threads = VM.getVM().getThreads();
            for (JavaThread thr = ((Threads)threads).first(); thr != null; thr = thr.next()) {
                threadToJavaThreadMap.put(thr.getThreadProxy(), thr);
            }
        }
        threads = dbg.getThreadList();
        this.threadList = new ArrayList(threads.size());
        Iterator iter = threads.iterator();
        while (iter.hasNext()) {
            ThreadProxy thr = (ThreadProxy)iter.next();
            JavaThread jthr = null;
            if (displayJavaThreads) {
                jthr = (JavaThread)threadToJavaThreadMap.get(thr);
            }
            this.threadList.add(new ThreadInfo(thr, dbg, jthr));
        }
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return displayJavaThreads ? 5 : 3;
            }

            public int getRowCount() {
                return ThreadListPanel.this.threadList.size();
            }

            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return "Thread ID";
                    }
                    case 1: {
                        return "PC";
                    }
                    case 2: {
                        return "Location";
                    }
                    case 3: {
                        return "Java?";
                    }
                    case 4: {
                        return "Java Thread Name";
                    }
                }
                throw new RuntimeException("Index " + col + " out of bounds");
            }

            public Object getValueAt(int row, int col) {
                ThreadInfo info = (ThreadInfo)ThreadListPanel.this.threadList.get(row);
                switch (col) {
                    case 0: {
                        return info.getThread();
                    }
                    case 1: {
                        if (info.hasPC()) {
                            return info.getPC();
                        }
                        return "<no frames on stack>";
                    }
                    case 2: {
                        return info.getLocation();
                    }
                    case 3: {
                        if (info.isJavaThread()) {
                            return "Yes";
                        }
                        return "";
                    }
                    case 4: {
                        if (info.isJavaThread()) {
                            return info.getJavaThreadName();
                        }
                        return "";
                    }
                }
                throw new RuntimeException("Index (" + col + ", " + row + ") out of bounds");
            }
        };
        this.setLayout(new BorderLayout());
        this.table = new JTable(this.dataModel);
        this.table.setSelectionMode(0);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        if (this.threadList.size() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        JButton button = new JButton("Set Focus");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = ThreadListPanel.this.table.getSelectedRow();
                if (i < 0) {
                    return;
                }
                ThreadInfo info = (ThreadInfo)ThreadListPanel.this.threadList.get(i);
                Iterator iter = ThreadListPanel.this.listeners.iterator();
                while (iter.hasNext()) {
                    ((Listener)iter.next()).setFocus(info.getThread(), info.getJavaThread());
                }
            }
        });
        JPanel focusPanel = new JPanel();
        focusPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        focusPanel.setLayout(new BoxLayout(focusPanel, 1));
        focusPanel.add(Box.createGlue());
        focusPanel.add(button);
        focusPanel.add(Box.createGlue());
        this.add((Component)focusPanel, "East");
    }

    public void addListener(Listener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    static class ThreadInfo {
        private ThreadProxy thread;
        private boolean gotPC;
        private Address pc;
        private String location;
        private JavaThread javaThread;
        private String javaThreadName;

        public ThreadInfo(ThreadProxy thread, CDebugger dbg, JavaThread jthread) {
            this.thread = thread;
            this.location = "<unknown>";
            CFrame fr = dbg.topFrameForThread(thread);
            if (fr != null) {
                this.gotPC = true;
                this.pc = fr.pc();
                PCFinder.Info info = PCFinder.findPC(this.pc, fr.loadObjectForPC(), dbg);
                if (info.getName() != null) {
                    this.location = info.getName();
                    if (info.getConfidence() == 1) {
                        this.location = this.location + " (?)";
                    }
                    if (info.getOffset() < 0L) {
                        this.location = this.location + " + 0x" + Long.toHexString(info.getOffset());
                    }
                }
            }
            if (jthread != null) {
                this.javaThread = jthread;
                this.javaThreadName = jthread.getThreadName();
            }
        }

        public ThreadProxy getThread() {
            return this.thread;
        }

        public boolean hasPC() {
            return this.gotPC;
        }

        public Address getPC() {
            return this.pc;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isJavaThread() {
            return this.javaThread != null;
        }

        public JavaThread getJavaThread() {
            return this.javaThread;
        }

        public String getJavaThreadName() {
            return this.javaThreadName;
        }
    }

    public static interface Listener {
        public void setFocus(ThreadProxy var1, JavaThread var2);
    }
}

