/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.CallInstruction;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;
import sun.jvm.hotspot.asm.x86.X86PCRelativeAddress;

public class X86CallInstruction
extends X86Instruction
implements CallInstruction {
    private final Address addr;

    public X86CallInstruction(String name, Address addr, int size, int prefixes) {
        super(name, size, prefixes);
        this.addr = addr;
        if (addr instanceof X86PCRelativeAddress) {
            ((X86PCRelativeAddress)addr).setInstructionSize(this.getSize());
        }
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        if (this.addr instanceof X86PCRelativeAddress) {
            long disp = ((X86PCRelativeAddress)this.addr).getDisplacement();
            long address = disp + currentPc;
            buf.append(symFinder.getSymbolFor(address));
        } else {
            buf.append(this.addr.toString());
        }
        return buf.toString();
    }

    public Address getBranchDestination() {
        return this.addr;
    }

    public boolean isCall() {
        return true;
    }

    public boolean isConditional() {
        return false;
    }
}

