/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.XScrollRepeater;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;

abstract class XScrollbar {
    private static Logger log = Logger.getLogger("sun.awt.X11.XScrollbar");
    private static XScrollRepeater scroller = new XScrollRepeater(null);
    private XScrollRepeater i_scroller = new XScrollRepeater(null);
    private static final int MIN_THUMB_H = 5;
    private static final int ARROW_IND = 1;
    XScrollbarClient sb;
    private int val;
    private int min;
    private int max;
    private int vis;
    private int line;
    private int page;
    private boolean needsRepaint = true;
    private boolean pressed = false;
    private boolean dragging = false;
    Polygon firstArrow;
    Polygon secondArrow;
    int width;
    int height;
    int barWidth;
    int barLength;
    int arrowArea;
    int alignment;
    public static final int ALIGNMENT_VERTICAL = 1;
    public static final int ALIGNMENT_HORIZONTAL = 2;
    int mode;
    Point thumbOffset;
    private Rectangle prevThumb;

    public XScrollbar(int n, XScrollbarClient xScrollbarClient) {
        this.sb = xScrollbarClient;
        this.alignment = n;
    }

    public boolean needsRepaint() {
        return this.needsRepaint;
    }

    void notifyValue(int n) {
        this.notifyValue(n, false);
    }

    void notifyValue(int n, final boolean bl) {
        if (n < this.min) {
            n = this.min;
        } else if (n > this.max - this.vis) {
            n = this.max - this.vis;
        }
        final int n2 = n;
        final int n3 = this.mode;
        if (!(this.sb == null || n2 == this.val && this.pressed)) {
            SunToolkit.executeOnEventHandlerThread(this.sb.getEventSource(), new Runnable(){

                @Override
                public void run() {
                    XScrollbar.this.sb.notifyValue(XScrollbar.this, n3, n2, bl);
                }
            });
        }
    }

    protected abstract void rebuildArrows();

    public void setSize(int n, int n2) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Setting scroll bar " + this + " size to " + n + "x" + n2);
        }
        this.width = n;
        this.height = n2;
    }

    protected Polygon createArrowShape(boolean bl, boolean bl2) {
        Polygon polygon = new Polygon();
        if (bl) {
            int n = this.width / 2 - this.getArrowWidth() / 2;
            int n2 = bl2 ? 1 : this.barLength - 1;
            int n3 = bl2 ? this.getArrowWidth() : this.barLength - this.getArrowWidth() - 1;
            polygon.addPoint(n + this.getArrowWidth() / 2, n2);
            polygon.addPoint(n + this.getArrowWidth(), n3);
            polygon.addPoint(n, n3);
            polygon.addPoint(n + this.getArrowWidth() / 2, n2);
        } else {
            int n = this.height / 2 - this.getArrowWidth() / 2;
            int n4 = bl2 ? 1 : this.barLength - 1;
            int n5 = bl2 ? this.getArrowWidth() : this.barLength - this.getArrowWidth() - 1;
            polygon.addPoint(n4, n + this.getArrowWidth() / 2);
            polygon.addPoint(n5, n + this.getArrowWidth());
            polygon.addPoint(n5, n);
            polygon.addPoint(n4, n + this.getArrowWidth() / 2);
        }
        return polygon;
    }

    protected abstract Rectangle getThumbArea();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics graphics, Color[] colorArray, boolean bl) {
        Object object;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Painting scrollbar " + this);
        }
        boolean bl2 = false;
        Graphics2D graphics2D = null;
        BufferedImage bufferedImage = null;
        if (!(graphics instanceof Graphics2D)) {
            object = (X11GraphicsConfig)this.sb.getEventSource().getGraphicsConfiguration();
            bufferedImage = ((GraphicsConfiguration)object).createCompatibleImage(this.width, this.height);
            graphics2D = bufferedImage.createGraphics();
            bl2 = true;
        } else {
            graphics2D = (Graphics2D)graphics;
        }
        try {
            this.prevThumb = object = this.calculateThumbRect();
            Color color = colorArray[0];
            Color color2 = new Color(MotifColorUtilities.calculateSelectFromBackground(color.getRed(), color.getGreen(), color.getBlue()));
            Color color3 = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(color.getRed(), color.getGreen(), color.getBlue()));
            Color color4 = new Color(MotifColorUtilities.calculateTopShadowFromBackground(color.getRed(), color.getGreen(), color.getBlue()));
            XToolkit.awtLock();
            try {
                XlibWrapper.XFlush(XToolkit.getDisplay());
            }
            finally {
                XToolkit.awtUnlock();
            }
            if (bl) {
                graphics2D.setColor(color2);
                if (this.alignment == 2) {
                    graphics2D.fillRect(0, 0, ((Rectangle)object).x, this.height);
                    graphics2D.fillRect(((Rectangle)object).x + ((Rectangle)object).width, 0, this.width - (((Rectangle)object).x + ((Rectangle)object).width), this.height);
                } else {
                    graphics2D.fillRect(0, 0, this.width, ((Rectangle)object).y);
                    graphics2D.fillRect(0, ((Rectangle)object).y + ((Rectangle)object).height, this.width, this.height - (((Rectangle)object).y + ((Rectangle)object).height));
                }
                graphics2D.setColor(color3);
                graphics2D.drawLine(0, 0, this.width - 1, 0);
                graphics2D.drawLine(0, 0, 0, this.height - 1);
                graphics2D.setColor(color4);
                graphics2D.drawLine(1, this.height - 1, this.width - 1, this.height - 1);
                graphics2D.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                graphics2D.setColor(color2);
                Rectangle rectangle = this.getThumbArea();
                graphics2D.fill(rectangle);
            }
            if (bl) {
                this.paintArrows(graphics2D, colorArray[0], color3, color4);
            }
            graphics2D.setColor(colorArray[0]);
            graphics2D.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics2D.setColor(color4);
            graphics2D.drawLine(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y);
            graphics2D.drawLine(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).x, ((Rectangle)object).y + ((Rectangle)object).height);
            graphics2D.setColor(color3);
            graphics2D.drawLine(((Rectangle)object).x + 1, ((Rectangle)object).y + ((Rectangle)object).height, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height);
            graphics2D.drawLine(((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + 1, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height);
        }
        finally {
            if (bl2) {
                graphics2D.dispose();
            }
        }
        if (bl2) {
            graphics.drawImage(bufferedImage, 0, 0, null);
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void paintArrows(Graphics2D graphics2D, Color color, Color color2, Color color3) {
        graphics2D.setColor(color);
        if (this.pressed && this.mode == 2) {
            graphics2D.fill(this.firstArrow);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.firstArrow.xpoints[0], this.firstArrow.ypoints[0], this.firstArrow.xpoints[1], this.firstArrow.ypoints[1]);
            graphics2D.drawLine(this.firstArrow.xpoints[1], this.firstArrow.ypoints[1], this.firstArrow.xpoints[2], this.firstArrow.ypoints[2]);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.firstArrow.xpoints[2], this.firstArrow.ypoints[2], this.firstArrow.xpoints[0], this.firstArrow.ypoints[0]);
        } else {
            graphics2D.fill(this.firstArrow);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.firstArrow.xpoints[0], this.firstArrow.ypoints[0], this.firstArrow.xpoints[1], this.firstArrow.ypoints[1]);
            graphics2D.drawLine(this.firstArrow.xpoints[1], this.firstArrow.ypoints[1], this.firstArrow.xpoints[2], this.firstArrow.ypoints[2]);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.firstArrow.xpoints[2], this.firstArrow.ypoints[2], this.firstArrow.xpoints[0], this.firstArrow.ypoints[0]);
        }
        graphics2D.setColor(color);
        if (this.pressed && this.mode == 1) {
            graphics2D.fill(this.secondArrow);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.secondArrow.xpoints[0], this.secondArrow.ypoints[0], this.secondArrow.xpoints[1], this.secondArrow.ypoints[1]);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.secondArrow.xpoints[1], this.secondArrow.ypoints[1], this.secondArrow.xpoints[2], this.secondArrow.ypoints[2]);
            graphics2D.drawLine(this.secondArrow.xpoints[2], this.secondArrow.ypoints[2], this.secondArrow.xpoints[0], this.secondArrow.ypoints[0]);
        } else {
            graphics2D.fill(this.secondArrow);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.secondArrow.xpoints[0], this.secondArrow.ypoints[0], this.secondArrow.xpoints[1], this.secondArrow.ypoints[1]);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.secondArrow.xpoints[1], this.secondArrow.ypoints[1], this.secondArrow.xpoints[2], this.secondArrow.ypoints[2]);
            graphics2D.drawLine(this.secondArrow.xpoints[2], this.secondArrow.ypoints[2], this.secondArrow.xpoints[0], this.secondArrow.ypoints[0]);
        }
    }

    void startScrolling() {
        log.finer("Start scrolling on " + this);
        this.scroll();
        if (scroller == null) {
            scroller = new XScrollRepeater(this);
        } else {
            scroller.setScrollbar(this);
        }
        scroller.start();
    }

    void startScrollingInstance() {
        log.finer("Start scrolling on " + this);
        this.scroll();
        this.i_scroller.setScrollbar(this);
        this.i_scroller.start();
    }

    void stopScrollingInstance() {
        log.finer("Stop scrolling on " + this);
        this.i_scroller.stop();
    }

    public void setMode(int n) {
        this.mode = n;
    }

    void scroll() {
        switch (this.mode) {
            case 2: {
                this.notifyValue(this.val - this.line);
                return;
            }
            case 1: {
                this.notifyValue(this.val + this.line);
                return;
            }
            case 3: {
                this.notifyValue(this.val - this.page);
                return;
            }
            case 4: {
                this.notifyValue(this.val + this.page);
                return;
            }
        }
    }

    boolean isInArrow(int n, int n2) {
        int n3;
        int n4 = this.alignment == 2 ? n : n2;
        return n4 < (n3 = this.getArrowAreaWidth()) || n4 > this.barLength - n3 + 1;
    }

    boolean isInThumb(int n, int n2) {
        Rectangle rectangle = this.calculateThumbRect();
        --rectangle.x;
        rectangle.width += 3;
        ++rectangle.height;
        return rectangle.contains(n, n2);
    }

    abstract boolean beforeThumb(int var1, int var2);

    public void handleMouseEvent(int n, int n2, int n3, int n4) {
        Object object;
        if ((n2 & 0x10) == 0) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            switch (n) {
                case 501: {
                    object = "press";
                    break;
                }
                case 502: {
                    object = "release";
                    break;
                }
                case 506: {
                    object = "drag";
                    break;
                }
                default: {
                    object = "other";
                }
            }
            log.finer("Mouse " + (String)object + " event in scroll bar " + this + "x = " + n3 + ", y = " + n4 + ", on arrow: " + this.isInArrow(n3, n4) + ", on thumb: " + this.isInThumb(n3, n4) + ", before thumb: " + this.beforeThumb(n3, n4) + ", thumb rect" + this.calculateThumbRect());
        }
        switch (n) {
            case 501: {
                if (this.isInArrow(n3, n4)) {
                    this.pressed = true;
                    this.mode = this.beforeThumb(n3, n4) ? 2 : 1;
                    this.sb.repaintScrollbarRequest(this);
                    this.startScrolling();
                    break;
                }
                if (this.isInThumb(n3, n4)) {
                    this.mode = 5;
                } else {
                    this.mode = this.beforeThumb(n3, n4) ? 3 : 4;
                    this.startScrolling();
                }
                object = this.calculateThumbRect();
                this.thumbOffset = new Point(n3 - ((Rectangle)object).x, n4 - ((Rectangle)object).y);
                break;
            }
            case 502: {
                this.pressed = false;
                this.sb.repaintScrollbarRequest(this);
                scroller.stop();
                if (!this.dragging) break;
                this.handleTrackEvent(n3, n4, false);
                this.dragging = false;
                break;
            }
            case 506: {
                this.dragging = true;
                this.handleTrackEvent(n3, n4, true);
            }
        }
    }

    private void handleTrackEvent(int n, int n2, boolean bl) {
        if (this.mode == 5) {
            this.notifyValue(this.calculateCursorOffset(n, n2), bl);
        }
    }

    private int calculateCursorOffset(int n, int n2) {
        if (this.alignment == 2) {
            if (this.dragging) {
                return Math.max(0, (int)((double)(n - (this.thumbOffset.x + this.getArrowAreaWidth())) / this.getScaleFactor())) + this.min;
            }
            return Math.max(0, (int)((double)(n - this.getArrowAreaWidth()) / this.getScaleFactor())) + this.min;
        }
        if (this.dragging) {
            return Math.max(0, (int)((double)(n2 - (this.thumbOffset.y + this.getArrowAreaWidth())) / this.getScaleFactor())) + this.min;
        }
        return Math.max(0, (int)((double)(n2 - this.getArrowAreaWidth()) / this.getScaleFactor())) + this.min;
    }

    synchronized void setValues(int n, int n2, int n3, int n4) {
        if (n4 <= n3) {
            n4 = n3 + 1;
        }
        if (n2 > n4 - n3) {
            n2 = n4 - n3;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4 - n2) {
            n = n4 - n2;
        }
        this.val = n;
        this.vis = n2;
        this.min = n3;
        this.max = n4;
    }

    synchronized void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setValues(n, n2, n3, n4);
        this.setUnitIncrement(n5);
        this.setBlockIncrement(n6);
    }

    int getValue() {
        return this.val;
    }

    synchronized void setValue(int n) {
        this.setValues(n, this.vis, this.min, this.max);
    }

    int getMinimum() {
        return this.min;
    }

    synchronized void setMinimum(int n) {
        this.setValues(this.val, this.vis, n, this.max);
    }

    int getMaximum() {
        return this.max;
    }

    synchronized void setMaximum(int n) {
        this.setValues(this.val, this.vis, this.min, n);
    }

    int getVisibleAmount() {
        return this.vis;
    }

    synchronized void setVisibleAmount(int n) {
        this.setValues(this.val, n, this.min, this.max);
    }

    synchronized void setUnitIncrement(int n) {
        this.line = n;
    }

    int getUnitIncrement() {
        return this.line;
    }

    synchronized void setBlockIncrement(int n) {
        this.page = n;
    }

    int getBlockIncrement() {
        return this.page;
    }

    int getArrowWidth() {
        return this.getArrowAreaWidth() - 2;
    }

    int getArrowAreaWidth() {
        return this.arrowArea;
    }

    void calculateArrowWidth() {
        this.arrowArea = this.barLength < 2 * this.barWidth + 5 + 2 ? (this.barLength - 5 + 2) / 2 - 1 : this.barWidth - 1;
    }

    private double getScaleFactor() {
        double d = (double)(this.barLength - 2 * this.getArrowAreaWidth()) / (double)Math.max(1, this.max - this.min);
        return d;
    }

    protected Rectangle calculateThumbRect() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.getArrowAreaWidth();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        float f = this.barLength - 2 * n4 - 1;
        if (this.alignment == 2) {
            n2 = 5;
            n = this.height - 3;
        } else {
            n2 = this.width - 3;
            n = 5;
        }
        float f2 = this.max - this.min;
        float f3 = f / f2;
        float f4 = (float)this.vis * f3;
        if (this.alignment == 2) {
            int n5 = (int)((double)f4 + 0.5);
            int n6 = n2;
            if (n5 > n6) {
                rectangle.width = n5;
            } else {
                rectangle.width = n6;
                n3 = n6;
            }
            rectangle.height = n;
        } else {
            rectangle.width = n2;
            int n7 = (int)((double)f4 + 0.5);
            int n8 = n;
            if (n7 > n8) {
                rectangle.height = n7;
            } else {
                rectangle.height = n8;
                n3 = n8;
            }
        }
        if (n3 != 0) {
            f3 = (f -= (float)n3) / (f2 -= (float)this.vis);
        }
        if (this.alignment == 2) {
            rectangle.x = (int)((double)(((float)this.val - (float)this.min) * f3) + 0.5) + n4;
            rectangle.y = 1;
        } else {
            rectangle.x = 1;
            rectangle.y = (int)((double)(((float)this.val - (float)this.min) * f3) + 0.5) + n4;
        }
        return rectangle;
    }

    public String toString() {
        return this.getClass() + "[" + this.width + "x" + this.height + "," + this.barWidth + "x" + this.barLength + "]";
    }
}

