/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XToolkitThreadBlockedHandler;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;

public class XDataTransferer
extends DataTransferer {
    static final XAtom FILE_NAME_ATOM = XAtom.get("FILE_NAME");
    static final XAtom DT_NET_FILE_ATOM = XAtom.get("_DT_NETFILE");
    static final XAtom PNG_ATOM = XAtom.get("PNG");
    static final XAtom JFIF_ATOM = XAtom.get("JFIF");
    static final XAtom TARGETS_ATOM = XAtom.get("TARGETS");
    static final XAtom INCR_ATOM = XAtom.get("INCR");
    static final XAtom MULTIPLE_ATOM = XAtom.get("MULTIPLE");
    private static XDataTransferer transferer;
    private static ImageTypeSpecifier defaultSpecifier;

    private XDataTransferer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XDataTransferer getInstanceImpl() {
        Class<XDataTransferer> clazz = XDataTransferer.class;
        synchronized (XDataTransferer.class) {
            if (transferer == null) {
                transferer = new XDataTransferer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return transferer;
        }
    }

    @Override
    public String getDefaultUnicodeEncoding() {
        return "iso-10646-ucs-2";
    }

    @Override
    public boolean isLocaleDependentTextFormat(long l) {
        return false;
    }

    @Override
    public boolean isTextFormat(long l) {
        return super.isTextFormat(l) || this.isMimeFormat(l, "text");
    }

    @Override
    protected String getCharsetForTextFormat(Long l) {
        long l2 = l;
        if (this.isMimeFormat(l2, "text")) {
            String string = this.getNativeForFormat(l2);
            DataFlavor dataFlavor = new DataFlavor(string, null);
            if (!DataTransferer.doesSubtypeSupportCharset(dataFlavor)) {
                return null;
            }
            String string2 = dataFlavor.getParameter("charset");
            if (string2 != null) {
                return string2;
            }
        }
        return super.getCharsetForTextFormat(l);
    }

    @Override
    public boolean isFileFormat(long l) {
        return l == FILE_NAME_ATOM.getAtom() || l == DT_NET_FILE_ATOM.getAtom();
    }

    @Override
    public boolean isImageFormat(long l) {
        return l == PNG_ATOM.getAtom() || l == JFIF_ATOM.getAtom() || this.isMimeFormat(l, "image");
    }

    @Override
    protected Long getFormatForNativeAsLong(String string) {
        long l = XAtom.get(string).getAtom();
        return l;
    }

    @Override
    protected String getNativeForFormat(long l) {
        return this.getTargetNameForAtom(l);
    }

    @Override
    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return XToolkitThreadBlockedHandler.getToolkitThreadBlockedHandler();
    }

    private String getTargetNameForAtom(long l) {
        return XAtom.get(l).getName();
    }

    @Override
    protected byte[] imageToPlatformBytes(Image image, long l) throws IOException {
        String string;
        String string2 = null;
        if (l == PNG_ATOM.getAtom()) {
            string2 = "image/png";
        } else if (l == JFIF_ATOM.getAtom()) {
            string2 = "image/jpeg";
        } else {
            try {
                string = this.getNativeForFormat(l);
                DataFlavor dataFlavor = new DataFlavor(string);
                String string3 = dataFlavor.getPrimaryType();
                if ("image".equals(string3)) {
                    string2 = dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return this.imageToStandardBytes(image, string2);
        }
        string = this.getNativeForFormat(l);
        throw new IOException("Translation to " + string + " is not supported.");
    }

    @Override
    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l) throws IOException {
        String string;
        String string2 = null;
        if (l == PNG_ATOM.getAtom()) {
            string2 = "image/png";
        } else if (l == JFIF_ATOM.getAtom()) {
            string2 = "image/jpeg";
        } else {
            try {
                string = this.getNativeForFormat(l);
                DataFlavor dataFlavor = new DataFlavor(string);
                String string3 = dataFlavor.getPrimaryType();
                if ("image".equals(string3)) {
                    string2 = dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return this.standardImageBytesOrStreamToImage(inputStream, byArray, string2);
        }
        string = this.getNativeForFormat(l);
        throw new IOException("Translation from " + string + " is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] dragQueryFile(byte[] byArray) {
        XToolkit.awtLock();
        try {
            String[] stringArray = XlibWrapper.XTextPropertyToStringList(byArray, XAtom.get("STRING").getAtom());
            return stringArray;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private boolean isMimeFormat(long l, String string) {
        String string2 = this.getNativeForFormat(l);
        if (string2 == null) {
            return false;
        }
        try {
            DataFlavor dataFlavor = new DataFlavor(string2);
            if (string.equals(dataFlavor.getPrimaryType())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public List getPlatformMappingsForNative(String string) {
        Iterator<ImageReader> iterator;
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
        if (string == null) {
            return arrayList;
        }
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(string);
        }
        catch (Exception exception) {
            return arrayList;
        }
        Object object = dataFlavor;
        String string2 = dataFlavor.getPrimaryType();
        String string3 = string2 + "/" + dataFlavor.getSubType();
        if ("text".equals(string2)) {
            object = string2 + "/" + dataFlavor.getSubType();
        } else if ("image".equals(string2) && (iterator = ImageIO.getImageReadersByMIMEType(string3)).hasNext()) {
            arrayList.add(DataFlavor.imageFlavor);
        }
        arrayList.add((DataFlavor)object);
        return arrayList;
    }

    private ImageTypeSpecifier getDefaultImageTypeSpecifier() {
        if (defaultSpecifier == null) {
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(10, 10);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            defaultSpecifier = new ImageTypeSpecifier(bufferedImage);
        }
        return defaultSpecifier;
    }

    @Override
    public List getPlatformMappingsForFlavor(DataFlavor dataFlavor) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (dataFlavor == null) {
            return arrayList;
        }
        String string2 = dataFlavor.getParameter("charset");
        String string3 = string = dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
        if (string2 != null && DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            string3 = string3 + ";charset=" + string2;
        }
        if (dataFlavor.getRepresentationClass() != null && (dataFlavor.isRepresentationClassInputStream() || dataFlavor.isRepresentationClassByteBuffer() || byteArrayClass.equals(dataFlavor.getRepresentationClass()))) {
            arrayList.add(string3);
        }
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            String[] stringArray = ImageIO.getWriterMIMETypes();
            if (stringArray != null) {
                block0: for (int i = 0; i < stringArray.length; ++i) {
                    Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(stringArray[i]);
                    while (iterator.hasNext()) {
                        ImageWriter imageWriter = iterator.next();
                        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
                        if (imageWriterSpi == null || !imageWriterSpi.canEncodeImage(this.getDefaultImageTypeSpecifier())) continue;
                        arrayList.add(stringArray[i]);
                        continue block0;
                    }
                }
            }
        } else if (DataTransferer.isFlavorCharsetTextType(dataFlavor)) {
            Iterator iterator = DataTransferer.standardEncodings();
            if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                string = "text/plain";
            }
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (string4.equals(string2)) continue;
                arrayList.add(string + ";charset=" + string4);
            }
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    static {
        defaultSpecifier = null;
    }
}

