/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.ColorChooserPanel;
import javax.swing.colorchooser.ColorModel;
import javax.swing.colorchooser.SlidingSpinner;

final class ColorPanel
extends JPanel
implements ActionListener {
    private final SlidingSpinner[] spinners = new SlidingSpinner[5];
    private final float[] values = new float[this.spinners.length];
    private final ColorModel model;
    private Color color;
    private int x = 1;
    private int y = 2;
    private int z;

    ColorPanel(ColorModel colorModel) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        ButtonGroup buttonGroup = new ButtonGroup();
        EmptyBorder emptyBorder = null;
        for (int i = 0; i < this.spinners.length; ++i) {
            JComponent jComponent;
            if (i < 3) {
                jComponent = new JRadioButton();
                if (i == 0) {
                    Insets insets = jComponent.getInsets();
                    insets.left = jComponent.getPreferredSize().width;
                    emptyBorder = new EmptyBorder(insets);
                    ((AbstractButton)jComponent).setSelected(true);
                    gridBagConstraints.insets.top = 5;
                }
                this.add((Component)jComponent, gridBagConstraints);
                buttonGroup.add((AbstractButton)jComponent);
                ((AbstractButton)jComponent).setActionCommand(Integer.toString(i));
                ((AbstractButton)jComponent).addActionListener(this);
                this.spinners[i] = new SlidingSpinner(this, jComponent);
                continue;
            }
            jComponent = new JLabel();
            this.add((Component)jComponent, gridBagConstraints);
            jComponent.setBorder(emptyBorder);
            jComponent.setFocusable(false);
            this.spinners[i] = new SlidingSpinner(this, jComponent);
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 5;
        for (SlidingSpinner slidingSpinner : this.spinners) {
            this.add((Component)slidingSpinner.getSlider(), gridBagConstraints);
            gridBagConstraints.insets.top = 5;
        }
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 0;
        for (SlidingSpinner slidingSpinner : this.spinners) {
            this.add((Component)slidingSpinner.getSpinner(), gridBagConstraints);
            gridBagConstraints.insets.top = 5;
        }
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusable(false);
        this.model = colorModel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.z = Integer.parseInt(actionEvent.getActionCommand());
            this.y = this.z != 2 ? 2 : 1;
            this.x = this.z != 0 ? 0 : 1;
            this.getParent().repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void buildPanel() {
        int n = this.model.getCount();
        this.spinners[4].setVisible(n > 4);
        for (int i = 0; i < n; ++i) {
            JComponent jComponent;
            JComponent jComponent2 = this.spinners[i].getLabel();
            if (jComponent2 instanceof JRadioButton) {
                jComponent = (JRadioButton)jComponent2;
                ((AbstractButton)jComponent).setText(this.model.getLabel(this, i));
            } else if (jComponent2 instanceof JLabel) {
                jComponent = (JLabel)jComponent2;
                ((JLabel)jComponent).setText(this.model.getLabel(this, i));
            }
            this.spinners[i].setRange(this.model.getMinimum(i), this.model.getMaximum(i));
            this.spinners[i].setValue(this.values[i]);
        }
    }

    void colorChanged() {
        this.color = new Color(this.getColor(0), true);
        Container container = this.getParent();
        if (container instanceof ColorChooserPanel) {
            ColorChooserPanel colorChooserPanel = (ColorChooserPanel)container;
            colorChooserPanel.setSelectedColor(this.color);
            colorChooserPanel.repaint();
        }
    }

    float getValueX() {
        return this.spinners[this.x].getValue();
    }

    float getValueY() {
        return 1.0f - this.spinners[this.y].getValue();
    }

    float getValueZ() {
        return 1.0f - this.spinners[this.z].getValue();
    }

    void setValue(float f) {
        this.spinners[this.z].setValue(1.0f - f);
        this.colorChanged();
    }

    void setValue(float f, float f2) {
        this.spinners[this.x].setValue(f);
        this.spinners[this.y].setValue(1.0f - f2);
        this.colorChanged();
    }

    int getColor(float f) {
        this.setDefaultValue(this.x);
        this.setDefaultValue(this.y);
        this.values[this.z] = 1.0f - f;
        return this.getColor(3);
    }

    int getColor(float f, float f2) {
        this.values[this.x] = f;
        this.values[this.y] = 1.0f - f2;
        this.setValue(this.z);
        return this.getColor(3);
    }

    void setColor(Color color) {
        if (!color.equals(this.color)) {
            this.color = color;
            this.model.setColor(color.getRGB(), this.values);
            for (int i = 0; i < this.model.getCount(); ++i) {
                this.spinners[i].setValue(this.values[i]);
            }
        }
    }

    private int getColor(int n) {
        while (n < this.model.getCount()) {
            this.setValue(n++);
        }
        return this.model.getColor(this.values);
    }

    private void setValue(int n) {
        this.values[n] = this.spinners[n].getValue();
    }

    private void setDefaultValue(int n) {
        float f = this.model.getDefault(n);
        this.values[n] = f < 0.0f ? this.spinners[n].getValue() : f;
    }
}

