/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.interceptor.SingleMBeanForwarder;
import com.sun.jmx.namespace.RoutingConnectionProxy;
import com.sun.jmx.namespace.RoutingProxy;
import com.sun.jmx.namespace.RoutingServerProxy;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.management.namespace.JMXNamespace;
import javax.management.namespace.JMXNamespaceMBean;
import javax.management.namespace.JMXNamespaces;
import javax.management.namespace.MBeanServerSupport;
import javax.management.remote.IdentityMBeanServerForwarder;
import javax.management.remote.MBeanServerForwarder;

public class ClientContext {
    public static final String LOCALE_KEY = "jmx.locale";
    private static final Logger LOG = Logger.getLogger("javax.management.context");
    public static final String NAMESPACE = "jmx.context";
    private static final String NAMESPACE_PLUS_SEP = "jmx.context//";
    static final ObjectName CLIENT_CONTEXT_NAMESPACE_HANDLER = ObjectName.valueOf("jmx.context//:type=JMXNamespace");
    private static final ObjectName NAMESPACE_HANDLER_WITHOUT_NAMESPACE = ObjectName.valueOf(":type=JMXNamespace");
    private static final ThreadLocal<Map<String, String>> contextThreadLocal = new InheritableThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return Collections.emptyMap();
        }
    };

    private ClientContext() {
    }

    public static Map<String, String> getContext() {
        return Collections.unmodifiableMap(contextThreadLocal.get());
    }

    public static Locale getLocale() {
        String string;
        String string2;
        String string3;
        String string4 = ClientContext.getContext().get(LOCALE_KEY);
        if (string4 == null) {
            return Locale.getDefault();
        }
        int n = string4.indexOf(95);
        if (n < 0) {
            string3 = string4;
            string2 = "";
            string = "";
        } else {
            string3 = string4.substring(0, n);
            if ((n = (string4 = string4.substring(n + 1)).indexOf(95)) < 0) {
                string = string4;
                string2 = "";
            } else {
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        }
        return new Locale(string3, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doWithContext(Map<String, String> map, Callable<T> callable) throws Exception {
        if (map == null || callable == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(map);
        ClientContext.validateContext(treeMap);
        Map<String, String> map2 = contextThreadLocal.get();
        try {
            contextThreadLocal.set(treeMap);
            T t = callable.call();
            return t;
        }
        finally {
            contextThreadLocal.set(map2);
        }
    }

    private static void validateContext(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string == null || string2 == null) {
                throw new IllegalArgumentException("Null key or value in context");
            }
            if (!string.equals("")) continue;
            throw new IllegalArgumentException("Empty key in context");
        }
    }

    public static MBeanServer withLocale(MBeanServer mBeanServer, Locale locale) {
        return ClientContext.withLocale(mBeanServer, MBeanServer.class, locale);
    }

    public static MBeanServerConnection withLocale(MBeanServerConnection mBeanServerConnection, Locale locale) {
        return ClientContext.withLocale(mBeanServerConnection, MBeanServerConnection.class, locale);
    }

    private static <T extends MBeanServerConnection> T withLocale(T t, Class<T> clazz, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Null locale");
        }
        return ClientContext.withContext(t, clazz, LOCALE_KEY, locale.toString());
    }

    public static MBeanServer withContext(MBeanServer mBeanServer, String string, String string2) {
        return ClientContext.withContext(mBeanServer, MBeanServer.class, string, string2);
    }

    public static MBeanServerConnection withContext(MBeanServerConnection mBeanServerConnection, String string, String string2) {
        return ClientContext.withContext(mBeanServerConnection, MBeanServerConnection.class, string, string2);
    }

    public static MBeanServerConnection withDynamicContext(MBeanServerConnection mBeanServerConnection) {
        JMXNamespaces.narrowToNamespace(mBeanServerConnection, NAMESPACE);
        return (MBeanServerConnection)Proxy.newProxyInstance(MBeanServerConnection.class.getClassLoader(), new Class[]{MBeanServerConnection.class}, new DynamicContextIH(mBeanServerConnection));
    }

    private static <T extends MBeanServerConnection> T withContext(T t, Class<T> clazz, String string, String string2) {
        return ClientContext.withContext(t, clazz, Collections.singletonMap(string, string2), true);
    }

    private static <T extends MBeanServerConnection> T withContext(T object, Class<T> clazz, Map<String, String> map, boolean bl) {
        String string;
        Object object2;
        String string2;
        if (object == null || map == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        if (map.isEmpty()) {
            return object;
        }
        ClientContext.validateContext(map);
        Map<String, String> map2 = null;
        if ((object.getClass() == RoutingServerProxy.class || object.getClass() == RoutingProxy.class) && (string2 = ((RoutingProxy)(object2 = (RoutingProxy)object)).getSourceNamespace()).startsWith(NAMESPACE_PLUS_SEP) && (string = string2.substring(NAMESPACE_PLUS_SEP.length())).indexOf("//") < 0 && (map2 = ClientContext.stringToMapOrNull(string)) != null) {
            map2.putAll(map);
            object = (MBeanServerConnection)clazz.cast(((RoutingProxy)object2).source());
        }
        if (map2 == null) {
            map2 = map;
        }
        object2 = NAMESPACE_PLUS_SEP + ClientContext.mapToString(map2);
        if (clazz == MBeanServer.class) {
            return (T)((MBeanServerConnection)clazz.cast(RoutingServerProxy.cd((MBeanServer)object, (String)object2, bl)));
        }
        if (clazz == MBeanServerConnection.class) {
            return (T)((MBeanServerConnection)clazz.cast(RoutingConnectionProxy.cd(object, (String)object2, bl)));
        }
        throw new AssertionError((Object)("Bad MBSC: " + clazz));
    }

    public static String encode(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string == null || string2 == null) {
                throw new IllegalArgumentException("Null key or value");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(ClientContext.encode(string)).append("=").append(ClientContext.encode(string2));
        }
        stringBuilder.insert(0, NAMESPACE_PLUS_SEP);
        return stringBuilder.toString();
    }

    public static MBeanServerForwarder newContextForwarder(MBeanServer mBeanServer, MBeanServer mBeanServer2) {
        final IdentityMBeanServerForwarder identityMBeanServerForwarder = new IdentityMBeanServerForwarder(mBeanServer);
        StandardMBean standardMBean = new StandardMBean(new JMXNamespace(identityMBeanServerForwarder), JMXNamespaceMBean.class, false);
        SingleMBeanForwarder singleMBeanForwarder = new SingleMBeanForwarder(CLIENT_CONTEXT_NAMESPACE_HANDLER, standardMBean, true){

            @Override
            public MBeanServer getMBeanServer() {
                return ((MBeanServerForwarder)super.getMBeanServer()).getMBeanServer();
            }

            @Override
            public void setMBeanServer(MBeanServer mBeanServer) {
                MBeanServerForwarder mBeanServerForwarder = (MBeanServerForwarder)super.getMBeanServer();
                if (mBeanServerForwarder != null) {
                    mBeanServerForwarder.setMBeanServer(mBeanServer);
                } else {
                    super.setMBeanServer(mBeanServer);
                }
                identityMBeanServerForwarder.setMBeanServer(mBeanServer);
            }
        };
        if (mBeanServer2 == null) {
            mBeanServer2 = singleMBeanForwarder;
        }
        ContextInvocationHandler contextInvocationHandler = new ContextInvocationHandler(mBeanServer, mBeanServer2);
        MBeanServerForwarder mBeanServerForwarder = ClientContext.newForwarderProxy(contextInvocationHandler);
        singleMBeanForwarder.setMBeanServer(mBeanServerForwarder);
        return singleMBeanForwarder;
    }

    public static MBeanServerForwarder newLocalizeMBeanInfoForwarder(MBeanServer mBeanServer) {
        return new IdentityMBeanServerForwarder(mBeanServer){

            @Override
            public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
                MBeanInfo mBeanInfo = super.getMBeanInfo(objectName);
                Locale locale = ClientContext.getLocale();
                ClassLoader classLoader = this.getClassLoaderFor(objectName);
                return mBeanInfo.localizeDescriptions(locale, classLoader);
            }
        };
    }

    private static MBeanServerForwarder newForwarderProxy(InvocationHandler invocationHandler) {
        return (MBeanServerForwarder)Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), new Class[]{MBeanServerForwarder.class}, invocationHandler);
    }

    private static String mapToString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = ClientContext.encode(entry.getKey());
            String string2 = ClientContext.encode(entry.getValue());
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(string).append("=").append(string2);
        }
        return stringBuilder.toString();
    }

    private static Map<String, String> stringToMap(String string) {
        Map<String, String> map = ClientContext.stringToMapOrNull(string);
        if (map == null) {
            throw new IllegalArgumentException("Invalid encoded context: " + string);
        }
        return map;
    }

    private static Map<String, String> stringToMapOrNull(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n < 0) {
                return null;
            }
            String string3 = ClientContext.decode(string2.substring(0, n));
            if (string3.equals("")) {
                return null;
            }
            String string4 = ClientContext.decode(string2.substring(n + 1));
            linkedHashMap.put(string3, string4);
        }
        return linkedHashMap;
    }

    private static String encode(String string) {
        try {
            string = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return string.replace("*", "%2A");
    }

    private static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static class ContextInvocationHandler
    implements InvocationHandler {
        private MBeanServer forwardMBS;
        private final MBeanServer loopMBS;
        private static final MBeanServer emptyMBS = new MBeanServerSupport(){

            @Override
            public DynamicMBean getDynamicMBeanFor(ObjectName objectName) throws InstanceNotFoundException {
                throw new InstanceNotFoundException(objectName.toString());
            }

            @Override
            protected Set<ObjectName> getNames() {
                return Collections.emptySet();
            }
        };

        ContextInvocationHandler(MBeanServer mBeanServer, MBeanServer mBeanServer2) {
            this.forwardMBS = mBeanServer;
            StandardMBean standardMBean = new StandardMBean(new JMXNamespace(mBeanServer2), JMXNamespaceMBean.class, false);
            SingleMBeanForwarder singleMBeanForwarder = new SingleMBeanForwarder(NAMESPACE_HANDLER_WITHOUT_NAMESPACE, standardMBean, false);
            singleMBeanForwarder.setMBeanServer(mBeanServer2);
            this.loopMBS = singleMBeanForwarder;
        }

        @Override
        public Object invoke(Object object, final Method method, final Object[] objectArray) throws Throwable {
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (string.equals("getMBeanServer")) {
                return this.forwardMBS;
            }
            if (string.equals("setMBeanServer")) {
                this.forwardMBS = (MBeanServer)objectArray[0];
                return null;
            }
            int n = -1;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] != ObjectName.class) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return ContextInvocationHandler.invoke(method, this.forwardMBS, objectArray);
            }
            ObjectName objectName = (ObjectName)objectArray[n];
            if (objectName == null || !objectName.getDomain().startsWith(ClientContext.NAMESPACE_PLUS_SEP)) {
                return ContextInvocationHandler.invoke(method, this.forwardMBS, objectArray);
            }
            String string2 = objectName.getDomain().substring(ClientContext.NAMESPACE_PLUS_SEP.length());
            int n2 = string2.indexOf("//");
            if (n2 < 0) {
                return ContextInvocationHandler.invoke(method, emptyMBS, objectArray);
            }
            final String string3 = string2.substring(0, n2);
            if (method.getName().startsWith("query") && (string3.contains("*") || string3.contains("?"))) {
                return Collections.EMPTY_SET;
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>(ClientContext.getContext());
            treeMap.putAll(ClientContext.stringToMap(string3));
            return ClientContext.doWithContext(treeMap, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String string = ClientContext.NAMESPACE_PLUS_SEP + string3;
                    ContextRoutingConnection contextRoutingConnection = new ContextRoutingConnection(ContextInvocationHandler.this.loopMBS, string);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("context=" + string3);
                    }
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer(method.getName() + "" + (objectArray == null ? "()" : "" + Arrays.asList(objectArray)));
                    }
                    return ContextInvocationHandler.invoke(method, contextRoutingConnection, objectArray);
                }
            });
        }

        private static Object invoke(Method method, Object object, Object[] objectArray) throws Exception {
            try {
                return method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw (Exception)throwable;
            }
        }
    }

    private static final class ContextRoutingConnection
    extends RoutingServerProxy {
        public ContextRoutingConnection(MBeanServer mBeanServer, String string) {
            super(mBeanServer, "", string, false);
        }

        @Override
        public Integer getMBeanCount() {
            return ((MBeanServer)this.source()).getMBeanCount();
        }

        @Override
        public String[] getDomains() {
            return ((MBeanServer)this.source()).getDomains();
        }

        @Override
        public String getDefaultDomain() {
            return ((MBeanServer)this.source()).getDefaultDomain();
        }
    }

    private static class DynamicContextIH
    implements InvocationHandler {
        private final MBeanServerConnection mbsc;

        public DynamicContextIH(MBeanServerConnection mBeanServerConnection) {
            this.mbsc = mBeanServerConnection;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            MBeanServerConnection mBeanServerConnection = ClientContext.withContext(this.mbsc, MBeanServerConnection.class, ClientContext.getContext(), false);
            try {
                return method.invoke(mBeanServerConnection, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }
}

