/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryRelQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -5690656271650491000L;
    private int relOp;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryRelQueryExp() {
    }

    public BinaryRelQueryExp(int n, ValueExp valueExp, ValueExp valueExp2) {
        this.relOp = n;
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
    }

    public int getOperator() {
        return this.relOp;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    @Override
    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExp = this.exp1.apply(objectName);
        ValueExp valueExp2 = this.exp2.apply(objectName);
        boolean bl = valueExp instanceof NumericValueExp;
        boolean bl2 = valueExp instanceof BooleanValueExp;
        if (bl) {
            if (((NumericValueExp)valueExp).isLong()) {
                long l = ((NumericValueExp)valueExp).longValue();
                long l2 = ((NumericValueExp)valueExp2).longValue();
                switch (this.relOp) {
                    case 0: {
                        return l > l2;
                    }
                    case 1: {
                        return l < l2;
                    }
                    case 2: {
                        return l >= l2;
                    }
                    case 3: {
                        return l <= l2;
                    }
                    case 4: {
                        return l == l2;
                    }
                }
            } else {
                double d = ((NumericValueExp)valueExp).doubleValue();
                double d2 = ((NumericValueExp)valueExp2).doubleValue();
                switch (this.relOp) {
                    case 0: {
                        return d > d2;
                    }
                    case 1: {
                        return d < d2;
                    }
                    case 2: {
                        return d >= d2;
                    }
                    case 3: {
                        return d <= d2;
                    }
                    case 4: {
                        return d == d2;
                    }
                }
            }
        } else if (bl2) {
            boolean bl3 = ((BooleanValueExp)valueExp).getValue();
            boolean bl4 = ((BooleanValueExp)valueExp2).getValue();
            switch (this.relOp) {
                case 0: {
                    return bl3 && !bl4;
                }
                case 1: {
                    return !bl3 && bl4;
                }
                case 2: {
                    return bl3 || !bl4;
                }
                case 3: {
                    return !bl3 || bl4;
                }
                case 4: {
                    return bl3 == bl4;
                }
            }
        } else {
            String string = ((StringValueExp)valueExp).getValue();
            String string2 = ((StringValueExp)valueExp2).getValue();
            switch (this.relOp) {
                case 0: {
                    return string.compareTo(string2) > 0;
                }
                case 1: {
                    return string.compareTo(string2) < 0;
                }
                case 2: {
                    return string.compareTo(string2) >= 0;
                }
                case 3: {
                    return string.compareTo(string2) <= 0;
                }
                case 4: {
                    return string.compareTo(string2) == 0;
                }
            }
        }
        return false;
    }

    public String toString() {
        return "(" + this.exp1 + ") " + this.relOpString() + " (" + this.exp2 + ")";
    }

    @Override
    String toQueryString() {
        return this.exp1 + " " + this.relOpString() + " " + this.exp2;
    }

    private String relOpString() {
        switch (this.relOp) {
            case 0: {
                return ">";
            }
            case 1: {
                return "<";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "=";
            }
        }
        return "=";
    }
}

