/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.NameGenerator;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.lang.ref.Reference;
import java.lang.reflect.Method;

public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Reference<Class> indexedPropertyTypeRef;
    private Reference<Method> indexedReadMethodRef;
    private Reference<Method> indexedWriteMethodRef;
    private String indexedReadMethodName;
    private String indexedWriteMethodName;

    public IndexedPropertyDescriptor(String string, Class<?> clazz) throws IntrospectionException {
        this(string, clazz, "get" + NameGenerator.capitalize(string), "set" + NameGenerator.capitalize(string), "get" + NameGenerator.capitalize(string), "set" + NameGenerator.capitalize(string));
    }

    public IndexedPropertyDescriptor(String string, Class<?> clazz, String string2, String string3, String string4, String string5) throws IntrospectionException {
        super(string, clazz, string2, string3);
        this.indexedReadMethodName = string4;
        if (string4 != null && this.getIndexedReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + string4);
        }
        this.indexedWriteMethodName = string5;
        if (string5 != null && this.getIndexedWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + string5);
        }
        this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
    }

    public IndexedPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(string, method, method2);
        this.setIndexedReadMethod0(method3);
        this.setIndexedWriteMethod0(method4);
        this.setIndexedPropertyType(this.findIndexedPropertyType(method3, method4));
    }

    IndexedPropertyDescriptor(Class<?> clazz, String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(clazz, string, method, method2);
        this.setIndexedReadMethod0(method3);
        this.setIndexedWriteMethod0(method4);
        this.setIndexedPropertyType(this.findIndexedPropertyType(method3, method4));
    }

    public synchronized Method getIndexedReadMethod() {
        Method method = this.getIndexedReadMethod0();
        if (method == null) {
            Class[] classArray;
            Class clazz = this.getClass0();
            if (clazz == null || this.indexedReadMethodName == null && this.indexedReadMethodRef == null) {
                return null;
            }
            if (this.indexedReadMethodName == null) {
                classArray = this.getIndexedPropertyType0();
                this.indexedReadMethodName = classArray == Boolean.TYPE || classArray == null ? "is" + this.getBaseName() : "get" + this.getBaseName();
            }
            if ((method = Introspector.findMethod(clazz, this.indexedReadMethodName, 1, classArray = new Class[]{Integer.TYPE})) == null) {
                this.indexedReadMethodName = "get" + this.getBaseName();
                method = Introspector.findMethod(clazz, this.indexedReadMethodName, 1, classArray);
            }
            this.setIndexedReadMethod0(method);
        }
        return method;
    }

    public synchronized void setIndexedReadMethod(Method method) throws IntrospectionException {
        this.setIndexedPropertyType(this.findIndexedPropertyType(method, this.getIndexedWriteMethod0()));
        this.setIndexedReadMethod0(method);
    }

    private void setIndexedReadMethod0(Method method) {
        if (method == null) {
            this.indexedReadMethodName = null;
            this.indexedReadMethodRef = null;
            return;
        }
        this.setClass0(method.getDeclaringClass());
        this.indexedReadMethodName = method.getName();
        this.indexedReadMethodRef = IndexedPropertyDescriptor.getSoftReference(method);
        this.setTransient(method.getAnnotation(Transient.class));
    }

    public synchronized Method getIndexedWriteMethod() {
        Method method = this.getIndexedWriteMethod0();
        if (method == null) {
            Class[] classArray;
            Class<?> clazz;
            Class clazz2;
            block9: {
                clazz2 = this.getClass0();
                if (clazz2 == null || this.indexedWriteMethodName == null && this.indexedWriteMethodRef == null) {
                    return null;
                }
                clazz = this.getIndexedPropertyType0();
                if (clazz == null) {
                    try {
                        clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), null);
                        this.setIndexedPropertyType(clazz);
                    }
                    catch (IntrospectionException introspectionException) {
                        Class<?> clazz3 = this.getPropertyType();
                        if (!clazz3.isArray()) break block9;
                        clazz = clazz3.getComponentType();
                    }
                }
            }
            if (this.indexedWriteMethodName == null) {
                this.indexedWriteMethodName = "set" + this.getBaseName();
            }
            if (clazz == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[2];
                classArray2[0] = Integer.TYPE;
                classArray = classArray2;
                classArray2[1] = clazz;
            }
            method = Introspector.findMethod(clazz2, this.indexedWriteMethodName, 2, classArray);
            if (method != null && !method.getReturnType().equals(Void.TYPE)) {
                method = null;
            }
            this.setIndexedWriteMethod0(method);
        }
        return method;
    }

    public synchronized void setIndexedWriteMethod(Method method) throws IntrospectionException {
        Class clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), method);
        this.setIndexedPropertyType(clazz);
        this.setIndexedWriteMethod0(method);
    }

    private void setIndexedWriteMethod0(Method method) {
        if (method == null) {
            this.indexedWriteMethodName = null;
            this.indexedWriteMethodRef = null;
            return;
        }
        this.setClass0(method.getDeclaringClass());
        this.indexedWriteMethodName = method.getName();
        this.indexedWriteMethodRef = IndexedPropertyDescriptor.getSoftReference(method);
        this.setTransient(method.getAnnotation(Transient.class));
    }

    public synchronized Class<?> getIndexedPropertyType() {
        Class clazz = this.getIndexedPropertyType0();
        if (clazz == null) {
            try {
                clazz = this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
                this.setIndexedPropertyType(clazz);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return clazz;
    }

    private void setIndexedPropertyType(Class clazz) {
        this.indexedPropertyTypeRef = IndexedPropertyDescriptor.getWeakReference(clazz);
    }

    private Class getIndexedPropertyType0() {
        return this.indexedPropertyTypeRef != null ? this.indexedPropertyTypeRef.get() : null;
    }

    private Method getIndexedReadMethod0() {
        return this.indexedReadMethodRef != null ? this.indexedReadMethodRef.get() : null;
    }

    private Method getIndexedWriteMethod0() {
        return this.indexedWriteMethodRef != null ? this.indexedWriteMethodRef.get() : null;
    }

    private Class findIndexedPropertyType(Method method, Method method2) throws IntrospectionException {
        Object object;
        Object object2 = null;
        if (method != null) {
            object = IndexedPropertyDescriptor.getParameterTypes(this.getClass0(), method);
            if (((Class[])object).length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed read method");
            }
            object2 = IndexedPropertyDescriptor.getReturnType(this.getClass0(), method);
            if (object2 == Void.TYPE) {
                throw new IntrospectionException("indexed read method returns void");
            }
        }
        if (method2 != null) {
            object = IndexedPropertyDescriptor.getParameterTypes(this.getClass0(), method2);
            if (((Class[])object).length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (object2 != null && object2 != object[1]) {
                throw new IntrospectionException("type mismatch between indexed read and indexed write methods: " + this.getName());
            }
            object2 = object[1];
        }
        if (!((object = this.getPropertyType()) == null || ((Class)object).isArray() && ((Class)object).getComponentType() == object2)) {
            throw new IntrospectionException("type mismatch between indexed and non-indexed methods: " + this.getName());
        }
        return object2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)object;
            Method method = indexedPropertyDescriptor.getIndexedReadMethod();
            Method method2 = indexedPropertyDescriptor.getIndexedWriteMethod();
            if (!this.compareMethods(this.getIndexedReadMethod(), method)) {
                return false;
            }
            if (!this.compareMethods(this.getIndexedWriteMethod(), method2)) {
                return false;
            }
            if (this.getIndexedPropertyType() != indexedPropertyDescriptor.getIndexedPropertyType()) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    IndexedPropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        super(propertyDescriptor, propertyDescriptor2);
        Method method;
        Method method2;
        IndexedPropertyDescriptor indexedPropertyDescriptor;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            try {
                method2 = indexedPropertyDescriptor.getIndexedReadMethod();
                if (method2 != null) {
                    this.setIndexedReadMethod(method2);
                }
                if ((method = indexedPropertyDescriptor.getIndexedWriteMethod()) != null) {
                    this.setIndexedWriteMethod(method);
                }
            }
            catch (IntrospectionException introspectionException) {
                throw new AssertionError((Object)introspectionException);
            }
        }
        if (propertyDescriptor2 instanceof IndexedPropertyDescriptor) {
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor2;
            try {
                method2 = indexedPropertyDescriptor.getIndexedReadMethod();
                if (method2 != null && method2.getDeclaringClass() == this.getClass0()) {
                    this.setIndexedReadMethod(method2);
                }
                if ((method = indexedPropertyDescriptor.getIndexedWriteMethod()) != null && method.getDeclaringClass() == this.getClass0()) {
                    this.setIndexedWriteMethod(method);
                }
            }
            catch (IntrospectionException introspectionException) {
                throw new AssertionError((Object)introspectionException);
            }
        }
    }

    IndexedPropertyDescriptor(IndexedPropertyDescriptor indexedPropertyDescriptor) {
        super(indexedPropertyDescriptor);
        this.indexedReadMethodRef = indexedPropertyDescriptor.indexedReadMethodRef;
        this.indexedWriteMethodRef = indexedPropertyDescriptor.indexedWriteMethodRef;
        this.indexedPropertyTypeRef = indexedPropertyDescriptor.indexedPropertyTypeRef;
        this.indexedWriteMethodName = indexedPropertyDescriptor.indexedWriteMethodName;
        this.indexedReadMethodName = indexedPropertyDescriptor.indexedReadMethodName;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + (this.indexedWriteMethodName == null ? 0 : this.indexedWriteMethodName.hashCode());
        n = 37 * n + (this.indexedReadMethodName == null ? 0 : this.indexedReadMethodName.hashCode());
        n = 37 * n + (this.getIndexedPropertyType() == null ? 0 : this.getIndexedPropertyType().hashCode());
        return n;
    }
}

