/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DescriptorCache;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanInjector;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.Util;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.Description;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MXBean;
import javax.management.ManagedAttribute;
import javax.management.ManagedOperation;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationInfo;
import javax.management.NotificationInfos;
import javax.management.ReflectionException;

public abstract class MBeanIntrospector<M> {
    private static final Map<Class<?>, WeakReference<Class<?>>> annotatedNotificationInfoClasses = Util.newWeakHashMap();

    abstract PerInterfaceMap<M> getPerInterfaceMap();

    abstract MBeanInfoMap getMBeanInfoMap();

    abstract MBeanAnalyzer<M> getAnalyzer(Class<?> var1) throws NotCompliantMBeanException;

    abstract boolean isMXBean();

    abstract M mFrom(Method var1);

    abstract String getName(M var1);

    abstract Type getGenericReturnType(M var1);

    abstract Type[] getGenericParameterTypes(M var1);

    abstract String[] getSignature(M var1);

    abstract void checkMethod(M var1);

    abstract Object invokeM2(M var1, Object var2, Object[] var3, Object var4) throws InvocationTargetException, IllegalAccessException, MBeanException;

    abstract boolean validParameter(M var1, Object var2, int var3, Object var4);

    abstract MBeanAttributeInfo getMBeanAttributeInfo(String var1, M var2, M var3) throws IntrospectionException;

    final String getAttributeDescription(String string, String string2, Method method, Method method2) throws IntrospectionException {
        String string3 = Introspector.descriptionForElement(method);
        String string4 = Introspector.descriptionForElement(method2);
        if (string3 == null) {
            if (string4 == null) {
                return string2;
            }
            return string4;
        }
        if (string4 == null || string3.equals(string4)) {
            return string3;
        }
        throw new IntrospectionException("Inconsistent @Description on getter and setter for attribute " + string);
    }

    abstract MBeanOperationInfo getMBeanOperationInfo(String var1, M var2);

    abstract Descriptor getBasicMBeanDescriptor();

    abstract Descriptor getMBeanDescriptor(Class<?> var1);

    Descriptor getSpecificMBeanDescriptor() {
        return ImmutableDescriptor.EMPTY_DESCRIPTOR;
    }

    void checkCompliance(Class<?> clazz) throws NotCompliantMBeanException {
        if (!(clazz.isInterface() || clazz.isAnnotationPresent(MBean.class) || Introspector.hasMXBeanAnnotation(clazz))) {
            throw new NotCompliantMBeanException("Not an interface and does not have @" + MBean.class.getSimpleName() + " or @" + MXBean.class.getSimpleName() + " annotation: " + clazz.getName());
        }
    }

    List<Method> getMethods(Class<?> clazz) throws Exception {
        if (clazz.isInterface()) {
            return Arrays.asList(clazz.getMethods());
        }
        List<Method> list = Util.newList();
        MBeanIntrospector.getAnnotatedMethods(clazz, list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PerInterface<M> getPerInterface(Class<?> clazz) throws NotCompliantMBeanException {
        PerInterfaceMap<M> perInterfaceMap;
        PerInterfaceMap<M> perInterfaceMap2 = perInterfaceMap = this.getPerInterfaceMap();
        synchronized (perInterfaceMap2) {
            PerInterface<M> perInterface;
            WeakReference<PerInterface<M>> weakReference = (WeakReference<PerInterface<M>>)perInterfaceMap.get(clazz);
            PerInterface<M> perInterface2 = perInterface = weakReference == null ? null : (PerInterface<M>)weakReference.get();
            if (perInterface == null) {
                try {
                    MBeanAnalyzer<M> mBeanAnalyzer = this.getAnalyzer(clazz);
                    MBeanInfo mBeanInfo = this.makeInterfaceMBeanInfo(clazz, mBeanAnalyzer);
                    perInterface = new PerInterface<M>(clazz, this, mBeanAnalyzer, mBeanInfo);
                    weakReference = new WeakReference<PerInterface<M>>(perInterface);
                    perInterfaceMap.put(clazz, weakReference);
                }
                catch (Exception exception) {
                    throw Introspector.throwException(clazz, exception);
                }
            }
            return perInterface;
        }
    }

    private MBeanInfo makeInterfaceMBeanInfo(Class<?> clazz, MBeanAnalyzer<M> mBeanAnalyzer) throws IntrospectionException {
        MBeanInfoMaker mBeanInfoMaker = new MBeanInfoMaker();
        mBeanAnalyzer.visit(mBeanInfoMaker);
        String string = Introspector.descriptionForElement(clazz);
        if (string == null) {
            string = "Information on the management interface of the MBean";
        }
        return mBeanInfoMaker.makeMBeanInfo(clazz, string);
    }

    final boolean consistent(M m, M m2) {
        return m == null || m2 == null || this.getGenericReturnType(m).equals(this.getGenericParameterTypes(m2)[0]);
    }

    final Object invokeM(M m, Object object, Object[] objectArray, Object object2) throws MBeanException, ReflectionException {
        try {
            return this.invokeM2(m, object, objectArray, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            MBeanIntrospector.unwrapInvocationTargetException(invocationTargetException);
            throw new RuntimeException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, illegalAccessException.toString());
        }
    }

    final void invokeSetter(String string, M m, Object object, Object object2, Object object3) throws MBeanException, ReflectionException, InvalidAttributeValueException {
        try {
            this.invokeM2(m, object, new Object[]{object2}, object3);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, illegalAccessException.toString());
        }
        catch (RuntimeException runtimeException) {
            this.maybeInvalidParameter(string, m, object2, object3);
            throw runtimeException;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.maybeInvalidParameter(string, m, object2, object3);
            MBeanIntrospector.unwrapInvocationTargetException(invocationTargetException);
        }
    }

    private void maybeInvalidParameter(String string, M m, Object object, Object object2) throws InvalidAttributeValueException {
        if (!this.validParameter(m, object, 0, object2)) {
            String string2 = "Invalid value for attribute " + string + ": " + object;
            throw new InvalidAttributeValueException(string2);
        }
    }

    static boolean isValidParameter(Method method, Object object, int n) {
        Class<?> clazz = method.getParameterTypes()[n];
        try {
            Object object2 = Array.newInstance(clazz, 1);
            Array.set(object2, 0, object);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static void unwrapInvocationTargetException(InvocationTargetException invocationTargetException) throws MBeanException {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new MBeanException((Exception)throwable, throwable == null ? null : throwable.toString());
    }

    final MBeanInfo getMBeanInfo(Object object, PerInterface<M> perInterface) throws NotCompliantMBeanException {
        boolean bl;
        MBeanNotificationInfo[] mBeanNotificationInfoArray;
        MBeanInfo mBeanInfo = this.getClassMBeanInfo(object.getClass(), perInterface);
        try {
            mBeanNotificationInfoArray = MBeanIntrospector.findNotifications(object);
        }
        catch (RuntimeException runtimeException) {
            NotCompliantMBeanException notCompliantMBeanException = new NotCompliantMBeanException(runtimeException.getMessage());
            notCompliantMBeanException.initCause(runtimeException);
            throw notCompliantMBeanException;
        }
        Descriptor descriptor = this.getSpecificMBeanDescriptor();
        boolean bl2 = bl = mBeanNotificationInfoArray != null && mBeanNotificationInfoArray.length > 0;
        if (!bl && ImmutableDescriptor.EMPTY_DESCRIPTOR.equals(descriptor)) {
            return mBeanInfo;
        }
        descriptor = ImmutableDescriptor.union(descriptor, mBeanInfo.getDescriptor());
        return new MBeanInfo(mBeanInfo.getClassName(), mBeanInfo.getDescription(), mBeanInfo.getAttributes(), mBeanInfo.getConstructors(), mBeanInfo.getOperations(), mBeanNotificationInfoArray, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MBeanInfo getClassMBeanInfo(Class<?> clazz, PerInterface<M> perInterface) {
        MBeanInfoMap mBeanInfoMap;
        MBeanInfoMap mBeanInfoMap2 = mBeanInfoMap = this.getMBeanInfoMap();
        synchronized (mBeanInfoMap2) {
            Class<?> clazz2;
            MBeanInfo mBeanInfo;
            WeakHashMap weakHashMap = (WeakHashMap)mBeanInfoMap.get(clazz);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap();
                mBeanInfoMap.put(clazz, weakHashMap);
            }
            if ((mBeanInfo = (MBeanInfo)weakHashMap.get(clazz2 = perInterface.getMBeanInterface())) == null) {
                MBeanInfo mBeanInfo2 = perInterface.getMBeanInfo();
                ImmutableDescriptor immutableDescriptor = ImmutableDescriptor.union(mBeanInfo2.getDescriptor(), this.getMBeanDescriptor(clazz));
                mBeanInfo = new MBeanInfo(clazz.getName(), mBeanInfo2.getDescription(), mBeanInfo2.getAttributes(), MBeanIntrospector.findConstructors(clazz), mBeanInfo2.getOperations(), null, immutableDescriptor);
                weakHashMap.put(clazz2, mBeanInfo);
            }
            return mBeanInfo;
        }
    }

    public static void getAnnotatedMethods(Class<?> clazz, List<Method> list) throws Exception {
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            MBeanIntrospector.getAnnotatedMethods(clazz2, list);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (Class<?> annotatedElement : classArray) {
            MBeanIntrospector.getAnnotatedMethods(annotatedElement, list);
        }
        for (AnnotatedElement annotatedElement : clazz.getMethods()) {
            if (((Method)annotatedElement).getDeclaringClass() != clazz || !((AccessibleObject)annotatedElement).isAnnotationPresent(ManagedAttribute.class) && !((AccessibleObject)annotatedElement).isAnnotationPresent(ManagedOperation.class)) continue;
            list.add((Method)annotatedElement);
        }
    }

    static MBeanNotificationInfo[] findNotifications(Object object) {
        if (object instanceof NotificationBroadcaster) {
            MBeanNotificationInfo[] mBeanNotificationInfoArray = ((NotificationBroadcaster)object).getNotificationInfo();
            if (mBeanNotificationInfoArray != null && mBeanNotificationInfoArray.length > 0) {
                MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length];
                for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
                    MBeanNotificationInfo mBeanNotificationInfo = mBeanNotificationInfoArray[i];
                    if (mBeanNotificationInfo.getClass() != MBeanNotificationInfo.class) {
                        mBeanNotificationInfo = (MBeanNotificationInfo)mBeanNotificationInfo.clone();
                    }
                    mBeanNotificationInfoArray2[i] = mBeanNotificationInfo;
                }
                return mBeanNotificationInfoArray2;
            }
        } else {
            try {
                if (!MBeanInjector.injectsSendNotification(object)) {
                    return null;
                }
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new RuntimeException(notCompliantMBeanException);
            }
        }
        return MBeanIntrospector.findNotificationsFromAnnotations(object.getClass());
    }

    public static MBeanNotificationInfo[] findNotificationsFromAnnotations(Class<?> clazz) {
        Class<?> clazz2 = MBeanIntrospector.getAnnotatedNotificationInfoClass(clazz);
        if (clazz2 == null) {
            return null;
        }
        NotificationInfo notificationInfo = clazz2.getAnnotation(NotificationInfo.class);
        NotificationInfos notificationInfos = clazz2.getAnnotation(NotificationInfos.class);
        List<NotificationInfo> list = Util.newList();
        if (notificationInfo != null) {
            list.add(notificationInfo);
        }
        if (notificationInfos != null) {
            list.addAll(Arrays.asList(notificationInfos.value()));
        }
        if (list.isEmpty()) {
            return null;
        }
        List<MBeanNotificationInfo> list2 = Util.newList();
        for (NotificationInfo notificationInfo2 : list) {
            ImmutableDescriptor immutableDescriptor = new ImmutableDescriptor(notificationInfo2.descriptorFields());
            immutableDescriptor = ImmutableDescriptor.union(immutableDescriptor, Introspector.descriptorForAnnotation(notificationInfo2.description()));
            MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(notificationInfo2.types(), notificationInfo2.notificationClass().getName(), notificationInfo2.description().value(), immutableDescriptor);
            list2.add(mBeanNotificationInfo);
        }
        return list2.toArray(new MBeanNotificationInfo[list2.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getAnnotatedNotificationInfoClass(Class<?> clazz) {
        Map<Class<?>, WeakReference<Class<?>>> map = annotatedNotificationInfoClasses;
        synchronized (map) {
            WeakReference<Class<?>> weakReference = annotatedNotificationInfoClasses.get(clazz);
            if (weakReference != null) {
                return (Class)weakReference.get();
            }
            Class<?> clazz2 = null;
            if (clazz.isAnnotationPresent(NotificationInfo.class) || clazz.isAnnotationPresent(NotificationInfos.class)) {
                clazz2 = clazz;
            } else {
                Class<?>[] classArray;
                for (Class<?> clazz3 : classArray = clazz.getInterfaces()) {
                    Class<?> clazz4 = MBeanIntrospector.getAnnotatedNotificationInfoClass(clazz3);
                    if (clazz4 == null) continue;
                    if (clazz2 != null) {
                        throw new IllegalArgumentException("Class " + clazz.getName() + " inherits " + "@NotificationInfo(s) from both " + clazz2.getName() + " and " + clazz4.getName());
                    }
                    clazz2 = clazz4;
                }
            }
            annotatedNotificationInfoClasses.put(clazz, new WeakReference(clazz2));
            return clazz2;
        }
    }

    private static MBeanConstructorInfo[] findConstructors(Class<?> clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[constructorArray.length];
        for (int i = 0; i < constructorArray.length; ++i) {
            String string = "Public constructor of the MBean";
            Description description = constructorArray[i].getAnnotation(Description.class);
            if (description != null) {
                string = description.value();
            }
            mBeanConstructorInfoArray[i] = new MBeanConstructorInfo(string, constructorArray[i]);
        }
        return mBeanConstructorInfoArray;
    }

    static class MBeanInfoMap
    extends WeakHashMap<Class<?>, WeakHashMap<Class<?>, MBeanInfo>> {
        MBeanInfoMap() {
        }
    }

    private class MBeanInfoMaker
    implements MBeanAnalyzer.MBeanVisitor<M, IntrospectionException> {
        private final List<MBeanAttributeInfo> attrs = Util.newList();
        private final List<MBeanOperationInfo> ops = Util.newList();

        private MBeanInfoMaker() {
        }

        @Override
        public void visitAttribute(String string, M m, M m2) throws IntrospectionException {
            MBeanAttributeInfo mBeanAttributeInfo = MBeanIntrospector.this.getMBeanAttributeInfo(string, m, m2);
            this.attrs.add(mBeanAttributeInfo);
        }

        @Override
        public void visitOperation(String string, M m) {
            MBeanOperationInfo mBeanOperationInfo = MBeanIntrospector.this.getMBeanOperationInfo(string, m);
            this.ops.add(mBeanOperationInfo);
        }

        MBeanInfo makeMBeanInfo(Class<?> clazz, String string) {
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.attrs.toArray(new MBeanAttributeInfo[0]);
            MBeanOperationInfo[] mBeanOperationInfoArray = this.ops.toArray(new MBeanOperationInfo[0]);
            String string2 = "interfaceClassName=" + clazz.getName();
            ImmutableDescriptor immutableDescriptor = new ImmutableDescriptor(string2);
            Descriptor descriptor = MBeanIntrospector.this.getBasicMBeanDescriptor();
            Descriptor descriptor2 = Introspector.descriptorForElement(clazz, false);
            ImmutableDescriptor immutableDescriptor2 = DescriptorCache.getInstance().union(immutableDescriptor, descriptor, descriptor2);
            return new MBeanInfo(clazz.getName(), string, mBeanAttributeInfoArray, null, mBeanOperationInfoArray, null, immutableDescriptor2);
        }
    }

    static final class PerInterfaceMap<M>
    extends WeakHashMap<Class<?>, WeakReference<PerInterface<M>>> {
        PerInterfaceMap() {
        }
    }
}

