/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.Util;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Resource;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.SendNotification;

public class MBeanInjector {
    private static Class<?>[] injectedClasses = new Class[]{MBeanServer.class, ObjectName.class, SendNotification.class};
    private static Map<Class<?>, WeakReference<ClassInjector>> injectorMap = new WeakHashMap();

    private MBeanInjector() {
    }

    public static void inject(Object object, MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        ClassInjector classInjector = MBeanInjector.injectorForClass(object.getClass());
        classInjector.inject(object, MBeanServer.class, mBeanServer);
        classInjector.inject(object, ObjectName.class, objectName);
    }

    public static boolean injectsSendNotification(Object object) throws NotCompliantMBeanException {
        ClassInjector classInjector = MBeanInjector.injectorForClass(object.getClass());
        return classInjector.injects(SendNotification.class);
    }

    public static void injectSendNotification(Object object, SendNotification sendNotification) throws Exception {
        ClassInjector classInjector = MBeanInjector.injectorForClass(object.getClass());
        classInjector.inject(object, SendNotification.class, sendNotification);
    }

    public static void validate(Class<?> clazz) throws NotCompliantMBeanException {
        MBeanInjector.injectorForClass(clazz);
    }

    private static synchronized ClassInjector injectorForClass(Class<?> clazz) throws NotCompliantMBeanException {
        ClassInjector classInjector;
        WeakReference<ClassInjector> weakReference = injectorMap.get(clazz);
        ClassInjector classInjector2 = classInjector = weakReference == null ? null : (ClassInjector)weakReference.get();
        if (classInjector == null) {
            classInjector = new ClassInjector(clazz);
            injectorMap.put(clazz, new WeakReference<ClassInjector>(classInjector));
        }
        return classInjector;
    }

    private static class ClassInjector {
        private Map<Class<?>, List<Field>> fields = Util.newMap();
        private Map<Class<?>, List<Method>> methods = Util.newMap();

        ClassInjector(Class<?> clazz) throws NotCompliantMBeanException {
            ClassInjector classInjector;
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                classInjector = null;
            } else {
                classInjector = MBeanInjector.injectorForClass(clazz2);
                this.fields.putAll(classInjector.fields);
                this.methods.putAll(classInjector.methods);
            }
            this.addMembers(clazz);
            this.eliminateOverriddenMethods();
            if (classInjector != null) {
                if (this.fields.equals(classInjector.fields)) {
                    this.fields = classInjector.fields;
                }
                if (this.methods.equals(classInjector.methods)) {
                    this.methods = classInjector.methods;
                }
            }
        }

        boolean injects(Class<?> clazz) {
            return this.fields.get(clazz) != null || this.methods.get(clazz) != null;
        }

        <T> void inject(Object object, Class<T> clazz, T t) throws Exception {
            Object object2;
            Object object3;
            List<Field> list = this.fields.get(clazz);
            if (list != null) {
                object3 = list.iterator();
                while (object3.hasNext()) {
                    object2 = (Field)object3.next();
                    ((Field)object2).set(object, t);
                }
            }
            if ((object3 = this.methods.get(clazz)) != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    Method method = (Method)object2.next();
                    try {
                        method.invoke(object, t);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getCause();
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        throw (Exception)throwable;
                    }
                }
            }
        }

        private void eliminateOverriddenMethods() {
            for (Map.Entry<Class<?>, List<Method>> entry : this.methods.entrySet()) {
                List<Method> list = entry.getValue();
                list = MBeanAnalyzer.eliminateCovariantMethods(list);
                entry.setValue(list);
            }
        }

        private void addMembers(final Class<?> clazz) throws NotCompliantMBeanException {
            AccessibleObject[][] accessibleObjectArray;
            AccessibleObject[][] accessibleObjectArray2 = accessibleObjectArray = AccessController.doPrivileged(new PrivilegedAction<AccessibleObject[][]>(){

                @Override
                public AccessibleObject[][] run() {
                    return new AccessibleObject[][]{clazz.getDeclaredFields(), clazz.getDeclaredMethods()};
                }
            });
            int n = accessibleObjectArray2.length;
            for (int i = 0; i < n; ++i) {
                AccessibleObject[] accessibleObjectArray3;
                for (final AccessibleObject accessibleObject : accessibleObjectArray3 = accessibleObjectArray2[i]) {
                    Method method;
                    int n2;
                    Class<?> clazz2;
                    Field field;
                    Resource resource = accessibleObject.getAnnotation(Resource.class);
                    if (resource == null) continue;
                    if (accessibleObject instanceof Field) {
                        field = (Field)accessibleObject;
                        clazz2 = field.getType();
                        n2 = field.getModifiers();
                        method = null;
                    } else {
                        field = null;
                        method = (Method)accessibleObject;
                        Class<?>[] classArray = method.getParameterTypes();
                        if (classArray.length != 1) {
                            throw new NotCompliantMBeanException("@Resource method must have exactly 1 parameter: " + method);
                        }
                        if (method.getReturnType() != Void.TYPE) {
                            throw new NotCompliantMBeanException("@Resource method must return void: " + method);
                        }
                        clazz2 = classArray[0];
                        n2 = method.getModifiers();
                    }
                    if (Modifier.isStatic(n2)) {
                        throw new NotCompliantMBeanException("@Resource method or field cannot be static: " + accessibleObject);
                    }
                    for (Class<?> clazz3 : injectedClasses) {
                        Class[] classArray = new Class[]{clazz2, resource.type()};
                        boolean bl = false;
                        for (int j = 0; j < 2; ++j) {
                            if (classArray[j] != clazz3 || !classArray[1 - j].isAssignableFrom(clazz3)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                accessibleObject.setAccessible(true);
                                return null;
                            }
                        });
                        ClassInjector.addToMap(this.fields, clazz3, field);
                        ClassInjector.addToMap(this.methods, clazz3, method);
                    }
                }
            }
        }

        private static <K, V> void addToMap(Map<K, List<V>> map, K k, V v) {
            if (v == null) {
                return;
            }
            List<V> list = map.get(k);
            if (list == null) {
                list = Collections.singletonList(v);
            } else {
                if (list.size() == 1) {
                    list = new ArrayList<V>(list);
                }
                list.add(v);
            }
            map.put(k, list);
        }
    }
}

