/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ComponentColorModel
extends ColorModel {
    private static int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public ComponentColorModel(ColorSpace colorSpace, int[] nArray, boolean bl, boolean bl2, int n, int n2) {
        super(ComponentColorModel.sum(nArray), nArray, colorSpace, bl, bl2, n, n2);
    }

    public ComponentColorModel(ColorSpace colorSpace, boolean bl, boolean bl2, int n, int n2) {
        this(colorSpace, null, bl, bl2, n, n2);
    }

    public int getRed(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(n)[0];
    }

    public int getGreen(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(n)[0];
    }

    public int getBlue(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return (int)this.getRGBFloat(n)[0];
    }

    public int getAlpha(int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        int n2 = 8 - this.getComponentSize(this.getNumColorComponents());
        if (n2 >= 0) {
            return n << (n2 & 0x1F);
        }
        return n >> (-n2 & 0x1F);
    }

    public int getRGB(int n) {
        float[] fArray = this.getRGBFloat(n);
        int n2 = this.getRGB(fArray);
        if (this.hasAlpha()) {
            n2 |= this.getAlpha(n) << 24;
        }
        return n2;
    }

    private float[] getRGBFloat(int n) {
        float[] fArray = new float[]{n};
        return this.cspace.toRGB(fArray);
    }

    private float[] getRGBFloat(Object object) {
        DataBuffer dataBuffer = Buffers.createBufferFromData(this.transferType, object, this.getNumComponents());
        int n = this.getNumColorComponents();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f = (1 << (this.getComponentSize(i) & 0x1F)) - 1;
            fArray[i] = dataBuffer.getElemFloat(i) / f;
        }
        float[] fArray2 = this.cspace.toRGB(fArray);
        return fArray2;
    }

    public int getRed(Object object) {
        return (int)this.getRGBFloat(object)[0] * 255;
    }

    public int getGreen(Object object) {
        return (int)this.getRGBFloat(object)[1] * 255;
    }

    public int getBlue(Object object) {
        return (int)this.getRGBFloat(object)[2] * 255;
    }

    public int getAlpha(Object object) {
        DataBuffer dataBuffer = Buffers.createBufferFromData(this.transferType, object, this.getNumComponents());
        int n = 8 - this.getComponentSize(this.getNumColorComponents());
        int n2 = dataBuffer.getElem(this.getNumColorComponents());
        if (n >= 0) {
            return n2 << (n & 0x1F);
        }
        return n2 >> (-n & 0x1F);
    }

    private int getRGB(float[] fArray) {
        int n = (int)(fArray[0] * 255.0f) << 16 | (int)(fArray[1] * 255.0f) << 8 | (int)(fArray[2] * 255.0f) << 0;
        return n;
    }

    public int getRGB(Object object) {
        float[] fArray = this.getRGBFloat(object);
        int n = this.getRGB(fArray);
        if (this.hasAlpha()) {
            n |= this.getAlpha(object) << 24;
        }
        return n;
    }

    public Object getDataElements(int n, Object object) {
        float[] fArray = new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n >> 0 & 0xFF) / 255.0f};
        float[] fArray2 = this.cspace.fromRGB(fArray);
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, this.getNumComponents());
        int n2 = this.getNumColorComponents();
        if (this.hasAlpha()) {
            float f = (float)(n >> 24 & 0xFF) / 255.0f;
            if (this.isAlphaPremultiplied()) {
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = n3++;
                    fArray2[n4] = fArray2[n4] * f;
                }
            }
            dataBuffer.setElemFloat(n2, f *= (float)(1 << (this.bits[n2] - 1 & 0x1F)));
        }
        for (int i = 0; i < n2; ++i) {
            float f = fArray2[i] * (float)(1 << (this.bits[i] - 1 & 0x1F));
            dataBuffer.setElemFloat(i, f);
        }
        return Buffers.getData(dataBuffer);
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        if (nArray == null) {
            nArray = new int[this.getNumComponents() + n2];
        }
        nArray[n2] = n;
        return nArray;
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, this.getNumComponents());
        int n2 = this.getNumComponents();
        if (nArray == null) {
            nArray = new int[n2 + n];
        }
        for (int i = 0; i < n2; ++i) {
            nArray[n++] = dataBuffer.getElem(i);
        }
        return nArray;
    }

    public int getDataElement(int[] nArray, int n) {
        if (this.getNumComponents() > 1) {
            throw new IllegalArgumentException();
        }
        return nArray[n];
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, this.getNumComponents());
        int n2 = this.getNumComponents();
        for (int i = 0; i < n2; ++i) {
            dataBuffer.setElem(i, nArray[n++]);
        }
        return Buffers.getData(dataBuffer);
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        if (this.isAlphaPremultiplied == bl) {
            return this;
        }
        super.coerceData(writableRaster, bl);
        return new ComponentColorModel(this.cspace, this.bits, this.hasAlpha(), bl, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        return super.isCompatibleRaster(raster);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        SampleModel sampleModel = this.createCompatibleSampleModel(n, n2);
        Point point = new Point(0, 0);
        return Raster.createWritableRaster(sampleModel, point);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3 = this.getNumComponents();
        int n4 = n3 * n;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = i;
        }
        switch (this.transferType) {
            case 0: 
            case 1: {
                return new PixelInterleavedSampleModel(this.transferType, n, n2, n3, n4, nArray);
            }
        }
        return new ComponentSampleModel(this.transferType, n, n2, n3, n4, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel && super.isCompatibleSampleModel(sampleModel);
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        SampleModel sampleModel = writableRaster.getSampleModel();
        int[] nArray = new int[]{sampleModel.getNumBands() - 1};
        SampleModel sampleModel2 = sampleModel.createSubsetSampleModel(nArray);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        Point point = new Point(0, 0);
        return Raster.createWritableRaster(sampleModel2, dataBuffer, point);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComponentColorModel)) {
            return false;
        }
        return super.equals(object);
    }
}

