/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support.low;

import gnu.javax.swing.text.html.parser.support.low.Location;

public class Buffer {
    public static int INITIAL_SIZE = 2048;
    public boolean n_seen;
    public boolean r_seen;
    char[] chr;
    int[] line;
    int[] position;
    int current_line;
    int length;

    private /* synthetic */ void finit$() {
        this.chr = new char[INITIAL_SIZE];
        this.line = new int[INITIAL_SIZE];
        this.position = new int[INITIAL_SIZE];
        this.current_line = 0;
    }

    public Buffer() {
        this.finit$();
    }

    public Buffer(String string) {
        this.finit$();
        for (int i = 0; i < string.length(); ++i) {
            this.append(string.charAt(i), i);
        }
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        System.arraycopy(this.chr, n, cArray, n3, n2 - n);
    }

    public String getEndOfLineSequence() {
        if (this.r_seen && this.n_seen) {
            return "\r\n";
        }
        if (this.r_seen) {
            return "\r";
        }
        return "\n";
    }

    public void setLength(int n) {
        this.length = n;
    }

    public Location getLocation(int n, int n2) {
        Location location = new Location();
        location.beginLine = this.line[n];
        location.endLine = this.line[n2 - 1];
        location.startPosition = this.position[n];
        location.endPosition = this.position[n2 - 1] + 1;
        return location;
    }

    public void append(char c, int n) {
        if (this.length >= this.chr.length) {
            this.expand();
        }
        this.chr[this.length] = c;
        this.position[this.length] = n;
        if (c == '\n') {
            if (!this.r_seen) {
                // empty if block
            }
            this.n_seen = true;
        } else if (c == '\r') {
            ++this.current_line;
            this.r_seen = true;
        }
        this.line[this.length] = ++this.current_line;
        ++this.length;
    }

    public char charAt(int n) {
        return this.chr[n];
    }

    public void delete(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 1) {
            throw new AssertionError((Object)("Deleting " + n + " till " + n2));
        }
        int n4 = this.length - n2;
        System.arraycopy(this.chr, n2, this.chr, n, n4);
        System.arraycopy(this.position, n2, this.position, n, n4);
        System.arraycopy(this.line, n2, this.line, n, n4);
        this.length -= n3;
    }

    public void expand() {
        int n = 2 * this.chr.length;
        char[] cArray = new char[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        System.arraycopy(this.chr, 0, cArray, 0, this.chr.length);
        System.arraycopy(this.position, 0, nArray, 0, this.position.length);
        System.arraycopy(this.line, 0, nArray2, 0, this.line.length);
        this.chr = cArray;
        this.position = nArray;
        this.line = nArray2;
    }

    public int length() {
        return this.length;
    }

    public void reset() {
        this.setLength(0);
        this.n_seen = false;
        this.r_seen = false;
    }

    public String toString() {
        return new String(this.chr, 0, this.length);
    }
}

