/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.ui.internal.editors.text.SharedTextColors;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.texteditor.AnnotationTypeHierarchy;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.spelling.SpellingService;
import org.osgi.framework.BundleContext;

public class EditorsPlugin
extends AbstractUIPlugin {
    private static EditorsPlugin fgInstance;
    private ISharedTextColors fSharedTextColors;
    private AnnotationTypeLookup fAnnotationTypeLookup;
    private AnnotationPreferenceLookup fAnnotationPreferenceLookup;
    private AnnotationTypeHierarchy fAnnotationTypeHierarchy;
    private MarkerAnnotationPreferences fMarkerAnnotationPreferences;
    private SpellingService fSpellingService;

    public static EditorsPlugin getDefault() {
        return fgInstance;
    }

    public static void log(IStatus status) {
        EditorsPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        EditorsPlugin.log((IStatus)new Status(4, "org.eclipse.ui.editors", 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            EditorsPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus("org.eclipse.ui.editors", 10001, message, null);
        multi.add(status);
        EditorsPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        EditorsPlugin.log((IStatus)new Status(4, "org.eclipse.ui.editors", 10001, TextEditorMessages.EditorsPlugin_internal_error, e));
    }

    public EditorsPlugin() {
        Assert.isTrue((fgInstance == null ? 1 : 0) != 0);
        fgInstance = this;
    }

    public ISharedTextColors getSharedTextColors() {
        if (this.fSharedTextColors == null) {
            this.fSharedTextColors = new SharedTextColors();
        }
        return this.fSharedTextColors;
    }

    public AnnotationTypeLookup getAnnotationTypeLookup() {
        if (this.fAnnotationTypeLookup == null) {
            this.fAnnotationTypeLookup = new AnnotationTypeLookup();
        }
        return this.fAnnotationTypeLookup;
    }

    public AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        if (this.fAnnotationPreferenceLookup == null) {
            this.fAnnotationPreferenceLookup = new AnnotationPreferenceLookup();
        }
        return this.fAnnotationPreferenceLookup;
    }

    public AnnotationTypeHierarchy getAnnotationTypeHierarchy() {
        if (this.fAnnotationTypeHierarchy == null) {
            this.fAnnotationTypeHierarchy = new AnnotationTypeHierarchy();
        }
        return this.fAnnotationTypeHierarchy;
    }

    public synchronized void setMarkerAnnotationPreferences(MarkerAnnotationPreferences markerAnnotationPreferences) {
        Assert.isTrue((this.fMarkerAnnotationPreferences == null ? 1 : 0) != 0);
        this.fMarkerAnnotationPreferences = markerAnnotationPreferences;
    }

    public boolean isMarkerAnnotationPreferencesInitialized() {
        return this.fMarkerAnnotationPreferences != null;
    }

    public synchronized MarkerAnnotationPreferences getMarkerAnnotationPreferences() {
        if (!this.isMarkerAnnotationPreferencesInitialized()) {
            new MarkerAnnotationPreferences().getAnnotationPreferences();
        }
        return this.fMarkerAnnotationPreferences;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fSharedTextColors != null) {
            this.fSharedTextColors.dispose();
            this.fSharedTextColors = null;
        }
        this.fAnnotationTypeLookup = null;
        this.fAnnotationPreferenceLookup = null;
        this.fAnnotationTypeHierarchy = null;
        this.fMarkerAnnotationPreferences = null;
        super.stop(context);
    }

    public SpellingService getSpellingService() {
        if (this.fSpellingService == null) {
            this.fSpellingService = new SpellingService(this.getPreferenceStore());
        }
        return this.fSpellingService;
    }
}

