/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.manipulation;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.FileBuffersMessages;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.internal.filebuffers.Progress;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class FileBufferOperationRunner {
    private final Object fValidationContext;
    private final IFileBufferManager fFileBufferManager;
    private final Object fCompletionLock = new Object();
    private transient boolean fIsCompleted;
    private transient Throwable fThrowable;

    public FileBufferOperationRunner(IFileBufferManager fileBufferManager, Object validationContext) {
        this.fFileBufferManager = fileBufferManager;
        this.fValidationContext = validationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IPath[] locations, final IFileBufferOperation operation, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        int size = locations.length;
        final IProgressMonitor progressMonitor = Progress.getMonitor(monitor);
        progressMonitor.beginTask(operation.getOperationName(), size * 200);
        try {
            IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, size * 10);
            IFileBuffer[] fileBuffers = this.createFileBuffers(locations, subMonitor);
            subMonitor.done();
            IFileBuffer[] fileBuffers2Save = this.findFileBuffersToSave(fileBuffers);
            subMonitor = Progress.getSubMonitor(progressMonitor, size * 10);
            this.fFileBufferManager.validateState(fileBuffers2Save, subMonitor, this.fValidationContext);
            subMonitor.done();
            if (!this.isCommitable(fileBuffers2Save)) {
                throw new OperationCanceledException();
            }
            IFileBuffer[] unsynchronizedFileBuffers = this.findUnsynchronizedFileBuffers(fileBuffers);
            this.performOperation(unsynchronizedFileBuffers, operation, progressMonitor);
            final IFileBuffer[] synchronizedFileBuffers = this.findSynchronizedFileBuffers(fileBuffers);
            this.fIsCompleted = false;
            this.fThrowable = null;
            Object object = this.fCompletionLock;
            synchronized (object) {
                this.executeInContext(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = FileBufferOperationRunner.this.fCompletionLock;
                        synchronized (object) {
                            try {
                                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                    public void handleException(Throwable throwable) {
                                        FileBufferOperationRunner.this.fThrowable = throwable;
                                    }

                                    public void run() throws Exception {
                                        FileBufferOperationRunner.this.performOperation(synchronizedFileBuffers, operation, progressMonitor);
                                    }
                                });
                            }
                            finally {
                                FileBufferOperationRunner.this.fIsCompleted = true;
                                FileBufferOperationRunner.this.fCompletionLock.notifyAll();
                            }
                        }
                    }
                });
                while (!this.fIsCompleted) {
                    try {
                        this.fCompletionLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.fThrowable != null) {
                if (this.fThrowable instanceof CoreException) {
                    throw (CoreException)this.fThrowable;
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 1, this.fThrowable.getLocalizedMessage(), this.fThrowable));
            }
            subMonitor = Progress.getSubMonitor(progressMonitor, size * 80);
            this.commit(fileBuffers2Save, subMonitor);
            subMonitor.done();
        }
        finally {
            try {
                IProgressMonitor iProgressMonitor = Progress.getSubMonitor(progressMonitor, size * 10);
                this.releaseFileBuffers(locations, iProgressMonitor);
                iProgressMonitor.done();
            }
            finally {
                progressMonitor.done();
            }
        }
    }

    private void performOperation(IFileBuffer fileBuffer, IFileBufferOperation operation, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        ISchedulingRule rule = fileBuffer.computeCommitRule();
        IJobManager manager = Platform.getJobManager();
        try {
            manager.beginRule(rule, progressMonitor);
            String name = fileBuffer.getLocation().lastSegment();
            progressMonitor.beginTask(name, 100);
            try {
                IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 100);
                operation.run(fileBuffer, subMonitor);
                subMonitor.done();
            }
            finally {
                progressMonitor.done();
            }
        }
        finally {
            manager.endRule(rule);
        }
    }

    private void performOperation(IFileBuffer[] fileBuffers, IFileBufferOperation operation, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        int i = 0;
        while (i < fileBuffers.length) {
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 100);
            this.performOperation(fileBuffers[i], operation, subMonitor);
            subMonitor.done();
            ++i;
        }
    }

    private void executeInContext(Runnable runnable) {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        if (fileBufferManager instanceof TextFileBufferManager) {
            TextFileBufferManager manager = (TextFileBufferManager)fileBufferManager;
            manager.execute(runnable, true);
        } else {
            runnable.run();
        }
    }

    private IFileBuffer[] findUnsynchronizedFileBuffers(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isSynchronizationContextRequested()) {
                list.add(fileBuffers[i]);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private IFileBuffer[] findSynchronizedFileBuffers(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            if (fileBuffers[i].isSynchronizationContextRequested()) {
                list.add(fileBuffers[i]);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private IFileBuffer[] createFileBuffers(IPath[] locations, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(FileBuffersMessages.FileBufferOperationRunner_task_connecting, locations.length);
        try {
            IFileBuffer[] fileBuffers = new ITextFileBuffer[locations.length];
            int i = 0;
            while (i < locations.length) {
                IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 1);
                this.fFileBufferManager.connect(locations[i], subMonitor);
                subMonitor.done();
                fileBuffers[i] = this.fFileBufferManager.getFileBuffer(locations[i]);
                ++i;
            }
            IFileBuffer[] iFileBufferArray = fileBuffers;
            return iFileBufferArray;
        }
        catch (CoreException x) {
            try {
                this.releaseFileBuffers(locations, Progress.getMonitor());
            }
            catch (CoreException coreException) {}
            throw x;
        }
        finally {
            progressMonitor.done();
        }
    }

    private void releaseFileBuffers(IPath[] locations, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(FileBuffersMessages.FileBufferOperationRunner_task_disconnecting, locations.length);
        try {
            ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
            int i = 0;
            while (i < locations.length) {
                IProgressMonitor subMonitor = Progress.getSubMonitor(progressMonitor, 1);
                fileBufferManager.disconnect(locations[i], subMonitor);
                subMonitor.done();
                ++i;
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private IFileBuffer[] findFileBuffersToSave(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            IFileBuffer buffer = fileBuffers[i];
            if (!buffer.isDirty()) {
                list.add(buffer);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private boolean isCommitable(IFileBuffer[] fileBuffers) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isCommitable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ISchedulingRule computeCommitRule(IFileBuffer[] fileBuffers) {
        ArrayList<ISchedulingRule> list = new ArrayList<ISchedulingRule>();
        int i = 0;
        while (i < fileBuffers.length) {
            ISchedulingRule rule = fileBuffers[i].computeCommitRule();
            if (rule != null) {
                list.add(rule);
            }
            ++i;
        }
        ISchedulingRule[] rules = new ISchedulingRule[list.size()];
        list.toArray(rules);
        return new MultiRule(rules);
    }

    private void commit(final IFileBuffer[] fileBuffers, IProgressMonitor progressMonitor) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor = Progress.getMonitor(monitor);
                monitor.beginTask(FileBuffersMessages.FileBufferOperationRunner_task_committing, fileBuffers.length);
                try {
                    int i = 0;
                    while (i < fileBuffers.length) {
                        IProgressMonitor subMonitor = Progress.getSubMonitor(monitor, 1);
                        fileBuffers[i].commit(subMonitor, true);
                        subMonitor.done();
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, this.computeCommitRule(fileBuffers), 1, progressMonitor);
    }
}

