/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.ProcedureCallCache;
import org.eclipse.wst.rdb.internal.outputview.ResultTableModel;

public class OutputViewModel {
    protected Hashtable outputObjects = new Hashtable();
    protected Vector actionList = new Vector();
    protected ResultTableModel currentResultModel = new ResultTableModel();

    protected void addOutputItem(OutputItem item) {
        if (!this.actionList.contains(item)) {
            this.actionList.add(0, item);
            this.outputObjects.put(item, new OutputObject());
        }
    }

    protected boolean outputItemExists(OutputItem item) {
        return this.actionList.contains(item);
    }

    protected boolean isActionListEmpty() {
        return this.actionList.isEmpty();
    }

    protected ResultTableModel getResultTableModel() {
        return this.currentResultModel;
    }

    protected ResultTableModel getResultTableModel(OutputItem item) {
        if (!this.outputObjects.contains(item)) {
            OutputObject ob = (OutputObject)this.outputObjects.get(item);
            return ob.getResultTableModel();
        }
        return null;
    }

    protected int getResultSetRowCount(OutputItem item) {
        ResultTableModel rsModel = this.getResultTableModel(item);
        if (rsModel == null) {
            return -1;
        }
        return rsModel.getResultSetRowCount();
    }

    protected void addParameters(OutputItem item, Vector parms) {
        this.addOutputItem(item);
        if (parms != null) {
            item.setHasParameters(true);
        }
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        ob.setParameters(parms);
    }

    protected Vector getParameters(OutputItem item) {
        if (!this.outputObjects.contains(item)) {
            OutputObject ob = (OutputObject)this.outputObjects.get(item);
            return ob.getParameters();
        }
        return null;
    }

    protected void addProcedureCall(OutputItem item, ProcedureCallCache proc) throws SQLException {
        this.addOutputItem(item);
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        ob.setProcedureCall(proc);
        if (proc != null) {
            item.setHasResults(true);
        }
    }

    protected void addProcedureCallAndParameters(OutputItem item, ProcedureCallCache proc, Vector parms) throws SQLException {
        this.addOutputItem(item);
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        ob.setProcedureCall(proc);
        item.setHasResults(true);
        if (parms != null) {
            item.setHasParameters(true);
            ob.setParameters(parms);
        }
    }

    protected void addResult(OutputItem item, ResultSet rs) throws SQLException {
        this.addResultAndParameters(item, rs, null);
    }

    protected void addResultAndParameters(OutputItem item, ResultSet rs, Vector parms) throws SQLException {
        this.addOutputItem(item);
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        if (parms != null) {
            item.setHasParameters(true);
            ob.setParameters(parms);
        }
        ob.addTableModel(rs);
        if (rs != null) {
            item.setHasResults(true);
        }
    }

    protected Vector getActionList() {
        return this.actionList;
    }

    protected boolean isFirstResultSet(OutputItem item) {
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        if (ob != null) {
            return ob.isFirstResultSet();
        }
        return true;
    }

    protected boolean isLastResultSet(OutputItem item) {
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        if (ob != null) {
            return ob.isLastResultSet();
        }
        return true;
    }

    protected ResultTableModel getNextResultSetModel(OutputItem item) throws SQLException {
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        if (ob != null) {
            return ob.getNextResultSetModel();
        }
        return null;
    }

    protected ResultTableModel getPreviousResultSetModel(OutputItem item) throws SQLException {
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        if (ob != null) {
            return ob.getPreviousResultSetModel();
        }
        return null;
    }

    protected OutputItem getItem(int idx) {
        if (idx >= 0) {
            return (OutputItem)this.actionList.get(idx);
        }
        return null;
    }

    protected void removeAll() {
        this.outputObjects.clear();
        this.actionList.clear();
    }

    protected void removeOutputItem(OutputItem item) {
        if (this.actionList.contains(item)) {
            this.outputObjects.remove(item);
            this.actionList.remove(item);
        }
    }

    protected void removeOutputItem(int index) {
        this.outputObjects.remove(this.actionList.get(index));
        this.actionList.remove(index);
    }

    protected OutputItem resetItem(OutputItem item) {
        item.setMessage("");
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        if (ob != null) {
            ob.init();
            item.setHasResults(false);
            item.setHasParameters(false);
            item.hasContents = new HashMap();
        }
        return item;
    }

    protected boolean multipleResults(OutputItem item) {
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        if (ob != null) {
            return ob.multipleResults();
        }
        return false;
    }

    protected OutputItem findOutputItem(String uniqueName, int action) {
        OutputItem item = null;
        if (uniqueName != null) {
            int i = 0;
            while (i < this.actionList.size()) {
                item = (OutputItem)this.actionList.get(i);
                if (item.getUniqueName().equals(uniqueName) && item.getActionCode() == action) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    protected void addContents(OutputItem item, String id, Object contents) {
        this.addOutputItem(item);
        if (contents != null) {
            item.setHasContents(id, true);
        }
        OutputObject ob = (OutputObject)this.outputObjects.get(item);
        ob.setContents(id, contents);
    }

    public Object getContents(OutputItem item, String id) {
        if (!this.outputObjects.contains(item)) {
            OutputObject ob = (OutputObject)this.outputObjects.get(item);
            return ob.getContents(id);
        }
        return null;
    }

    protected class OutputObject {
        protected ProcedureCallCache procedureCall;
        protected Vector resultTableModels;
        protected boolean multipleResultSets;
        protected boolean isProcCall;
        protected Vector parameters;
        protected int currentTabModel;
        protected Hashtable contributedContent;

        protected OutputObject() {
            this.init();
        }

        protected void init() {
            this.procedureCall = null;
            this.parameters = null;
            this.multipleResultSets = false;
            this.isProcCall = false;
            this.resultTableModels = new Vector();
            this.currentTabModel = 0;
            this.contributedContent = new Hashtable();
        }

        protected ResultTableModel getResultTableModel() {
            if (this.resultTableModels.isEmpty()) {
                return null;
            }
            return (ResultTableModel)this.resultTableModels.get(this.currentTabModel);
        }

        protected ProcedureCallCache getProcedureCall() {
            return this.procedureCall;
        }

        protected Vector getParameters() {
            return this.parameters;
        }

        protected boolean multipleResults() {
            return this.multipleResultSets;
        }

        protected boolean isFirstResultSet() {
            if (this.procedureCall != null) {
                return this.currentTabModel == 0;
            }
            return true;
        }

        protected boolean isLastResultSet() {
            if (this.procedureCall != null) {
                if (this.currentTabModel + 1 < this.resultTableModels.size()) {
                    return false;
                }
                return this.procedureCall.isLastResult();
            }
            return true;
        }

        protected ResultTableModel getNextResultSetModel() throws SQLException {
            if (this.procedureCall != null) {
                if (this.currentTabModel + 1 < this.resultTableModels.size() && this.resultTableModels.get(this.currentTabModel + 1) != null) {
                    ++this.currentTabModel;
                } else if (!this.procedureCall.isLastResult()) {
                    this.getNextResultSet();
                    this.resultTableModels.add(new ResultTableModel(this.procedureCall));
                    ++this.currentTabModel;
                }
            }
            return this.getResultTableModel();
        }

        protected ResultTableModel getPreviousResultSetModel() throws SQLException {
            if (this.procedureCall != null) {
                if (this.currentTabModel - 1 >= 0 && this.resultTableModels.get(this.currentTabModel - 1) != null) {
                    --this.currentTabModel;
                } else if (this.procedureCall.getCurrentResult() != 1) {
                    this.getPrevResultSet();
                    this.resultTableModels.add(new ResultTableModel(this.procedureCall));
                    --this.currentTabModel;
                }
            }
            return this.getResultTableModel();
        }

        protected void setProcedureCall(ProcedureCallCache pc) throws SQLException {
            this.procedureCall = pc;
            this.isProcCall = true;
            this.multipleResultSets = !this.procedureCall.isLastResult();
            this.resultTableModels.add(new ResultTableModel(this.procedureCall));
        }

        protected void addTableModel(ResultSet rs) throws SQLException {
            this.resultTableModels.add(new ResultTableModel(rs));
        }

        protected void setParameters(Vector parameters) {
            this.parameters = parameters;
        }

        protected void setContents(String id, Object contents) {
            this.contributedContent.put(id, contents);
        }

        protected ProcedureCallCache getPrevResultSet() throws SQLException {
            this.procedureCall.previousResult();
            return this.procedureCall;
        }

        protected ProcedureCallCache getNextResultSet() throws SQLException {
            this.procedureCall.nextResult();
            return this.procedureCall;
        }

        public Object getContents(String id) {
            return this.contributedContent.get(id);
        }
    }
}

