/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.history;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.tigris.subversion.subclipse.core.IResourceStateChangeListener;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.ChangeCommitPropertiesCommand;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.OpenRemoteFileAction;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.console.TextViewerAction;
import org.tigris.subversion.subclipse.ui.dialogs.BranchTagDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistorySearchDialog;
import org.tigris.subversion.subclipse.ui.dialogs.SetCommitPropertiesDialog;
import org.tigris.subversion.subclipse.ui.history.ChangePathsTableProvider;
import org.tigris.subversion.subclipse.ui.history.ChangePathsTreeViewer;
import org.tigris.subversion.subclipse.ui.history.HistorySearchViewerFilter;
import org.tigris.subversion.subclipse.ui.history.HistoryTableProvider;
import org.tigris.subversion.subclipse.ui.history.SVNHistoryPage;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.subclipse.ui.operations.BranchTagOperation;
import org.tigris.subversion.subclipse.ui.operations.MergeOperation;
import org.tigris.subversion.subclipse.ui.operations.ReplaceOperation;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.EmptySearchViewerFilter;
import org.tigris.subversion.subclipse.ui.util.LinkList;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNHistoryPage
extends HistoryPage
implements IResourceStateChangeListener,
KeyListener {
    private SashForm svnHistoryPageControl;
    private SashForm innerSashForm;
    private HistorySearchDialog historySearchDialog;
    HistoryTableProvider historyTableProvider;
    TableViewer tableHistoryViewer;
    StructuredViewer changePathsViewer;
    TextViewer textViewer;
    private boolean showComments;
    private boolean showAffectedPaths;
    private boolean wrapCommentsText;
    boolean shutdown = false;
    private ProjectProperties projectProperties;
    ILogEntry[] entries;
    LogEntryChangePath[] currentLogEntryChangePath;
    ILogEntry lastEntry;
    SVNRevision revisionStart = SVNRevision.HEAD;
    AbstractFetchJob fetchLogEntriesJob = null;
    AbstractFetchJob fetchAllLogEntriesJob = null;
    AbstractFetchJob fetchNextLogEntriesJob = null;
    FetchChangePathJob fetchChangePathJob = null;
    AliasManager tagManager;
    IResource resource;
    ISVNRemoteResource remoteResource;
    ISelection selection;
    private IAction searchAction;
    private IAction clearSearchAction;
    private IAction getNextAction;
    private IAction getAllAction;
    private IAction toggleStopOnCopyAction;
    private IAction toggleShowComments;
    private IAction toggleWrapCommentsAction;
    private IAction toggleShowAffectedPathsAction;
    private IAction openAction;
    private IAction getContentsAction;
    private IAction updateToRevisionAction;
    private IAction openChangedPathAction;
    private IAction showDifferencesAsUnifiedDiffAction;
    private IAction createTagFromRevisionAction;
    private IAction setCommitPropertiesAction;
    private IAction revertChangesAction;
    private IAction refreshAction;
    private ToggleAffectedPathsOptionAction[] toggleAffectedPathsLayoutActions;
    private ToggleAffectedPathsOptionAction[] toggleAffectedPathsModeActions;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private LinkList linkList;
    private Cursor handCursor;
    private Cursor busyCursor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SVNHistoryPage(Object object) {
        SVNProviderPlugin.addResourceStateChangeListener((IResourceStateChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        SVNProviderPlugin.removeResourceStateChangeListener((IResourceStateChangeListener)this);
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
    }

    public Control getControl() {
        return this.svnHistoryPageControl;
    }

    public void setFocus() {
    }

    public String getDescription() {
        return null;
    }

    public String getName() {
        return this.remoteResource == null ? null : String.valueOf(this.remoteResource.getRepositoryRelativePath()) + " in " + this.remoteResource.getRepository();
    }

    public boolean isValidInput(Object object) {
        if (object instanceof IResource) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)((IResource)object).getProject());
            return provider instanceof SVNTeamProvider;
        }
        return object instanceof ISVNRemoteResource;
    }

    public void refresh() {
        this.entries = null;
        this.lastEntry = null;
        this.revisionStart = SVNRevision.HEAD;
        BusyIndicator.showWhile((Display)this.tableHistoryViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (SVNHistoryPage.this.resource != null) {
                    try {
                        SVNHistoryPage.this.remoteResource = SVNWorkspaceRoot.getBaseResourceFor((IResource)SVNHistoryPage.this.resource);
                        SVNHistoryPage.this.historyTableProvider.setRemoteResource(SVNHistoryPage.this.remoteResource);
                        SVNHistoryPage.this.projectProperties = ProjectProperties.getProjectProperties(SVNHistoryPage.this.resource);
                    }
                    catch (SVNException sVNException) {}
                }
                SVNHistoryPage.this.tableHistoryViewer.refresh();
                SVNHistoryPage.this.tableHistoryViewer.resetFilters();
                SVNHistoryPage.this.getClearSearchAction().setEnabled(false);
            }
        });
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean inputSet() {
        Object input = this.getInput();
        if (input instanceof IResource) {
            IResource res = (IResource)input;
            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)res.getProject(), (String)SVNProviderPlugin.getTypeId());
            if (teamProvider == null) return false;
            try {
                LocalResourceStatus localResourceStatus;
                ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)res);
                LocalResourceStatus localResourceStatus2 = localResourceStatus = localResource != null ? localResource.getStatus() : null;
                if (localResource == null || !localResourceStatus.isManaged() || localResourceStatus.isAdded() && !localResourceStatus.isCopied()) return false;
                this.resource = res;
                this.remoteResource = localResource.getBaseResource();
                this.projectProperties = ProjectProperties.getProjectProperties(res);
                this.historyTableProvider.setRemoteResource(this.remoteResource);
                this.tableHistoryViewer.setInput((Object)this.remoteResource);
                this.tableHistoryViewer.resetFilters();
                this.getClearSearchAction().setEnabled(false);
                return true;
            }
            catch (TeamException e) {
                SVNUIPlugin.openError(this.getSite().getShell(), null, null, e);
                return false;
            }
        } else {
            if (!(input instanceof ISVNRemoteResource)) return false;
            this.resource = null;
            this.remoteResource = (ISVNRemoteResource)input;
            this.projectProperties = ProjectProperties.getProjectProperties(this.remoteResource);
            this.historyTableProvider.setRemoteResource(this.remoteResource);
            this.tableHistoryViewer.setInput((Object)this.remoteResource);
            this.tableHistoryViewer.resetFilters();
            this.getClearSearchAction().setEnabled(false);
            return true;
        }
    }

    public void createControl(Composite parent) {
        this.busyCursor = new Cursor((Device)parent.getDisplay(), 1);
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
        this.showComments = store.getBoolean("pref_show_comments");
        this.wrapCommentsText = store.getBoolean("pref_wrap_comments");
        this.showAffectedPaths = store.getBoolean("pref_show_paths");
        this.svnHistoryPageControl = new SashForm(parent, 512);
        this.svnHistoryPageControl.setLayoutData((Object)new GridData(1808));
        this.toggleAffectedPathsModeActions = new ToggleAffectedPathsOptionAction[]{new ToggleAffectedPathsOptionAction(this, "HistoryView.affectedPathsFlatLayout", "elcl16/flatLayout.gif", "pref_affected_paths_layout", 1), new ToggleAffectedPathsOptionAction(this, "HistoryView.affectedPathsCompressedLayout", "elcl16/compressedLayout.gif", "pref_affected_paths_layout", 2)};
        this.toggleAffectedPathsLayoutActions = new ToggleAffectedPathsOptionAction[]{new ToggleAffectedPathsOptionAction(this, "HistoryView.affectedPathsHorizontalLayout", "elcl16/horizontal.gif", "pref_affected_paths_layout2", 1), new ToggleAffectedPathsOptionAction(this, "HistoryView.affectedPathsVerticalLayout", "elcl16/vertical.gif", "pref_affected_paths_layout2", 2)};
        this.createTableHistory((Composite)this.svnHistoryPageControl);
        this.createAffectedPathsViewer();
        this.contributeActions();
        this.svnHistoryPageControl.setWeights(new int[]{70, 30});
    }

    protected void createTableHistory(Composite parent) {
        this.historyTableProvider = new HistoryTableProvider();
        this.tableHistoryViewer = this.historyTableProvider.createTable(parent);
        this.tableHistoryViewer.getTable().addKeyListener((KeyListener)this);
        this.tableHistoryViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (SVNHistoryPage.this.entries != null) {
                    return SVNHistoryPage.this.entries;
                }
                if (!(inputElement instanceof ISVNRemoteResource)) {
                    return null;
                }
                ISVNRemoteResource remoteResource = (ISVNRemoteResource)inputElement;
                IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
                int entriesToFetch = store.getInt("pref_log_entries_to_fetch");
                SVNHistoryPage.this.fetchLogEntriesJob = entriesToFetch > 0 ? new FetchLogEntriesJob() : new FetchAllLogEntriesJob();
                if (SVNHistoryPage.this.fetchLogEntriesJob.getState() != 0) {
                    SVNHistoryPage.this.fetchLogEntriesJob.cancel();
                    try {
                        SVNHistoryPage.this.fetchLogEntriesJob.join();
                    }
                    catch (InterruptedException e) {
                        SVNUIPlugin.log((TeamException)((Object)new SVNException(Policy.bind("HistoryView.errorFetchingEntries", remoteResource.getName()), (Throwable)e)));
                    }
                }
                SVNHistoryPage.this.fetchLogEntriesJob.setRemoteFile(remoteResource);
                Utils.schedule(SVNHistoryPage.this.fetchLogEntriesJob, (IWorkbenchSite)SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                SVNHistoryPage.this.entries = null;
                SVNHistoryPage.this.lastEntry = null;
                SVNHistoryPage.this.revisionStart = SVNRevision.HEAD;
            }
        });
        this.tableHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            private ILogEntry currentLogEntry;

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                ILogEntry logEntry = SVNHistoryPage.this.getLogEntry((IStructuredSelection)selection);
                if (logEntry != this.currentLogEntry) {
                    this.currentLogEntry = logEntry;
                    SVNHistoryPage.this.updatePanels(selection);
                }
                SVNHistoryPage.this.selection = selection;
            }
        });
        this.tableHistoryViewer.getTable().addListener(14, new Listener(){

            public void handleEvent(Event e) {
                SVNHistoryPage.this.getOpenRemoteFileAction().run();
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableHistoryViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                SVNHistoryPage.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableHistoryViewer.getTable().setMenu(menu);
        this.getHistoryPageSite().getPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableHistoryViewer);
    }

    private void fillTableMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("group.file"));
        ISelection sel = this.tableHistoryViewer.getSelection();
        if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
            if (((IStructuredSelection)sel).size() == 1) {
                if (this.resource != null && this.resource instanceof IFile) {
                    manager.add(this.getGetContentsAction());
                    manager.add(this.getUpdateToRevisionAction());
                }
                manager.add(this.getShowDifferencesAsUnifiedDiffAction());
                manager.add(this.getCreateTagFromRevisionAction());
                manager.add(this.getSetCommitPropertiesAction());
            }
            if (this.resource != null) {
                manager.add(this.getRevertChangesAction());
            }
            manager.add((IContributionItem)new Separator("exportImportGroup"));
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add(this.getRefreshAction());
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    public void createAffectedPathsViewer() {
        int[] weights = null;
        weights = this.svnHistoryPageControl.getWeights();
        if (this.innerSashForm != null) {
            this.innerSashForm.dispose();
        }
        if (this.changePathsViewer != null) {
            this.changePathsViewer.getControl().dispose();
        }
        IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
        int mode = store.getInt("pref_affected_paths_layout");
        int layout = store.getInt("pref_affected_paths_layout2");
        if (layout == 1) {
            this.innerSashForm = new SashForm((Composite)this.svnHistoryPageControl, 256);
        } else {
            this.innerSashForm = new SashForm((Composite)this.svnHistoryPageControl, 512);
            this.createText((Composite)this.innerSashForm);
        }
        switch (mode) {
            case 2: {
                this.changePathsViewer = new ChangePathsTreeViewer((Composite)this.innerSashForm, this);
                break;
            }
            default: {
                this.changePathsViewer = new ChangePathsTableProvider((Composite)this.innerSashForm, this);
            }
        }
        this.changePathsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SVNHistoryPage.this.selection = SVNHistoryPage.this.changePathsViewer.getSelection();
            }
        });
        this.changePathsViewer.getControl().addListener(14, new Listener(){

            public void handleEvent(Event e) {
                SVNHistoryPage.this.getOpenChangedPathAction().run();
            }
        });
        if (layout == 1) {
            this.createText((Composite)this.innerSashForm);
        }
        this.setViewerVisibility();
        this.innerSashForm.layout();
        if (weights != null && weights.length == 2) {
            this.svnHistoryPageControl.setWeights(weights);
        }
        this.svnHistoryPageControl.layout();
        this.updatePanels(this.tableHistoryViewer.getSelection());
    }

    protected void createText(Composite parent) {
        SourceViewer result = new SourceViewer(parent, null, null, true, 778);
        result.getTextWidget().setIndent(2);
        result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()){

            public Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
                return Collections.singletonMap("org.eclipse.ui.DefaultTextEditor", new IAdaptable(this){
                    final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object getAdapter(Class adapter) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (adapter == clazz && 15.access$0(this.this$1).getInput() instanceof IResource) {
                            return 15.access$0(this.this$1).getInput();
                        }
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$1 = Class.forName("org.tigris.subversion.subclipse.core.ISVNRemoteResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (adapter == clazz2 && 15.access$0(this.this$1).getInput() instanceof ISVNRemoteResource) {
                            return 15.access$0(this.this$1).getInput();
                        }
                        return Platform.getAdapterManager().getAdapter((Object)((Object)15.access$0(this.this$1)), adapter);
                    }
                });
            }

            public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                return 0;
            }

            public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
                IHyperlinkDetector[] newDetectors;
                IHyperlinkDetector[] detectors = super.getHyperlinkDetectors(sourceViewer);
                if (detectors == null) {
                    newDetectors = new IHyperlinkDetector[1];
                } else {
                    newDetectors = new IHyperlinkDetector[detectors.length + 1];
                    System.arraycopy(detectors, 0, newDetectors, 0, detectors.length);
                }
                newDetectors[newDetectors.length - 1] = new IHyperlinkDetector(this){
                    final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                        if (SVNHistoryPage.access$9(15.access$0(this.this$1)) == null || !SVNHistoryPage.access$9(15.access$0(this.this$1)).isLinkAt(region.getOffset())) {
                            return null;
                        }
                        String linkUrl = SVNHistoryPage.access$9(15.access$0(this.this$1)).getLinkAt(region.getOffset());
                        int[] linkRange = SVNHistoryPage.access$9(15.access$0(this.this$1)).getLinkRange(region.getOffset());
                        return new IHyperlink[]{new IHyperlink(this, linkRange, linkUrl){
                            final /* synthetic */ 17 this$2;
                            private final /* synthetic */ int[] val$linkRange;
                            private final /* synthetic */ String val$linkUrl;
                            {
                                this.this$2 = var1_1;
                                this.val$linkRange = nArray;
                                this.val$linkUrl = string;
                            }

                            public IRegion getHyperlinkRegion() {
                                return new Region(this.val$linkRange[0], this.val$linkRange[1]);
                            }

                            public void open() {
                                try {
                                    URL url = new URL(this.val$linkUrl);
                                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser("Subclipse").openURL(url);
                                }
                                catch (Exception exception) {
                                    Program.launch((String)this.val$linkUrl);
                                }
                            }

                            public String getHyperlinkText() {
                                return null;
                            }

                            public String getTypeLabel() {
                                return null;
                            }
                        }};
                    }
                };
                return newDetectors;
            }

            static /* synthetic */ SVNHistoryPage access$0(15 var0) {
                return var0.SVNHistoryPage.this;
            }
        });
        this.textViewer = result;
        this.textViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SVNHistoryPage.this.copyAction.update();
            }
        });
        Font font = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("svn_comment_font");
        if (font != null) {
            this.textViewer.getTextWidget().setFont(font);
        }
        this.copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
        this.copyAction.setText(Policy.bind("HistoryView.copy"));
        this.selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
        this.selectAllAction.setText(Policy.bind("HistoryView.selectAll"));
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        IPageSite pageSite = parentSite.getWorkbenchPageSite();
        IActionBars actionBars = pageSite.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
        actionBars.updateActionBars();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                menuMgr.add((IAction)SVNHistoryPage.this.copyAction);
                menuMgr.add((IAction)SVNHistoryPage.this.selectAllAction);
            }
        });
        StyledText text = this.textViewer.getTextWidget();
        Menu menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void contributeActions() {
        SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
        final IPreferenceStore store = plugin.getPreferenceStore();
        this.toggleShowComments = new Action(Policy.bind("HistoryView.showComments"), SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/comments.gif")){

            public void run() {
                SVNHistoryPage.this.showComments = this.isChecked();
                SVNHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_comments", SVNHistoryPage.this.showComments);
            }
        };
        this.toggleShowComments.setChecked(this.showComments);
        this.toggleWrapCommentsAction = new Action(Policy.bind("HistoryView.wrapComments")){

            public void run() {
                SVNHistoryPage.this.wrapCommentsText = this.isChecked();
                SVNHistoryPage.this.setViewerVisibility();
                store.setValue("pref_wrap_comments", SVNHistoryPage.this.wrapCommentsText);
            }
        };
        this.toggleWrapCommentsAction.setChecked(this.wrapCommentsText);
        this.toggleShowAffectedPathsAction = new Action(Policy.bind("HistoryView.showAffectedPaths"), SVNUIPlugin.getPlugin().getImageDescriptor("elcl16/flatLayout.gif")){

            public void run() {
                SVNHistoryPage.this.showAffectedPaths = this.isChecked();
                SVNHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_paths", SVNHistoryPage.this.showAffectedPaths);
            }
        };
        this.toggleShowAffectedPathsAction.setChecked(this.showAffectedPaths);
        this.toggleStopOnCopyAction = new Action(Policy.bind("HistoryView.stopOnCopy")){

            public void run() {
                SVNHistoryPage.this.refresh();
                SVNUIPlugin.getPlugin().getPreferenceStore().setValue("pref_stop_on_copy", SVNHistoryPage.this.toggleStopOnCopyAction.isChecked());
            }
        };
        this.toggleStopOnCopyAction.setChecked(store.getBoolean("pref_stop_on_copy"));
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        IPageSite pageSite = parentSite.getWorkbenchPageSite();
        IActionBars actionBars = pageSite.getActionBars();
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        actionBarsMenu.add(this.getGetNextAction());
        actionBarsMenu.add(this.getGetAllAction());
        actionBarsMenu.add(this.toggleStopOnCopyAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add(this.toggleWrapCommentsAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add(this.toggleShowComments);
        actionBarsMenu.add(this.toggleShowAffectedPathsAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.toggleAffectedPathsModeActions[0]);
        actionBarsMenu.add((IAction)this.toggleAffectedPathsModeActions[1]);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.toggleAffectedPathsLayoutActions[0]);
        actionBarsMenu.add((IAction)this.toggleAffectedPathsLayoutActions[1]);
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.getSearchAction());
        tbm.add(this.getClearSearchAction());
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.toggleShowComments);
        tbm.add(this.toggleShowAffectedPathsAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add(this.getGetNextAction());
        tbm.add(this.getGetAllAction());
        tbm.update(false);
        actionBars.updateActionBars();
    }

    ILogEntry getLogEntry(IStructuredSelection ss) {
        if (ss.getFirstElement() instanceof LogEntryChangePath) {
            return ((LogEntryChangePath)ss.getFirstElement()).getLogEntry();
        }
        return (ILogEntry)ss.getFirstElement();
    }

    void updatePanels(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            this.textViewer.setDocument((IDocument)new Document(""));
            this.changePathsViewer.setInput(null);
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            this.textViewer.setDocument((IDocument)new Document(""));
            this.changePathsViewer.setInput(null);
            return;
        }
        LogEntry entry = (LogEntry)ss.getFirstElement();
        this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
        StyledText text = this.textViewer.getTextWidget();
        this.linkList = this.projectProperties == null ? ProjectProperties.getUrls(entry.getComment()) : this.projectProperties.getLinkList(entry.getComment());
        if (this.linkList != null) {
            int[][] linkRanges = this.linkList.getLinkRanges();
            int i = 0;
            while (i < linkRanges.length) {
                text.setStyleRange(new StyleRange(linkRanges[i][0], linkRanges[i][1], JFaceColors.getHyperlinkText((Display)Display.getCurrent()), null));
                ++i;
            }
        }
        this.changePathsViewer.setInput((Object)entry);
    }

    void setViewerVisibility() {
        if (this.showComments && this.showAffectedPaths) {
            this.svnHistoryPageControl.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
        } else if (this.showComments) {
            this.svnHistoryPageControl.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (this.showAffectedPaths) {
            this.svnHistoryPageControl.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(this.changePathsViewer.getControl());
        } else {
            this.svnHistoryPageControl.setMaximizedControl(this.tableHistoryViewer.getControl());
        }
        this.changePathsViewer.refresh();
        this.textViewer.getTextWidget().setWordWrap(this.wrapCommentsText);
    }

    void setCurrentLogEntryChangePath(final LogEntryChangePath[] currentLogEntryChangePath) {
        this.currentLogEntryChangePath = currentLogEntryChangePath;
        if (!this.shutdown) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (currentLogEntryChangePath != null && SVNHistoryPage.this.changePathsViewer != null && !SVNHistoryPage.this.changePathsViewer.getControl().isDisposed()) {
                        SVNHistoryPage.this.changePathsViewer.refresh();
                    }
                }
            });
        }
    }

    public void selectRevision(SVNRevision.Number revision) {
        if (this.entries == null) {
            return;
        }
        ILogEntry entry = null;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].getRevision().equals((Object)revision)) {
                entry = this.entries[i];
                break;
            }
            ++i;
        }
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            this.tableHistoryViewer.setSelection((ISelection)selection, true);
        }
    }

    public void scheduleFetchChangePathJob(ILogEntry logEntry) {
        if (this.fetchChangePathJob == null) {
            this.fetchChangePathJob = new FetchChangePathJob();
        }
        if (this.fetchChangePathJob.getState() != 0) {
            this.fetchChangePathJob.cancel();
            try {
                this.fetchChangePathJob.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.fetchChangePathJob.setLogEntry(logEntry);
        Utils.schedule(this.fetchChangePathJob, (IWorkbenchSite)this.getSite());
    }

    public boolean isShowChangePaths() {
        return this.showAffectedPaths;
    }

    private IAction getOpenRemoteFileAction() {
        if (this.openAction == null) {
            this.openAction = new Action(){

                public void run() {
                    OpenRemoteFileAction delegate = new OpenRemoteFileAction();
                    delegate.init((IAction)this);
                    delegate.selectionChanged((IAction)this, SVNHistoryPage.this.tableHistoryViewer.getSelection());
                    if (this.isEnabled()) {
                        delegate.run((IAction)this);
                    }
                }
            };
        }
        return this.openAction;
    }

    private IAction getOpenChangedPathAction() {
        if (this.openChangedPathAction == null) {
            this.openChangedPathAction = new Action(){

                public void run() {
                    OpenRemoteFileAction delegate = new OpenRemoteFileAction();
                    delegate.init((IAction)this);
                    delegate.selectionChanged((IAction)this, SVNHistoryPage.this.changePathsViewer.getSelection());
                    if (this.isEnabled()) {
                        delegate.run((IAction)this);
                    }
                }
            };
        }
        return this.openChangedPathAction;
    }

    private IAction getGetContentsAction() {
        if (this.getContentsAction == null) {
            this.getContentsAction = this.getContextMenuAction(Policy.bind("HistoryView.getContentsAction"), new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws CoreException {
                    ISelection selection = SVNHistoryPage.this.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ISVNRemoteFile remoteFile = (ISVNRemoteFile)SVNHistoryPage.this.getLogEntry(ss).getRemoteResource();
                    monitor.beginTask(null, 100);
                    try {
                        try {
                            if (remoteFile != null && SVNHistoryPage.this.confirmOverwrite()) {
                                InputStream in = remoteFile.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 50)).getContents();
                                IFile file = (IFile)SVNHistoryPage.this.resource;
                                file.setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            }
                        }
                        catch (TeamException e) {
                            throw new CoreException(e.getStatus());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var7_10 = null;
                    }
                    monitor.done();
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getContentsAction, "org.tigris.subversion.subclipse.ui.get_file_contents_action_context");
        }
        return this.getContentsAction;
    }

    private IAction getShowDifferencesAsUnifiedDiffAction() {
        if (this.showDifferencesAsUnifiedDiffAction == null) {
            this.showDifferencesAsUnifiedDiffAction = new Action(Policy.bind("HistoryView.showDifferences"), SVNUIPlugin.getPlugin().getImageDescriptor("Menu Diff")){

                public void run() {
                    ISelection selection = SVNHistoryPage.this.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    ILogEntry currentSelection = SVNHistoryPage.this.getLogEntry((IStructuredSelection)selection);
                    FileDialog dialog = new FileDialog(SVNHistoryPage.this.getSite().getShell(), 8192);
                    dialog.setText("Select Unified Diff Output File");
                    dialog.setFileName("revision" + currentSelection.getRevision().getNumber() + ".diff");
                    String outFile = dialog.open();
                    if (outFile != null) {
                        SVNUrl url = currentSelection.getResource().getUrl();
                        SVNRevision.Number oldUrlRevision = new SVNRevision.Number(currentSelection.getRevision().getNumber() - 1L);
                        SVNRevision.Number newUrlRevision = currentSelection.getRevision();
                        File file = new File(outFile);
                        if (file.exists() && !MessageDialog.openQuestion((Shell)SVNHistoryPage.this.getSite().getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)Policy.bind("HistoryView.overwriteOutfile", file.getName()))) {
                            return;
                        }
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, url, (SVNRevision)oldUrlRevision, (SVNRevision)newUrlRevision, file){
                            final /* synthetic */ 29 this$1;
                            private final /* synthetic */ SVNUrl val$url;
                            private final /* synthetic */ SVNRevision val$oldUrlRevision;
                            private final /* synthetic */ SVNRevision val$newUrlRevision;
                            private final /* synthetic */ File val$file;
                            {
                                this.this$1 = var1_1;
                                this.val$url = sVNUrl;
                                this.val$oldUrlRevision = sVNRevision;
                                this.val$newUrlRevision = sVNRevision2;
                                this.val$file = file;
                            }

                            public void run() {
                                try {
                                    ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClientManager().createSVNClient();
                                    client.diff(this.val$url, this.val$oldUrlRevision, this.val$newUrlRevision, this.val$file, true);
                                }
                                catch (Exception e) {
                                    MessageDialog.openError((Shell)29.access$0(this.this$1).getSite().getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)e.getMessage());
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ SVNHistoryPage access$0(29 var0) {
                    return var0.SVNHistoryPage.this;
                }
            };
        }
        return this.showDifferencesAsUnifiedDiffAction;
    }

    private IAction getUpdateToRevisionAction() {
        if (this.updateToRevisionAction == null) {
            this.updateToRevisionAction = this.getContextMenuAction(Policy.bind("HistoryView.getRevisionAction"), new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISelection selection = SVNHistoryPage.this.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ISVNRemoteFile remoteFile = (ISVNRemoteFile)SVNHistoryPage.this.getLogEntry(ss).getRemoteResource();
                    try {
                        if (remoteFile != null && SVNHistoryPage.this.confirmOverwrite()) {
                            IFile file = (IFile)SVNHistoryPage.this.resource;
                            new ReplaceOperation(SVNHistoryPage.this.getSite().getPage().getActivePart(), (IResource)file, (SVNRevision)remoteFile.getLastChangedRevision()).run(monitor);
                            SVNHistoryPage.this.historyTableProvider.setRemoteResource((ISVNRemoteResource)remoteFile);
                            Display.getDefault().asyncExec(new Runnable(this){
                                final /* synthetic */ 31 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    31.access$0(this.this$1).tableHistoryViewer.refresh();
                                }
                            });
                        }
                    }
                    catch (InvocationTargetException e) {
                        throw new CoreException((IStatus)new SVNStatus(4, 0, e.getMessage()));
                    }
                    catch (InterruptedException interruptedException) {}
                }

                static /* synthetic */ SVNHistoryPage access$0(31 var0) {
                    return var0.SVNHistoryPage.this;
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.updateToRevisionAction, "org.tigris.subversion.subclipse.ui.get_file_revision_action_context");
        }
        return this.updateToRevisionAction;
    }

    private IAction getCreateTagFromRevisionAction() {
        if (this.createTagFromRevisionAction == null) {
            this.createTagFromRevisionAction = new Action(Policy.bind("HistoryView.createTagFromRevision"), SVNUIPlugin.getPlugin().getImageDescriptor("Menu Branch/Tag")){

                public void run() {
                    ISelection selection = SVNHistoryPage.this.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    ILogEntry currentSelection = SVNHistoryPage.this.getLogEntry((IStructuredSelection)selection);
                    BranchTagDialog dialog = SVNHistoryPage.this.resource == null ? new BranchTagDialog(SVNHistoryPage.this.getSite().getShell(), SVNHistoryPage.this.historyTableProvider.getRemoteResource()) : new BranchTagDialog(SVNHistoryPage.this.getSite().getShell(), SVNHistoryPage.this.resource);
                    dialog.setRevisionNumber(currentSelection.getRevision().getNumber());
                    if (dialog.open() == 1) {
                        return;
                    }
                    SVNUrl sourceUrl = dialog.getUrl();
                    SVNUrl destinationUrl = dialog.getToUrl();
                    String message = dialog.getComment();
                    SVNRevision revision = dialog.getRevision();
                    boolean createOnServer = dialog.isCreateOnServer();
                    IResource[] resources = new IResource[]{SVNHistoryPage.this.resource};
                    try {
                        if (SVNHistoryPage.this.resource == null) {
                            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this, sourceUrl, destinationUrl, message, revision){
                                final /* synthetic */ 33 this$1;
                                private final /* synthetic */ SVNUrl val$sourceUrl;
                                private final /* synthetic */ SVNUrl val$destinationUrl;
                                private final /* synthetic */ String val$message;
                                private final /* synthetic */ SVNRevision val$revision;
                                {
                                    this.this$1 = var1_1;
                                    this.val$sourceUrl = sVNUrl;
                                    this.val$destinationUrl = sVNUrl2;
                                    this.val$message = string;
                                    this.val$revision = sVNRevision;
                                }

                                public void run() {
                                    try {
                                        ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClientManager().createSVNClient();
                                        client.copy(this.val$sourceUrl, this.val$destinationUrl, this.val$message, this.val$revision);
                                    }
                                    catch (Exception e) {
                                        MessageDialog.openError((Shell)33.access$0(this.this$1).getSite().getShell(), (String)Policy.bind("HistoryView.createTagFromRevision"), (String)e.getMessage());
                                    }
                                }
                            });
                        } else {
                            new BranchTagOperation(SVNHistoryPage.this.getSite().getPage().getActivePart(), resources, sourceUrl, destinationUrl, createOnServer, dialog.getRevision(), message).run();
                        }
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)SVNHistoryPage.this.getSite().getShell(), (String)Policy.bind("HistoryView.createTagFromRevision"), (String)e.getMessage());
                    }
                }

                static /* synthetic */ SVNHistoryPage access$0(33 var0) {
                    return var0.SVNHistoryPage.this;
                }
            };
        }
        return this.createTagFromRevisionAction;
    }

    private IAction getSetCommitPropertiesAction() {
        if (this.setCommitPropertiesAction == null) {
            this.setCommitPropertiesAction = new Action(Policy.bind("HistoryView.setCommitProperties")){

                public void run() {
                    try {
                        boolean doCommit;
                        ISelection selection = SVNHistoryPage.this.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        ILogEntry ourSelection = SVNHistoryPage.this.getLogEntry((IStructuredSelection)selection);
                        ProjectProperties projectProperties = SVNHistoryPage.this.resource != null ? ProjectProperties.getProjectProperties(SVNHistoryPage.this.resource) : ProjectProperties.getProjectProperties(ourSelection.getRemoteResource());
                        ISVNRemoteResource svnResource = ourSelection.getRemoteResource() != null ? ourSelection.getRemoteResource() : ourSelection.getResource();
                        SetCommitPropertiesDialog dialog = new SetCommitPropertiesDialog(SVNHistoryPage.this.getSite().getShell(), (SVNRevision)ourSelection.getRevision(), SVNHistoryPage.this.resource, projectProperties);
                        dialog.setOldAuthor(ourSelection.getAuthor());
                        dialog.setOldComment(ourSelection.getComment());
                        boolean bl = doCommit = dialog.open() == 0;
                        if (doCommit) {
                            String author = ourSelection.getAuthor().equals(dialog.getAuthor()) ? null : dialog.getAuthor();
                            String commitComment = ourSelection.getComment().equals(dialog.getComment()) ? null : dialog.getComment();
                            ChangeCommitPropertiesCommand command = new ChangeCommitPropertiesCommand(svnResource.getRepository(), ourSelection.getRevision(), commitComment, author);
                            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(this, ourSelection, command, commitComment, author, selection){
                                final /* synthetic */ 35 this$1;
                                private final /* synthetic */ ILogEntry val$ourSelection;
                                private final /* synthetic */ ChangeCommitPropertiesCommand val$command;
                                private final /* synthetic */ String val$commitComment;
                                private final /* synthetic */ String val$author;
                                private final /* synthetic */ ISelection val$selection;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ourSelection = iLogEntry;
                                    this.val$command = changeCommitPropertiesCommand;
                                    this.val$commitComment = string;
                                    this.val$author = string2;
                                    this.val$selection = iSelection;
                                }

                                /*
                                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                    try {
                                        try {
                                            this.val$command.run(monitor);
                                        }
                                        catch (SVNException e) {
                                            throw new InvocationTargetException(e);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var3_4 = null;
                                        if (this.val$ourSelection instanceof LogEntry) {
                                            LogEntry logEntry = (LogEntry)this.val$ourSelection;
                                            if (this.val$command.isLogMessageChanged()) {
                                                logEntry.setComment(this.val$commitComment);
                                            }
                                            if (this.val$command.isAuthorChanged()) {
                                                logEntry.setAuthor(this.val$author);
                                            }
                                        }
                                        35.access$0(this.this$1).getSite().getShell().getDisplay().asyncExec(new Runnable(this, this.val$selection){
                                            final /* synthetic */ 36 this$2;
                                            private final /* synthetic */ ISelection val$selection;
                                            {
                                                this.this$2 = var1_1;
                                                this.val$selection = iSelection;
                                            }

                                            public void run() {
                                                35.access$0(36.access$0(this.this$2)).tableHistoryViewer.refresh();
                                                35.access$0(36.access$0(this.this$2)).tableHistoryViewer.setSelection(this.val$selection, true);
                                            }
                                        });
                                        throw throwable;
                                    }
                                    {
                                        Object var3_5 = null;
                                    }
                                    if (this.val$ourSelection instanceof LogEntry) {
                                        LogEntry logEntry = (LogEntry)this.val$ourSelection;
                                        if (this.val$command.isLogMessageChanged()) {
                                            logEntry.setComment(this.val$commitComment);
                                        }
                                        if (this.val$command.isAuthorChanged()) {
                                            logEntry.setAuthor(this.val$author);
                                        }
                                    }
                                    35.access$0(this.this$1).getSite().getShell().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                                }

                                static /* synthetic */ 35 access$0(36 var0) {
                                    return var0.this$1;
                                }
                            });
                        }
                    }
                    catch (InvocationTargetException e) {
                        SVNUIPlugin.openError(SVNHistoryPage.this.getSite().getShell(), null, null, e, 12);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (SVNException e) {
                        SVNUIPlugin.openError(SVNHistoryPage.this.getSite().getShell(), null, null, e, 2);
                    }
                }

                public boolean isEnabled() {
                    ISelection selection = SVNHistoryPage.this.getSelection();
                    return selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1;
                }

                static /* synthetic */ SVNHistoryPage access$0(35 var0) {
                    return var0.SVNHistoryPage.this;
                }
            };
        }
        return this.setCommitPropertiesAction;
    }

    private IAction getRevertChangesAction() {
        ISelection selection;
        if (this.revertChangesAction == null) {
            this.revertChangesAction = new Action(){

                public void run() {
                    ISelection selection = SVNHistoryPage.this.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    if (ss.size() == 1 ? !MessageDialog.openConfirm((Shell)SVNHistoryPage.this.getSite().getShell(), (String)this.getText(), (String)Policy.bind("HistoryView.confirmRevertRevision", SVNHistoryPage.this.resource.getFullPath().toString())) : !MessageDialog.openConfirm((Shell)SVNHistoryPage.this.getSite().getShell(), (String)this.getText(), (String)Policy.bind("HistoryView.confirmRevertRevisions", SVNHistoryPage.this.resource.getFullPath().toString()))) {
                        return;
                    }
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                        final /* synthetic */ 38 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ILogEntry firstElement = SVNHistoryPage.access$20(38.access$0(this.this$1));
                            ILogEntry lastElement = SVNHistoryPage.access$21(38.access$0(this.this$1));
                            SVNUrl path1 = firstElement.getResource().getUrl();
                            SVNRevision.Number revision1 = firstElement.getRevision();
                            SVNUrl path2 = lastElement.getResource().getUrl();
                            SVNRevision.Number revision2 = new SVNRevision.Number(lastElement.getRevision().getNumber() - 1L);
                            IResource[] resources = new IResource[]{38.access$0(this.this$1).resource};
                            try {
                                WorkspaceAction mergeAction = new WorkspaceAction(this, resources, path1, (SVNRevision)revision1, path2, (SVNRevision)revision2){
                                    final /* synthetic */ 39 this$2;
                                    private final /* synthetic */ IResource[] val$resources;
                                    private final /* synthetic */ SVNUrl val$path1;
                                    private final /* synthetic */ SVNRevision val$revision1;
                                    private final /* synthetic */ SVNUrl val$path2;
                                    private final /* synthetic */ SVNRevision val$revision2;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$resources = iResourceArray;
                                        this.val$path1 = sVNUrl;
                                        this.val$revision1 = sVNRevision;
                                        this.val$path2 = sVNUrl2;
                                        this.val$revision2 = sVNRevision2;
                                    }

                                    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
                                        new MergeOperation(38.access$0(39.access$0(this.this$2)).getSite().getPage().getActivePart(), this.val$resources, this.val$path1, this.val$revision1, this.val$path2, this.val$revision2).run();
                                    }
                                };
                                mergeAction.run(null);
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)38.access$0(this.this$1).getSite().getShell(), (String)SVNHistoryPage.access$22(38.access$0(this.this$1)).getText(), (String)e.getMessage());
                            }
                        }

                        static /* synthetic */ 38 access$0(39 var0) {
                            return var0.this$1;
                        }
                    });
                }

                static /* synthetic */ SVNHistoryPage access$0(38 var0) {
                    return var0.SVNHistoryPage.this;
                }
            };
        }
        if ((selection = this.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() == 1) {
                ILogEntry currentSelection = this.getLogEntry(ss);
                this.revertChangesAction.setText(Policy.bind("HistoryView.revertChangesFromRevision", "" + currentSelection.getRevision().getNumber()));
            }
            if (ss.size() > 1) {
                ILogEntry firstElement = this.getFirstElement();
                ILogEntry lastElement = this.getLastElement();
                this.revertChangesAction.setText(Policy.bind("HistoryView.revertChangesFromRevisions", "" + lastElement.getRevision().getNumber(), "" + firstElement.getRevision().getNumber()));
            }
        }
        this.revertChangesAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Mark Merged"));
        return this.revertChangesAction;
    }

    private IAction getRefreshAction() {
        if (this.refreshAction == null) {
            SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
            this.refreshAction = new Action(Policy.bind("HistoryView.refreshLabel"), plugin.getImageDescriptor("elcl16/refresh.gif")){

                public void run() {
                    SVNHistoryPage.this.refresh();
                }
            };
            this.refreshAction.setToolTipText(Policy.bind("HistoryView.refresh"));
            this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
            this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("clcl16/refresh.gif"));
        }
        return this.refreshAction;
    }

    private IAction getSearchAction() {
        if (this.searchAction == null) {
            SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
            this.searchAction = new Action(Policy.bind("HistoryView.search"), plugin.getImageDescriptor("clcl16/filter_history.gif")){

                public void run() {
                    if (SVNHistoryPage.this.historySearchDialog == null) {
                        SVNHistoryPage.this.historySearchDialog = new HistorySearchDialog(SVNHistoryPage.this.getSite().getShell(), SVNHistoryPage.this.remoteResource);
                    }
                    SVNHistoryPage.this.historySearchDialog.setRemoteResource(SVNHistoryPage.this.remoteResource);
                    if (SVNHistoryPage.this.historySearchDialog.open() == 0) {
                        SVNHistoryPage.this.searchAction.setEnabled(false);
                        Utils.schedule(new SearchHistoryJob(), (IWorkbenchSite)SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
                    }
                }
            };
            this.searchAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/filter_history.gif"));
        }
        return this.searchAction;
    }

    private IAction getClearSearchAction() {
        if (this.clearSearchAction == null) {
            SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
            this.clearSearchAction = new Action(Policy.bind("HistoryView.clearSearch"), plugin.getImageDescriptor("clcl16/clear_co.gif")){

                public void run() {
                    BusyIndicator.showWhile((Display)SVNHistoryPage.this.tableHistoryViewer.getTable().getDisplay(), (Runnable)new Runnable(this){
                        final /* synthetic */ 43 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ViewerFilter[] filters = 43.access$0(this.this$1).tableHistoryViewer.getFilters();
                            int i = 0;
                            while (i < filters.length) {
                                ViewerFilter filter = filters[i];
                                if (filter instanceof HistorySearchViewerFilter) {
                                    43.access$0(this.this$1).tableHistoryViewer.removeFilter(filter);
                                } else if (filter instanceof EmptySearchViewerFilter) {
                                    43.access$0(this.this$1).tableHistoryViewer.removeFilter(filter);
                                }
                                ++i;
                            }
                            this.this$1.setEnabled(false);
                        }
                    });
                }

                static /* synthetic */ SVNHistoryPage access$0(43 var0) {
                    return var0.SVNHistoryPage.this;
                }
            };
            this.clearSearchAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/clear_co.gif"));
        }
        return this.clearSearchAction;
    }

    private IAction getGetAllAction() {
        if (this.getAllAction == null) {
            SVNUIPlugin plugin = SVNUIPlugin.getPlugin();
            this.getAllAction = new Action(Policy.bind("HistoryView.getAll"), plugin.getImageDescriptor("clcl16/get_all.gif")){

                public void run() {
                    ISVNRemoteResource remoteResource = SVNHistoryPage.this.historyTableProvider.getRemoteResource();
                    if (SVNHistoryPage.this.fetchAllLogEntriesJob == null) {
                        SVNHistoryPage.this.fetchAllLogEntriesJob = new FetchAllLogEntriesJob();
                    }
                    if (SVNHistoryPage.this.fetchAllLogEntriesJob.getState() != 0) {
                        SVNHistoryPage.this.fetchAllLogEntriesJob.cancel();
                        try {
                            SVNHistoryPage.this.fetchAllLogEntriesJob.join();
                        }
                        catch (InterruptedException e) {
                            SVNUIPlugin.log((TeamException)((Object)new SVNException(Policy.bind("HistoryView.errorFetchingEntries", remoteResource.getName()), (Throwable)e)));
                        }
                    }
                    SVNHistoryPage.this.fetchAllLogEntriesJob.setRemoteFile(remoteResource);
                    Utils.schedule(SVNHistoryPage.this.fetchAllLogEntriesJob, (IWorkbenchSite)SVNHistoryPage.this.getSite());
                }
            };
            this.getAllAction.setToolTipText(Policy.bind("HistoryView.getAll"));
        }
        return this.getAllAction;
    }

    public IAction getGetNextAction() {
        if (this.getNextAction == null) {
            this.getNextAction = new GetNextAction();
        }
        return this.getNextAction;
    }

    private Action getContextMenuAction(String title, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                try {
                    if (SVNHistoryPage.this.resource == null) {
                        return;
                    }
                    PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(this, action){
                        final /* synthetic */ 46 this$1;
                        private final /* synthetic */ IWorkspaceRunnable val$action;
                        {
                            this.this$1 = var1_1;
                            this.val$action = iWorkspaceRunnable;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                this.val$action.run(monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    SVNUIPlugin.openError(SVNHistoryPage.this.getSite().getShell(), null, null, e, 12);
                }
                catch (InterruptedException interruptedException) {}
            }

            public boolean isEnabled() {
                ISelection selection = SVNHistoryPage.this.getSelection();
                return selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        IFile file = (IFile)this.resource;
        if (file != null && file.exists()) {
            ISVNLocalFile svnFile = SVNWorkspaceRoot.getSVNFileFor((IFile)file);
            try {
                if (svnFile.isDirty()) {
                    String title = Policy.bind("HistoryView.overwriteTitle");
                    String msg = Policy.bind("HistoryView.overwriteMsg");
                    final MessageDialog dialog = new MessageDialog(this.getSite().getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    final int[] result = new int[1];
                    this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            result[0] = dialog.open();
                        }
                    });
                    if (result[0] != 0) {
                        return false;
                    }
                }
            }
            catch (SVNException e) {
                SVNUIPlugin.log(e.getStatus());
            }
        }
        return true;
    }

    private ISelection getSelection() {
        return this.selection;
    }

    private ILogEntry getFirstElement() {
        ILogEntry firstElement = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iter = ss.iterator();
            while (iter.hasNext()) {
                ILogEntry element = (ILogEntry)iter.next();
                if (firstElement != null && element.getRevision().getNumber() <= firstElement.getRevision().getNumber()) continue;
                firstElement = element;
            }
        }
        return firstElement;
    }

    private ILogEntry getLastElement() {
        ILogEntry lastElement = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iter = ss.iterator();
            while (iter.hasNext()) {
                ILogEntry element = (ILogEntry)iter.next();
                if (lastElement != null && element.getRevision().getNumber() >= lastElement.getRevision().getNumber()) continue;
                lastElement = element;
            }
        }
        return lastElement;
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        int i = 0;
        while (i < changedResources.length) {
            IResource changedResource = changedResources[i];
            if (changedResource.equals((Object)this.resource)) {
                this.resourceChanged();
            }
            ++i;
        }
    }

    private void resourceChanged() {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SVNHistoryPage.this.revisionStart = SVNRevision.HEAD;
                ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)SVNHistoryPage.this.resource);
                try {
                    if (localResource != null && !localResource.getStatus().isAdded()) {
                        ISVNRemoteResource baseResource = localResource.getBaseResource();
                        SVNHistoryPage.this.historyTableProvider.setRemoteResource(baseResource);
                        SVNHistoryPage.this.tableHistoryViewer.refresh();
                    }
                }
                catch (SVNException e) {
                    SVNUIPlugin.openError(SVNHistoryPage.this.getHistoryPageSite().getShell(), null, null, e);
                }
            }
        });
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 102 && e.stateMask == 262144) {
            this.getSearchAction().run();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void resourceModified(IResource[] changedResources) {
    }

    public void projectConfigured(IProject project) {
    }

    public void projectDeconfigured(IProject project) {
    }

    static /* synthetic */ LinkList access$9(SVNHistoryPage sVNHistoryPage) {
        return sVNHistoryPage.linkList;
    }

    static /* synthetic */ ILogEntry access$20(SVNHistoryPage sVNHistoryPage) {
        return sVNHistoryPage.getFirstElement();
    }

    static /* synthetic */ ILogEntry access$21(SVNHistoryPage sVNHistoryPage) {
        return sVNHistoryPage.getLastElement();
    }

    static /* synthetic */ IAction access$22(SVNHistoryPage sVNHistoryPage) {
        return sVNHistoryPage.revertChangesAction;
    }

    private final class GetNextAction
    extends Action
    implements IPropertyChangeListener {
        GetNextAction() {
            super(Policy.bind("HistoryView.getNext"), SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/get_next.gif"));
            this.updateFromProperties();
            SVNUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void run() {
            ISVNRemoteResource remoteResource = SVNHistoryPage.this.historyTableProvider.getRemoteResource();
            if (SVNHistoryPage.this.fetchNextLogEntriesJob == null) {
                SVNHistoryPage.this.fetchNextLogEntriesJob = new FetchNextLogEntriesJob();
            }
            if (SVNHistoryPage.this.fetchNextLogEntriesJob.getState() != 0) {
                SVNHistoryPage.this.fetchNextLogEntriesJob.cancel();
                try {
                    SVNHistoryPage.this.fetchNextLogEntriesJob.join();
                }
                catch (InterruptedException e) {
                    SVNUIPlugin.log((TeamException)((Object)new SVNException(Policy.bind("HistoryView.errorFetchingEntries", remoteResource.getName()), (Throwable)e)));
                }
            }
            SVNHistoryPage.this.fetchNextLogEntriesJob.setRemoteFile(remoteResource);
            Utils.schedule(SVNHistoryPage.this.fetchNextLogEntriesJob, (IWorkbenchSite)SVNHistoryPage.this.getSite());
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("pref_log_entries_to_fetch".equals(event.getProperty())) {
                this.updateFromProperties();
            }
        }

        private void updateFromProperties() {
            int entriesToFetch = SVNUIPlugin.getPlugin().getPreferenceStore().getInt("pref_log_entries_to_fetch");
            this.setToolTipText(String.valueOf(Policy.bind("HistoryView.getNext")) + " " + entriesToFetch);
            if (entriesToFetch <= 0) {
                this.setEnabled(false);
            }
        }
    }

    private class FetchLogEntriesJob
    extends AbstractFetchJob {
        public ISVNRemoteResource remoteResource;

        public FetchLogEntriesJob() {
            super(Policy.bind("HistoryView.fetchHistoryJob"));
        }

        public void setRemoteFile(ISVNRemoteResource resource) {
            this.remoteResource = resource;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this.remoteResource != null && !SVNHistoryPage.this.shutdown) {
                    SVNHistoryPage.this.tagManager = SVNHistoryPage.this.resource == null ? (this.remoteResource == null || !SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_tags_in_remote") ? null : new AliasManager(this.remoteResource.getUrl())) : new AliasManager(SVNHistoryPage.this.resource);
                    SVNRevision pegRevision = this.remoteResource.getRevision();
                    SVNRevision.Number revisionEnd = new SVNRevision.Number(0L);
                    boolean stopOnCopy = SVNHistoryPage.this.toggleStopOnCopyAction.isChecked();
                    IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
                    int entriesToFetch = store.getInt("pref_log_entries_to_fetch");
                    long limit = entriesToFetch;
                    SVNHistoryPage.this.entries = this.getLogEntries(monitor, this.remoteResource, pegRevision, SVNHistoryPage.this.revisionStart, (SVNRevision)revisionEnd, stopOnCopy, limit + 1L, SVNHistoryPage.this.tagManager);
                    long entriesLength = SVNHistoryPage.this.entries.length;
                    if (entriesLength > limit) {
                        ILogEntry[] fetchedEntries = new ILogEntry[SVNHistoryPage.this.entries.length - 1];
                        int i = 0;
                        while (i < SVNHistoryPage.this.entries.length - 1) {
                            fetchedEntries[i] = SVNHistoryPage.this.entries[i];
                            ++i;
                        }
                        SVNHistoryPage.this.entries = fetchedEntries;
                        SVNHistoryPage.this.getNextAction.setEnabled(true);
                    } else {
                        SVNHistoryPage.this.getNextAction.setEnabled(false);
                    }
                    SVNRevision.Number revisionId = this.remoteResource.getLastChangedRevision();
                    SVNHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this, revisionId){
                        final /* synthetic */ FetchLogEntriesJob this$1;
                        private final /* synthetic */ SVNRevision.Number val$revisionId;
                        {
                            this.this$1 = fetchLogEntriesJob;
                            this.val$revisionId = number;
                        }

                        public void run() {
                            if (FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).entries != null && FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).tableHistoryViewer != null && !FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).tableHistoryViewer.getTable().isDisposed()) {
                                if (FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).entries.length > 0) {
                                    FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).lastEntry = FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).entries[FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).entries.length - 1];
                                    long lastEntryNumber = FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).lastEntry.getRevision().getNumber();
                                    FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).revisionStart = new SVNRevision.Number(lastEntryNumber - 1L);
                                }
                                FetchLogEntriesJob.access$0((FetchLogEntriesJob)this.this$1).tableHistoryViewer.refresh();
                                FetchLogEntriesJob.access$0(this.this$1).selectRevision(this.val$revisionId);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
            catch (TeamException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ SVNHistoryPage access$0(FetchLogEntriesJob fetchLogEntriesJob) {
            return fetchLogEntriesJob.SVNHistoryPage.this;
        }
    }

    private class FetchNextLogEntriesJob
    extends AbstractFetchJob {
        public ISVNRemoteResource remoteResource;

        public FetchNextLogEntriesJob() {
            super(Policy.bind("HistoryView.fetchHistoryJob"));
        }

        public void setRemoteFile(ISVNRemoteResource resource) {
            this.remoteResource = resource;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this.remoteResource != null && !SVNHistoryPage.this.shutdown) {
                    int i;
                    SVNRevision pegRevision = this.remoteResource.getRevision();
                    SVNRevision.Number revisionEnd = new SVNRevision.Number(0L);
                    boolean stopOnCopy = SVNHistoryPage.this.toggleStopOnCopyAction.isChecked();
                    IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
                    int entriesToFetch = store.getInt("pref_log_entries_to_fetch");
                    long limit = entriesToFetch;
                    ILogEntry[] nextEntries = this.getLogEntries(monitor, this.remoteResource, pegRevision, SVNHistoryPage.this.revisionStart, (SVNRevision)revisionEnd, stopOnCopy, limit + 1L, SVNHistoryPage.this.tagManager);
                    long entriesLength = nextEntries.length;
                    ILogEntry[] fetchedEntries = null;
                    if (entriesLength > limit) {
                        fetchedEntries = new ILogEntry[nextEntries.length - 1];
                        i = 0;
                        while (i < nextEntries.length - 1) {
                            fetchedEntries[i] = nextEntries[i];
                            ++i;
                        }
                        SVNHistoryPage.this.getNextAction.setEnabled(true);
                    } else {
                        fetchedEntries = new ILogEntry[nextEntries.length];
                        i = 0;
                        while (i < nextEntries.length) {
                            fetchedEntries[i] = nextEntries[i];
                            ++i;
                        }
                        SVNHistoryPage.this.getNextAction.setEnabled(false);
                    }
                    ArrayList<ILogEntry> entryArray = new ArrayList<ILogEntry>();
                    if (SVNHistoryPage.this.entries == null) {
                        SVNHistoryPage.this.entries = new ILogEntry[0];
                    }
                    int i2 = 0;
                    while (i2 < SVNHistoryPage.this.entries.length) {
                        entryArray.add(SVNHistoryPage.this.entries[i2]);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < fetchedEntries.length) {
                        entryArray.add(fetchedEntries[i2]);
                        ++i2;
                    }
                    SVNHistoryPage.this.entries = new ILogEntry[entryArray.size()];
                    entryArray.toArray(SVNHistoryPage.this.entries);
                    SVNHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ FetchNextLogEntriesJob this$1;
                        {
                            this.this$1 = fetchNextLogEntriesJob;
                        }

                        public void run() {
                            if (FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).entries != null && FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).tableHistoryViewer != null && !FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).tableHistoryViewer.getTable().isDisposed()) {
                                ISelection selection = FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).tableHistoryViewer.getSelection();
                                FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).tableHistoryViewer.refresh();
                                FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).tableHistoryViewer.setSelection(selection);
                                if (FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).entries.length > 0) {
                                    FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).lastEntry = FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).entries[FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).entries.length - 1];
                                    long lastEntryNumber = FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).lastEntry.getRevision().getNumber();
                                    FetchNextLogEntriesJob.access$0((FetchNextLogEntriesJob)this.this$1).revisionStart = new SVNRevision.Number(lastEntryNumber - 1L);
                                }
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
            catch (TeamException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ SVNHistoryPage access$0(FetchNextLogEntriesJob fetchNextLogEntriesJob) {
            return fetchNextLogEntriesJob.SVNHistoryPage.this;
        }
    }

    private abstract class AbstractFetchJob
    extends Job {
        public AbstractFetchJob(String name) {
            super(name);
        }

        public abstract void setRemoteFile(ISVNRemoteResource var1);

        protected ILogEntry[] getLogEntries(IProgressMonitor monitor, ISVNRemoteResource remoteResource, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, long limit, AliasManager tagManager) throws TeamException {
            GetLogsCommand logCmd = new GetLogsCommand(remoteResource, pegRevision, revisionStart, revisionEnd, stopOnCopy, limit, tagManager);
            logCmd.run(monitor);
            return logCmd.getLogEntries();
        }
    }

    private class FetchAllLogEntriesJob
    extends AbstractFetchJob {
        public ISVNRemoteResource remoteResource;

        public FetchAllLogEntriesJob() {
            super(Policy.bind("HistoryView.fetchHistoryJob"));
        }

        public void setRemoteFile(ISVNRemoteResource resource) {
            this.remoteResource = resource;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this.remoteResource != null && !SVNHistoryPage.this.shutdown) {
                    SVNHistoryPage.this.tagManager = SVNHistoryPage.this.resource == null ? (this.remoteResource == null || !SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_tags_in_remote") ? null : new AliasManager(this.remoteResource.getUrl())) : new AliasManager(SVNHistoryPage.this.resource);
                    SVNRevision pegRevision = this.remoteResource.getRevision();
                    SVNHistoryPage.this.revisionStart = SVNRevision.HEAD;
                    SVNRevision.Number revisionEnd = new SVNRevision.Number(0L);
                    boolean stopOnCopy = SVNHistoryPage.this.toggleStopOnCopyAction.isChecked();
                    long limit = 0L;
                    SVNHistoryPage.this.entries = this.getLogEntries(monitor, this.remoteResource, pegRevision, SVNHistoryPage.this.revisionStart, (SVNRevision)revisionEnd, stopOnCopy, limit, SVNHistoryPage.this.tagManager);
                    SVNRevision.Number revisionId = this.remoteResource.getLastChangedRevision();
                    SVNHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this, revisionId){
                        final /* synthetic */ FetchAllLogEntriesJob this$1;
                        private final /* synthetic */ SVNRevision.Number val$revisionId;
                        {
                            this.this$1 = fetchAllLogEntriesJob;
                            this.val$revisionId = number;
                        }

                        public void run() {
                            if (FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).entries != null && FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).tableHistoryViewer != null && !FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).tableHistoryViewer.getTable().isDisposed()) {
                                if (FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).entries.length > 0) {
                                    FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).lastEntry = FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).entries[FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).entries.length - 1];
                                    long lastEntryNumber = FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).lastEntry.getRevision().getNumber();
                                    FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).revisionStart = new SVNRevision.Number(lastEntryNumber - 1L);
                                }
                                FetchAllLogEntriesJob.access$0((FetchAllLogEntriesJob)this.this$1).tableHistoryViewer.refresh();
                                FetchAllLogEntriesJob.access$0(this.this$1).selectRevision(this.val$revisionId);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
            catch (TeamException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ SVNHistoryPage access$0(FetchAllLogEntriesJob fetchAllLogEntriesJob) {
            return fetchAllLogEntriesJob.SVNHistoryPage.this;
        }
    }

    private class SearchHistoryJob
    extends Job {
        public SearchHistoryJob() {
            super(Policy.bind("HistoryView.searchHistoryJob"));
        }

        public IStatus run(IProgressMonitor monitor) {
            Date startDate = SVNHistoryPage.this.historySearchDialog.getStartDate();
            this.setEmptyViewerFilter();
            if (SVNHistoryPage.this.historySearchDialog.getAutoFetchLogs()) {
                if (!SVNHistoryPage.this.historySearchDialog.getSearchAllLogs()) {
                    Date lastDate = null;
                    if (SVNHistoryPage.this.lastEntry != null) {
                        lastDate = SVNHistoryPage.this.lastEntry.getDate();
                    }
                    int numEntries = SVNHistoryPage.this.entries.length;
                    int prevNumEntries = -1;
                    while (numEntries != prevNumEntries && (lastDate == null || startDate == null || startDate.compareTo(lastDate) <= 0)) {
                        if (monitor.isCanceled()) {
                            SVNHistoryPage.this.getSearchAction().setEnabled(true);
                            this.removeEmptyViewerFilter();
                            return Status.CANCEL_STATUS;
                        }
                        ISVNRemoteResource remoteResource = SVNHistoryPage.this.historyTableProvider.getRemoteResource();
                        if (SVNHistoryPage.this.fetchNextLogEntriesJob == null) {
                            SVNHistoryPage.this.fetchNextLogEntriesJob = new FetchNextLogEntriesJob();
                        }
                        if (SVNHistoryPage.this.fetchNextLogEntriesJob.getState() != 0) {
                            SVNHistoryPage.this.fetchNextLogEntriesJob.cancel();
                        }
                        SVNHistoryPage.this.fetchNextLogEntriesJob.setRemoteFile(remoteResource);
                        Utils.schedule(SVNHistoryPage.this.fetchNextLogEntriesJob, (IWorkbenchSite)SVNHistoryPage.this.getSite());
                        try {
                            SVNHistoryPage.this.fetchNextLogEntriesJob.join();
                        }
                        catch (InterruptedException e) {
                            SVNUIPlugin.log((TeamException)((Object)new SVNException(Policy.bind("HistoryView.errorFetchingEntries", remoteResource.getName()), (Throwable)e)));
                        }
                        if (SVNHistoryPage.this.entries.length != 0) {
                            lastDate = SVNHistoryPage.this.lastEntry.getDate();
                            prevNumEntries = numEntries;
                            numEntries = SVNHistoryPage.this.entries.length;
                            continue;
                        }
                        break;
                    }
                } else {
                    ISVNRemoteResource remoteResource = SVNHistoryPage.this.historyTableProvider.getRemoteResource();
                    if (SVNHistoryPage.this.fetchAllLogEntriesJob == null) {
                        SVNHistoryPage.this.fetchAllLogEntriesJob = new FetchAllLogEntriesJob();
                    }
                    if (SVNHistoryPage.this.fetchAllLogEntriesJob.getState() != 0) {
                        SVNHistoryPage.this.fetchAllLogEntriesJob.cancel();
                    }
                    SVNHistoryPage.this.fetchAllLogEntriesJob.setRemoteFile(remoteResource);
                    Utils.schedule(SVNHistoryPage.this.fetchAllLogEntriesJob, (IWorkbenchSite)SVNHistoryPage.this.getSite());
                }
            }
            HistorySearchViewerFilter viewerFilter = new HistorySearchViewerFilter(SVNHistoryPage.this.historySearchDialog.getUser(), SVNHistoryPage.this.historySearchDialog.getComment(), SVNHistoryPage.this.historySearchDialog.getStartDate(), SVNHistoryPage.this.historySearchDialog.getEndDate(), SVNHistoryPage.this.historySearchDialog.getRegExp());
            SVNHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this, viewerFilter){
                final /* synthetic */ SearchHistoryJob this$1;
                private final /* synthetic */ HistorySearchViewerFilter val$viewerFilter;
                {
                    this.this$1 = searchHistoryJob;
                    this.val$viewerFilter = historySearchViewerFilter;
                }

                public void run() {
                    BusyIndicator.showWhile((Display)SearchHistoryJob.access$0((SearchHistoryJob)this.this$1).tableHistoryViewer.getTable().getDisplay(), (Runnable)new Runnable(this, this.val$viewerFilter){
                        final /* synthetic */ 4 this$2;
                        private final /* synthetic */ HistorySearchViewerFilter val$viewerFilter;
                        {
                            this.this$2 = var1_1;
                            this.val$viewerFilter = historySearchViewerFilter;
                        }

                        public void run() {
                            SVNHistoryPage.access$4(SearchHistoryJob.access$0(4.access$0(this.this$2))).run();
                            SearchHistoryJob.access$0((SearchHistoryJob)4.access$0(this.this$2)).tableHistoryViewer.addFilter((ViewerFilter)this.val$viewerFilter);
                            SVNHistoryPage.access$4(SearchHistoryJob.access$0(4.access$0(this.this$2))).setEnabled(true);
                            SVNHistoryPage.access$3(SearchHistoryJob.access$0(4.access$0(this.this$2))).setEnabled(true);
                        }
                    });
                }

                static /* synthetic */ SearchHistoryJob access$0(4 var0) {
                    return var0.this$1;
                }
            });
            this.removeEmptyViewerFilter();
            return Status.OK_STATUS;
        }

        private void setEmptyViewerFilter() {
            SVNHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ SearchHistoryJob this$1;
                {
                    this.this$1 = searchHistoryJob;
                }

                public void run() {
                    SearchHistoryJob.access$0((SearchHistoryJob)this.this$1).tableHistoryViewer.addFilter((ViewerFilter)new EmptySearchViewerFilter());
                }
            });
        }

        private void removeEmptyViewerFilter() {
            SVNHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ SearchHistoryJob this$1;
                {
                    this.this$1 = searchHistoryJob;
                }

                public void run() {
                    ViewerFilter[] filters = SearchHistoryJob.access$0((SearchHistoryJob)this.this$1).tableHistoryViewer.getFilters();
                    int i = 0;
                    while (i < filters.length) {
                        if (filters[i] instanceof EmptySearchViewerFilter) {
                            SearchHistoryJob.access$0((SearchHistoryJob)this.this$1).tableHistoryViewer.removeFilter(filters[i]);
                        }
                        ++i;
                    }
                }
            });
        }

        static /* synthetic */ SVNHistoryPage access$0(SearchHistoryJob searchHistoryJob) {
            return searchHistoryJob.SVNHistoryPage.this;
        }
    }

    class FetchChangePathJob
    extends Job {
        public ILogEntry logEntry;

        public FetchChangePathJob() {
            super(Policy.bind("HistoryView.fetchChangePathJob"));
        }

        public void setLogEntry(ILogEntry logEntry) {
            this.logEntry = logEntry;
        }

        public IStatus run(IProgressMonitor monitor) {
            if (this.logEntry.getResource() != null) {
                SVNHistoryPage.this.setCurrentLogEntryChangePath(this.logEntry.getLogEntryChangePaths());
            }
            return Status.OK_STATUS;
        }
    }

    public static class ToggleAffectedPathsOptionAction
    extends Action {
        private final SVNHistoryPage page;
        private final String preferenceName;
        private final int value;

        public ToggleAffectedPathsOptionAction(SVNHistoryPage page, String label, String icon, String preferenceName, int value) {
            super(Policy.bind(label), 8);
            this.page = page;
            this.preferenceName = preferenceName;
            this.value = value;
            this.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor(icon));
            IPreferenceStore store = SVNUIPlugin.getPlugin().getPreferenceStore();
            this.setChecked(value == store.getInt(preferenceName));
        }

        public int getValue() {
            return this.value;
        }

        public void run() {
            if (this.isChecked()) {
                SVNUIPlugin.getPlugin().getPreferenceStore().setValue(this.preferenceName, this.value);
                this.page.createAffectedPathsViewer();
            }
        }
    }
}

