/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.formatter.CommentsTabPage;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.IndentationTabPage;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileManager;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RenameProfileDialog;

public class ModifyDialog
extends StatusDialog {
    private static final String DS_KEY_PREFERRED_WIDTH = "org.rubypeople.rdt.uiformatter_page.modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "org.rubypeople.rdt.uiformatter_page.modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "org.rubypeople.rdt.uiformatter_page.modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "org.rubypeople.rdt.uiformatter_page.modify_dialog.preferred_y";
    private static final String DS_KEY_LAST_FOCUS = "org.rubypeople.rdt.uiformatter_page.modify_dialog.last_focus";
    private final String fTitle;
    private final boolean fNewProfile;
    private ProfileManager.Profile fProfile;
    private final Map fWorkingValues;
    private IStatus fStandardStatus;
    protected final List fTabPages;
    final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private ProfileManager fProfileManager;
    private Button fApplyButton;

    protected ModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, boolean bl) {
        super(shell);
        this.fProfileManager = profileManager;
        this.fNewProfile = bl;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fProfile = profile;
        if (this.fProfile.isBuiltInProfile()) {
            this.fStandardStatus = new Status(1, RubyPlugin.getPluginId(), 0, FormatterMessages.ModifyDialog_dialog_show_warning_builtin, null);
            this.fTitle = Messages.format(FormatterMessages.ModifyDialog_dialog_show_title, profile.getName());
        } else {
            this.fStandardStatus = new Status(0, RubyPlugin.getPluginId(), 0, "", null);
            this.fTitle = Messages.format(FormatterMessages.ModifyDialog_dialog_title, profile.getName());
        }
        this.fWorkingValues = new HashMap(this.fProfile.getSettings());
        this.updateStatus(this.fStandardStatus);
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = RubyPlugin.getDefault().getDialogSettings();
    }

    public void create() {
        super.create();
        int n = 0;
        try {
            n = this.fDialogSettings.getInt(DS_KEY_LAST_FOCUS);
            if (n < 0) {
                n = 0;
            }
            if (n > this.fTabPages.size() - 1) {
                n = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (!this.fNewProfile) {
            this.fTabFolder.setSelection(n);
            ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.fTabFolder = new TabFolder(composite2, 0);
        this.fTabFolder.setFont(composite2.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_indentation_title, new IndentationTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.ModifyDialog_tabpage_comments_title, new CommentsTabPage(this, this.fWorkingValues));
        ModifyDialog.applyDialogFont((Control)composite2);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TabItem tabItem = (TabItem)selectionEvent.item;
                ModifyDialogTabPage modifyDialogTabPage = (ModifyDialogTabPage)tabItem.getData();
                ModifyDialog.this.fDialogSettings.put(ModifyDialog.DS_KEY_LAST_FOCUS, ModifyDialog.this.fTabPages.indexOf(modifyDialogTabPage));
                modifyDialogTabPage.makeVisible();
            }
        });
        return composite2;
    }

    public void updateStatus(IStatus iStatus) {
        super.updateStatus(iStatus != null ? iStatus : this.fStandardStatus);
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        try {
            int n;
            int n2 = this.fDialogSettings.getInt(DS_KEY_PREFERRED_WIDTH);
            if (point.x > n2) {
                n2 = point.x;
            }
            if (point.y > (n = this.fDialogSettings.getInt(DS_KEY_PREFERRED_HEIGHT))) {
                n = point.x;
            }
            return new Point(n2, n);
        }
        catch (NumberFormatException numberFormatException) {
            return point;
        }
    }

    protected Point getInitialLocation(Point point) {
        try {
            return new Point(this.fDialogSettings.getInt(DS_KEY_PREFERRED_X), this.fDialogSettings.getInt(DS_KEY_PREFERRED_Y));
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(point);
        }
    }

    public boolean close() {
        Rectangle rectangle = this.getShell().getBounds();
        this.fDialogSettings.put(DS_KEY_PREFERRED_WIDTH, rectangle.width);
        this.fDialogSettings.put(DS_KEY_PREFERRED_HEIGHT, rectangle.height);
        this.fDialogSettings.put(DS_KEY_PREFERRED_X, rectangle.x);
        this.fDialogSettings.put(DS_KEY_PREFERRED_Y, rectangle.y);
        return super.close();
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    protected void buttonPressed(int n) {
        if (n == 1024) {
            this.applyPressed();
        } else {
            super.buttonPressed(n);
        }
    }

    private void applyPressed() {
        if (this.fProfile.isBuiltInProfile() || this.fProfile.isSharedProfile()) {
            RenameProfileDialog renameProfileDialog = new RenameProfileDialog(this.getShell(), this.fProfile, this.fProfileManager);
            if (renameProfileDialog.open() != 0) {
                return;
            }
            this.fProfile = renameProfileDialog.getRenamedProfile();
            this.fStandardStatus = new Status(0, RubyPlugin.getPluginId(), 0, "", null);
            this.updateStatus(this.fStandardStatus);
        }
        this.fProfile.setSettings(new HashMap(this.fWorkingValues));
        this.fApplyButton.setEnabled(false);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fApplyButton = this.createButton(composite, 1024, FormatterMessages.ModifyDialog_apply_button, false);
        this.fApplyButton.setEnabled(false);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.widthHint = gridLayout.horizontalSpacing;
        label.setLayoutData((Object)gridData);
        super.createButtonsForButtonBar(composite);
    }

    private final void addTabPage(TabFolder tabFolder, String string, ModifyDialogTabPage modifyDialogTabPage) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        ModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(string);
        tabItem.setData((Object)modifyDialogTabPage);
        tabItem.setControl((Control)modifyDialogTabPage.createContents((Composite)tabFolder));
        this.fTabPages.add(modifyDialogTabPage);
    }

    public void valuesModified() {
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges());
        }
    }

    private boolean hasChanges() {
        Iterator iterator = this.fProfile.getSettings().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.fWorkingValues.get(entry.getKey()).equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

