'\"
'\" Generated from file '/usr/ports/obj/tcllib-1.11.1/tcllib-1.11.1/modules/report/report.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "report" n 0.3.1 report "Matrix reports"
.BS
.SH NAME
report \- Create and manipulate report objects
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBreport  ?0.3.1?\fR
.sp
\fB::report::report\fR \fIreportName\fR \fIcolumns\fR ?\fBstyle\fR \fIstyle arg...\fR?
.sp
\fBreportName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fB::report::defstyle\fR \fIstyleName arguments script\fR
.sp
\fB::report::rmstyle\fR \fIstyleName\fR
.sp
\fB::report::stylearguments\fR \fIstyleName\fR
.sp
\fB::report::stylebody\fR \fIstyleName\fR
.sp
\fB::report::styles\fR
.sp
\fIreportName\fR \fBdestroy\fR
.sp
\fIreportName\fR \fItemplatecode\fR \fBdisable\fR|\fBenable\fR
.sp
\fIreportName\fR \fItemplatecode\fR \fBenabled\fR
.sp
\fIreportName\fR \fItemplatecode\fR \fBget\fR
.sp
\fIreportName\fR \fItemplatecode\fR \fBset\fR \fItemplatedata\fR
.sp
\fIreportName\fR \fBtcaption\fR ?\fIsize\fR?
.sp
\fIreportName\fR \fBbcaption\fR \fIsize\fR
.sp
\fIreportName\fR \fBsize\fR \fIcolumn\fR ?\fInumber\fR|\fBdyn\fR?
.sp
\fIreportName\fR \fBsizes\fR ?\fIsize-list\fR?
.sp
\fIreportName\fR \fBpad\fR \fIcolumn\fR ?\fBleft\fR|\fBright\fR|\fBboth\fR ?\fIpadstring\fR??
.sp
\fIreportName\fR \fBjustify\fR \fIcolumn\fR ?\fBleft\fR|\fBright\fR|\fBcenter\fR?
.sp
\fIreportName\fR \fBprintmatrix\fR \fImatrix\fR
.sp
\fIreportName\fR \fBprintmatrix2channel\fR \fImatrix chan\fR
.sp
\fIreportName\fR \fBcolumns\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides report objects which can be used by the
formatting methods of matrix objects to generate tabular reports of
the matrix in various forms. The report objects defined here break
each report down into three \fBREGIONS\fR and ten classes of
\fIlines\fR (various separator- and data-lines). See the following
section for more detailed explanations.
.TP
\fB::report::report\fR \fIreportName\fR \fIcolumns\fR ?\fBstyle\fR \fIstyle arg...\fR?
Creates a new report object for a report having \fIcolumns\fR columns
with an associated global Tcl command whose name is
\fIreportName\fR. This command may be used to invoke various
configuration operations on the report. It has the following general
form:
.RS
.TP
\fBreportName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command. See section \fBREPORT METHODS\fR for more
explanations. If no \fBstyle\fR is specified the report will use
the builtin style \fBplain\fR as its default configuration.
.RE
.TP
\fB::report::defstyle\fR \fIstyleName arguments script\fR
Defines the new style \fIstyleName\fR. See section \fBSTYLES\fR
for more information.
.TP
\fB::report::rmstyle\fR \fIstyleName\fR
Deletes the style \fIstyleName\fR. Trying to delete an unknown or
builtin style will result in an error. Beware, this command will not
check that there are no other styles depending on the deleted
one. Deleting a style which is still used by another style FOO will
result in a runtime error when FOO is applied to a newly instantiated
report.
.TP
\fB::report::stylearguments\fR \fIstyleName\fR
This introspection command returns the list of arguments associated
with the style \fIstyleName\fR.
.TP
\fB::report::stylebody\fR \fIstyleName\fR
This introspection command returns the script associated with the
style \fIstyleName\fR.
.TP
\fB::report::styles\fR
This introspection command returns a list containing the names of all
styles known to the package at the time of the call. The order of the
names in the list reflects the order in which the styles were
created. In other words, the first item is the predefined style
\fBplain\fR, followed by the first style defined by the user, and
so on.
.PP
.SH REGIONS
.PP
The three regions are the \fItop caption\fR,
\fIdata area\fR and \fIbottom caption\fR. These are,
roughly speaking, the title, the values to report and a title at the
bottom. The size of the caption regions can be specified by the user
as the number of rows they occupy in the matrix to format. The size of
the data area is specified implicitly.
.SH LINES
.PP
\fBTEMPLATES\fR are associated with each of the ten line classes,
defining the formatting for this kind of line. The user is able to
enable and disable the separator lines at will, but not the data
lines. Their usage is solely determined by the number of rows
contained in the three regions. Data lines and all enabled separators
must have a template associated with them.
.PP
Note that the data-lines in a report and the rows in the matrix the
report was generated from are \fInot\fR in a 1:1 relationship if
any row in the matrix has a height greater than one.
.PP
The different kinds of lines and the codes used by the report methods
to address them are:
.TP
\fBtop\fR
The topmost line of a report. Separates the report from anything which
came before it. The user can enable the usage of this line at will.
.TP
\fBtopdatasep\fR
This line is used to separate the data rows in the top caption region,
if it contains more than one row and the user enabled its usage.
.TP
\fBtopcapsep\fR
This line is used to separate the top caption and data regions, if the
top caption is not empty and the user enabled its usage.
.TP
\fBdatasep\fR
This line is used to separate the data rows in the data region, if it
contains more than one row and the user enabled its usage.
.TP
\fBbotcapsep\fR
This line is used to separate the data and bottom caption regions, if
the bottom caption is not empty and the user enabled its usage.
.TP
\fBbotdatasep\fR
This line is used to separate the data rows in the bottom caption
region, if it contains more than one row and the user enabled its
usage.
.TP
\fBbottom\fR
The bottommost line of a report. Separates the report from anything
which comes after it. The user can enable the usage of this line at
will.
.TP
\fBtopdata\fR
This line defines the format of data lines in the top caption region
of the report.
.TP
\fBdata\fR
This line defines the format of data lines in the data region of the
report.
.TP
\fBbotdata\fR
This line defines the format of data lines in the bottom caption
region of the report.
.PP
.SH TEMPLATES
.PP
Each template is a list of strings used to format the line it is
associated with. For a report containing \fBn\fR columns a template
for a data line has to contain "\fBn\fR+1" items and a template for a
separator line "2*\fBn\fR+1" items.
.PP
The items in a data template specify the strings used to separate the
column information. Together with the corresponding items in the
separator templates they form the vertical lines in the report.
.PP
\fINote\fR that the corresponding items in all defined templates
have to be of equal length. This will be checked by the report
object. The first item defines the leftmost vertical line and the last
item defines the rightmost vertical line. The item at index \fBk\fR
("1",...,"\fBn\fR-2") separates the information in the columns
"\fBk\fR-1" and "\fBk\fR".
.PP
The items in a separator template having an even-numbered index
("0","2",...)  specify the column separators. The item at index
"2*\fBk\fR" ("0","2",...,"2*\fBn\fR") corresponds to the items at
index "\fBk\fR" in the data templates.
.PP
The items in a separator template having an odd-numbered index
("1","3",...) specify the strings used to form the horizontal lines in
the separator lines. The item at index "2*\fBk\fR+1"
("1","3",...,"2*\fBn\fR+1") corresponds to column "\fBk\fR". When
generating the horizontal lines the items are replicated to be at
least as long as the size of their column and then cut to the exact
size.
.SH STYLES
.PP
Styles are a way for the user of this package to define common
configurations for report objects and then use them later during the
actual instantiation of report objects. They are defined as tcl
scripts which when executed configure the report object into the
requested configuration.
.PP
The command to define styles is \fB::report::defstyle\fR. Its last
argument is the tcl \fBscript\fR performing the actual
reconfiguration of the report object to obtain the requested style.
.PP
In this script the names of all previously defined styles are
available as commands, as are all commands found in a safe interpreter
and the configuration methods of report objects. The latter implicitly
operate on the object currently executing the style script. The
\fBarguments\fR declared here are available in the \fBscript\fR as
variables. When calling the command of a previously declared style all
the arguments expected by it have to be defined in the call.
.SH "REPORT METHODS"
.PP
The following commands are possible for report objects:
.TP
\fIreportName\fR \fBdestroy\fR
Destroys the report, including its storage space and associated
command.
.TP
\fIreportName\fR \fItemplatecode\fR \fBdisable\fR|\fBenable\fR
Enables or disables the usage of the template addressed by the
\fItemplatecode\fR. Only the codes for separator lines are allowed
here. It is not possible to enable or disable data lines.
.sp
Enabling a template causes the report to check all used templates for
inconsistencies in the definition of the vertical lines (See section
\fBTEMPLATES\fR).
.TP
\fIreportName\fR \fItemplatecode\fR \fBenabled\fR
Returns the whether the template addressed by the \fItemplatecode\fR
is currently enabled or not.
.TP
\fIreportName\fR \fItemplatecode\fR \fBget\fR
Returns the template currently associated with the kind of line
addressed by the \fItemplatecode\fR. All known templatecodes are
allowed here.
.TP
\fIreportName\fR \fItemplatecode\fR \fBset\fR \fItemplatedata\fR
Sets the template associated with the kind of line addressed by the
\fItemplatecode\fR to the new value in \fItemplatedata\fR. See section
\fBTEMPLATES\fR for constraints on the length of templates.
.TP
\fIreportName\fR \fBtcaption\fR ?\fIsize\fR?
Specifies the \fIsize\fR of the top caption region as the number rows
it occupies in the matrix to be formatted. Only numbers greater than
or equal to zero are allowed. If no \fIsize\fR is specified the
command will return the current size instead.
.sp
Setting the size of the top caption to a value greater than zero
enables the corresponding data template and causes the report to check
all used templates for inconsistencies in the definition of the
vertical lines (See section \fBTEMPLATES\fR).
.TP
\fIreportName\fR \fBbcaption\fR \fIsize\fR
Specifies the \fIsize\fR of the bottom caption region as the number
rows it occupies in the matrix to be formatted. Only numbers greater
than or equal to zero are allowed. If no \fIsize\fR is specified the
command will return the current size instead.
.sp
Setting the size of the bottom caption to a value greater than zero
enables the corresponding data template and causes the report to check
all used templates for inconsistencies in the definition of the
vertical lines (See section \fBTEMPLATES\fR).
.TP
\fIreportName\fR \fBsize\fR \fIcolumn\fR ?\fInumber\fR|\fBdyn\fR?
Specifies the size of the \fIcolumn\fR in the output. The value
\fBdyn\fR means that the columnwidth returned by the matrix to be
formatted for the specified column shall be used. The formatting of
the column is dynamic. If a fixed \fInumber\fR is used instead of
\fBdyn\fR it means that the column has a width of that many
characters (padding excluded). Only numbers greater than zero are
allowed here.
.sp
If no size specification is given the command will return the current
size of the \fIcolumn\fR instead.
.TP
\fIreportName\fR \fBsizes\fR ?\fIsize-list\fR?
This method allows the user to specify the sizes of all columns in one
call. Its argument is a list containing the sizes to associate with
the columns. The first item is associated with column 0, the next with
column 1, and so on.
.sp
If no \fIsize-list\fR is specified the command will return a list
containing the currently set sizes instead.
.TP
\fIreportName\fR \fBpad\fR \fIcolumn\fR ?\fBleft\fR|\fBright\fR|\fBboth\fR ?\fIpadstring\fR??
This method allows the user to specify padding on the left, right or
both sides of a \fIcolumn\fR. If the \fIpadstring\fR is not specified
it defaults to a single space character. \fINote\fR: An alternative
way of specifying the padding is to use vertical separator strings
longer than one character in the templates (See section
\fBTEMPLATES\fR).
.sp
If no pad specification is given at all the command will return the
current state of padding for the column instead. This will be a list
containing two elements, the first element the left padding, the
second describing the right padding.
.TP
\fIreportName\fR \fBjustify\fR \fIcolumn\fR ?\fBleft\fR|\fBright\fR|\fBcenter\fR?
Declares how the cell values for a \fIcolumn\fR are filled into the
report given the specified size of a column in the report.
.sp
For \fBleft\fR and \fBright\fR justification a cell value
shorter than the width of the column is bound with its named edge to
the same edge of the column. The other side is filled with spaces. In
the case of \fBcenter\fR the spaces are placed to both sides of the
value and the left number of spaces is at most one higher than the
right number of spaces.
.sp
For a value longer than the width of the column the value is cut at
the named edge. This means for \fBleft\fR justification that the
\fItail\fR (i.e. the \fBright\fR part) of the value is made
visible in the output. For \fBcenter\fR the value is cut at both
sides to fit into the column and the number of characters cut at the
left side of the value is at most one less than the number of
characters cut from the right side.
.sp
If no justification was specified the command will return the current
justification for the column instead.
.TP
\fIreportName\fR \fBprintmatrix\fR \fImatrix\fR
Formats the \fImatrix\fR according to the configuration of the report
and returns the resulting string. The matrix has to have the same
number of columns as the report. The matrix also has to have enough
rows so that the top and bottom caption regions do not overlap. The
data region is allowed to be empty.
.TP
\fIreportName\fR \fBprintmatrix2channel\fR \fImatrix chan\fR
Formats the \fImatrix\fR according to the configuration of the report
and writes the result into the channel \fIchan\fR. The matrix has to
have the same number of columns as the report. The matrix also has to
have enough rows so that the top and bottom caption regions do not
overlap. The data region is allowed to be empty.
.TP
\fIreportName\fR \fBcolumns\fR
Returns the number of columns in the report.
.PP
.PP
The methods \fBsize\fR, \fBpad\fR and \fBjustify\fR all take
a column index as their first argument. This index is allowed to use
all the forms of an index as accepted by the \fBlindex\fR command. The
allowed range for indices is
"0,...,[\fBreportName\fR columns]-1".
.SH EXAMPLES
.PP
Our examples define some generally useful report styles.
.PP
A simple table with lines surrounding all information and vertical
separators, but without internal horizontal separators.
.PP
.nf

    ::report::defstyle simpletable {} {
	data	set [split "[string repeat "| "   [columns]]|"]
	top	set [split "[string repeat "+ - " [columns]]+"]
	bottom	set [top get]
	top	enable
	bottom	enable
    }

.fi
.PP
An extension of a \fBsimpletable\fR, see above, with a title area.
.PP
.nf

    ::report::defstyle captionedtable {{n 1}} {
	simpletable
	topdata   set [data get]
	topcapsep set [top get]
	topcapsep enable
	tcaption $n
    }

.fi
.PP
Given the definitions above now an example which actually formats a
matrix into a tabular report. It assumes that the matrix actually
contains useful data.
.PP
.nf

    % ::struct::matrix m
    % # ... fill m with data, assume 5 columns
    % ::report::report r 5 style captionedtable 1
    % r printmatrix m
    +---+-------------------+-------+-------+--------+
    |000|VERSIONS:          |2:8.4a3|1:8.4a3|1:8.4a3%|
    +---+-------------------+-------+-------+--------+
    |001|CATCH return ok    |7      |13     |53.85   |
    |002|CATCH return error |68     |91     |74.73   |
    |003|CATCH no catch used|7      |14     |50.00   |
    |004|IF if true numeric |12     |33     |36.36   |
    |005|IF elseif          |15     |47     |31.91   |
    |   |true numeric       |       |       |        |
    +---+-------------------+-------+-------+--------+
    %
    % # alternate way of doing the above
    % m format 2string r

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIreport\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
matrix, report, table
.SH COPYRIGHT
.nf
Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi