<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:strip-space elements="*"/>

<!-- Parameterizations -->

<xsl:variable name="PageMarginTop">75pt</xsl:variable>
<xsl:variable name="PageMarginBottom">125pt</xsl:variable>
<xsl:variable name="PageMarginLeft">80pt</xsl:variable>
<xsl:variable name="PageMarginRight">150pt</xsl:variable>
<xsl:variable name="BodyFont">Times-Roman</xsl:variable>
<xsl:variable name="BodySize">12pt</xsl:variable>
<xsl:variable name="TypeWriterFont">Computer-Modern-Typewriter</xsl:variable>
<xsl:variable name="SansFont">Helvetica</xsl:variable>
<xsl:variable name="ListRightMargin">12pt</xsl:variable>
<xsl:variable name="ListAbove">12pt</xsl:variable>
<xsl:variable name="ListBelow">12pt</xsl:variable>
<xsl:variable name="ListNormalIndent">15pt</xsl:variable>
<xsl:variable name="BulletOne">&#x2022;</xsl:variable>

<xsl:template name="listitem">
  <xsl:param name="labeltext">labeltext</xsl:param>
  <xsl:param name="itemid">itemid</xsl:param>
  <xsl:param name="itemtext">itemtext</xsl:param>
  <fo:list-item id="{$itemid}">
    <fo:list-item-label font-style="italic">
      <fo:block>
        <xsl:value-of select="$labeltext"/>
        <xsl:text>:</xsl:text>
      </fo:block>
    </fo:list-item-label>
    <fo:list-item-body>
      <fo:block><xsl:value-of select="$itemtext"/></fo:block>
    </fo:list-item-body>
  </fo:list-item>
</xsl:template>

<xsl:template match='/'>
  <fo:root>
    <fo:layout-master-set>
      <fo:simple-page-master
        page-master-name="allpages"
        margin-top="{$PageMarginTop}"
        margin-bottom="{$PageMarginBottom}"
        margin-left="{$PageMarginLeft}"
        margin-right="{$PageMarginRight}">
        <fo:region-body margin-bottom="100pt"/>
        <fo:region-after extent="25pt"/>
      </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence>
        <fo:sequence-specification>
          <fo:sequence-specifier-repeating
            page-master-first="allpages"
            page-master-repeating="allpages"/>
        </fo:sequence-specification>
        <fo:flow font-family="serif">
          <xsl:apply-templates/>
        </fo:flow>
      </fo:page-sequence>
  </fo:root>
</xsl:template>

<xsl:template match="invitation/front">
<fo:block font-family="sans-serif"  font-size="24pt"
          font-weight="bold"        text-align-last="centered"
          space-after.optimum="24pt">
  <xsl:text>INVITATION</xsl:text>
</fo:block>

<fo:list-block provisional-distance-between-starts="2cm"
               provisional-label-separation="6pt">
  <xsl:call-template name="listitem">
    <xsl:with-param name="labeltext">To</xsl:with-param>
    <xsl:with-param name="itemid">listto</xsl:with-param>
    <xsl:with-param name="itemtext"><xsl:value-of select="to"/></xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="listitem">
    <xsl:with-param name="labeltext">When</xsl:with-param>
    <xsl:with-param name="itemid">listdate</xsl:with-param>
    <xsl:with-param name="itemtext"><xsl:value-of select="date"/></xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="listitem">
    <xsl:with-param name="labeltext">Venue</xsl:with-param>
    <xsl:with-param name="itemid">listwhere</xsl:with-param>
    <xsl:with-param name="itemtext" select="where"/>
  </xsl:call-template>
  <xsl:call-template name="listitem">
    <xsl:with-param name="labeltext">Occasion</xsl:with-param>
    <xsl:with-param name="itemid">listwhy</xsl:with-param>
    <xsl:with-param name="itemtext"><xsl:value-of select="why"/></xsl:with-param>
  </xsl:call-template>
</fo:list-block>
</xsl:template>

<xsl:template match="invitation/body/par">
  <fo:block space-before.optimum="{$BodySize}">
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="invitation/body/par/emph">
  <fo:inline-sequence font-style="italic">
    <xsl:apply-templates/>
  </fo:inline-sequence>
</xsl:template>

<xsl:template match="invitation/back">
<fo:block space-before.optimum="{$BodySize}"
          font-weight="bold" text-align-last="end">
   <xsl:text>From: </xsl:text>
   <xsl:value-of select="signature"/>
</fo:block>
</xsl:template>

</xsl:stylesheet>
