<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
	/**
	 * Contact ItemModule
	 * Module which openes, creates, saves and deletes an item. It 
	 * extends the Module class.
	 */
	class ContactItemModule extends ItemModule
	{

		var $plaintext;

		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function ContactItemModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getContactProperties();
			
			$this->plaintext = true;

			parent::ItemModule($id, $data);
		}
		
		/**
		 * Function which saves an item. It sets the right properties for a contact
		 * item (address book properties).		 
		 * @param object $store MAPI Message Store Object
		 * @param string $parententryid parent entryid of the message
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */		 		
		function save($store, $parententryid, $action)
		{
			$result = false;
			$properiesToDelete = array();		// create an array of properties which should be deleted 
												// this array is passed to $GLOBALS["operations"]->saveMessage() function
			
			if(!$store && !$parententryid) {
				if(isset($action["props"]["message_class"])) {
					$store = $GLOBALS["mapisession"]->getDefaultMessageStore();
					$parententryid = $this->getDefaultFolderEntryID($store, $action["props"]["message_class"]);
				}
			}

            $action["props"]["subject"] = $action["props"]["fileas"];

			if($store && $parententryid) {
				/*	type of email address		address_book_mv			address_book_long
				 *	email1						0						1 (0x00000001)
				 *	email2						1						2 (0x00000002)
				 *	email3						2						4 (0x00000004)
				 *	fax2(business fax)			3						8 (0x00000008)
				 *	fax3(home fax)				4						16 (0x00000010)
				 *	fax1(primary fax)			5						32 (0x00000020)
				 *
				 *	address_book_mv is a multivalued property so all the values are passed in array
				 *	address_book_long stores sum of the flags
				 *	these both properties should be in sync always
				 */
				$action["props"]["address_book_mv"] = array();
				$action["props"]["address_book_long"] =  0;

				if(isset($action["props"]) && isset($action["email_addresses"]) && isset($action["email_addresses"]["email_address"])) {
					foreach($action["email_addresses"]["email_address"] as $email_address)
					{
						// if emailaddress of name is "0" then it will be ignored (non-issue)
						if(isset($email_address["id"]) && !empty($email_address["name"]) && !empty($email_address["address"])) {
							$action["props"]["email_address_entryid_" . $email_address["id"]] = bin2hex(mapi_createoneoff($email_address["name"], "SMTP", $email_address["address"]));
							
							switch((int)$email_address["id"]){
								case 1:
									$action["props"]["address_book_long"] += 1;
									array_push($action["props"]["address_book_mv"], 0);
									break;
								case 2:
									$action["props"]["address_book_long"] += 2;
									array_push($action["props"]["address_book_mv"], 1);
									break;
								case 3:
									$action["props"]["address_book_long"] += 4;
									array_push($action["props"]["address_book_mv"], 2);
									break;
							}

							$action["props"]["email_address_type_".(int)$email_address["id"]] = "SMTP";
							$action["props"]["email_address_display_name_email_".(int)$email_address["id"]] = $email_address["address"];
						}
					}

					// set properties for primary fax number
					if(isset($action['props']['primary_fax_number']) && !empty($action['props']['primary_fax_number'])) {
						$action['props']['fax_1_address_type'] = 'FAX';
						$action['props']['fax_1_original_display_name'] = $action["props"]["subject"]; // same as PR_NORMALIZED_SUBJECT
						$action['props']['fax_1_email_address'] = $action['props']['fax_1_original_display_name'] . '@' . $action['props']['primary_fax_number'];
						$action['props']['fax_1_original_entryid'] = bin2hex(mapi_createoneoff($action['props']['fax_1_original_display_name'], $action['props']['fax_1_address_type'], $action['props']['fax_1_email_address'], MAPI_UNICODE));

						$action["props"]["address_book_long"] += 32;
						array_push($action["props"]["address_book_mv"], 5);
					} else {
						// delete properties to remove previous values
						$properiesToDelete[] = $this->properties['fax_1_address_type'];
						$properiesToDelete[] = $this->properties['fax_1_original_display_name'];
						$properiesToDelete[] = $this->properties['fax_1_email_address'];
						$properiesToDelete[] = $this->properties['fax_1_original_entryid'];
					}

					// set properties for business fax number
					if(isset($action['props']['business_fax_number']) && !empty($action['props']['business_fax_number'])) {
						$action['props']['fax_2_address_type'] = 'FAX';
						$action['props']['fax_2_original_display_name'] = $action["props"]["subject"]; // same as PR_NORMALIZED_SUBJECT
						$action['props']['fax_2_email_address'] = $action['props']['fax_2_original_display_name'] . '@' . $action['props']['business_fax_number'];
						$action['props']['fax_2_original_entryid'] = bin2hex(mapi_createoneoff($action['props']['fax_2_original_display_name'], $action['props']['fax_2_address_type'], $action['props']['fax_2_email_address'], MAPI_UNICODE));

						$action["props"]["address_book_long"] += 8;
						array_push($action["props"]["address_book_mv"], 3);
					} else {
						$properiesToDelete[] = $this->properties['fax_2_address_type'];
						$properiesToDelete[] = $this->properties['fax_2_original_display_name'];
						$properiesToDelete[] = $this->properties['fax_2_email_address'];
						$properiesToDelete[] = $this->properties['fax_2_original_entryid'];
					}

					// set properties for home fax number
					if(isset($action['props']['home_fax_number']) && !empty($action['props']['home_fax_number'])) {
						$action['props']['fax_3_address_type'] = 'FAX';
						$action['props']['fax_3_original_display_name'] = $action["props"]["subject"]; // same as PR_NORMALIZED_SUBJECT
						$action['props']['fax_3_email_address'] = $action['props']['fax_3_original_display_name'] . '@' . $action['props']['home_fax_number'];
						$action['props']['fax_3_original_entryid'] = bin2hex(mapi_createoneoff($action['props']['fax_3_original_display_name'], $action['props']['fax_3_address_type'], $action['props']['fax_3_email_address'], MAPI_UNICODE));

						$action["props"]["address_book_long"] += 16;
						array_push($action["props"]["address_book_mv"], 4);
					} else {
						$properiesToDelete[] = $this->properties['fax_3_address_type'];
						$properiesToDelete[] = $this->properties['fax_3_original_display_name'];
						$properiesToDelete[] = $this->properties['fax_3_email_address'];
						$properiesToDelete[] = $this->properties['fax_3_original_entryid'];
					}

					sort($action["props"]["address_book_mv"]);

					// check for properties which should be deleted
					if(isset($action["props"]["entryid"]) && !empty($action["props"]["entryid"])) {
						// check for empty email address properties
						for($i = 1; $i < 4; $i++)
						{
							if(!isset($action["props"]["email_address_entryid_" . $i])) {
								array_push($properiesToDelete, $this->properties["email_address_entryid_" . $i]);
								array_push($properiesToDelete, $this->properties["email_address_" . $i]);
								array_push($properiesToDelete, $this->properties["email_address_display_name_" . $i]);
								array_push($properiesToDelete, $this->properties["email_address_display_name_email_" . $i]);
								array_push($properiesToDelete, $this->properties["email_address_type_" . $i]);
							}
						}

						// check for empty address_book_mv and address_book_long properties
						if($action["props"]["address_book_long"] == 0) {
							$properiesToDelete[] = $this->properties['address_book_mv'];
							$properiesToDelete[] = $this->properties['address_book_long'];
						}

						// Check if the birthday and anniversary properties are empty. If so delete them.
						if($action['props']['birthday'] == ""){
							array_push($properiesToDelete, $this->properties['birthday']);
						}
						if($action['props']['wedding_anniversary'] == ""){
							array_push($properiesToDelete, $this->properties['wedding_anniversary']);
						}
					}

					/** 
					 * convert all line endings(LF) into CRLF
					 * XML parser will normalize all CR, LF and CRLF into LF
					 * but outlook(windows) uses CRLF as line ending
					 */
					if(isset($action["props"]["business_address"])) {
						$action["props"]["business_address"] = str_replace("\n", "\r\n", $action["props"]["business_address"]);
					}

					if(isset($action["props"]["home_address"])) {
						$action["props"]["home_address"] = str_replace("\n", "\r\n", $action["props"]["home_address"]);
					}

					if(isset($action["props"]["other_address"])) {
						$action["props"]["other_address"] = str_replace("\n", "\r\n", $action["props"]["other_address"]);
					}

					/**
					 * check if webpage property is set if it is set then 
					 * also set PR_BUSINESS_HOME_PAGE property
					 */
					if(isset($action["props"]["webpage"])) {
						$action["props"]["business_home_page"] = $action["props"]["webpage"];
					}

					$messageProps = array();
					$result = $GLOBALS["operations"]->saveMessage($store, $parententryid, Conversion::mapXML2MAPI($this->properties, $action["props"]), false, $action["dialog_attachments"], $messageProps, false, false, $properiesToDelete);
	
					if($result) {
						$GLOBALS["bus"]->notify(bin2hex($parententryid), TABLE_SAVE, $messageProps);
					}
				}
			}
			
			return $result;
		}
	}
?>
