/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
* Generates Print Preview for Mail items
*/
function printMessageItem()
{
}

/**
* this function does all the creating stuff
*
*@param object moduleObject The PrintItemModule object
*@param	window frame The iframe window object where to write the print preview to.
*/
printMessageItem.prototype.init = function(moduleObject, frame)
{
	// initialize data
	this.frame = frame;
	this.module = moduleObject;
	this.props = this.module.propData;
	this.doc = this.frame.document;

	this.createHTML();
}

printMessageItem.prototype.createHTML = function()
{
	// set content/type
	this.doc.open("text/html");
	
	// write header
	this.doc.writeln('<html>');
	this.doc.writeln('	<head>');
	this.doc.writeln('		<title>Zarafa WebAccess - '+webclient.fullname+'</title>');
	this.doc.writeln('	</head>');

	// begin body
	this.doc.writeln('	<body>');
	this.doc.writeln('		<h1 style="font-family: sans-serif; font-size: 12pt;border-bottom: 3px solid #000;">'+webclient.fullname+'</h1>');

	// write mail properties (from/to/cc/subject etc)
	this.doc.writeln('		<table cellspacing=0 cellpadding=0 style="font-family: sans-serif; font-size: 10pt">');
	this.writeLine(_("From"),"sent_representing_name");
	this.writeLine(_("Sent"),"message_delivery_time");
	this.writeLine(_("To"),"display_to");
	this.writeLine(_("CC"),"display_cc");
	this.writeLine(_("Subject"),"subject");
	this.writeLine(_("Creation Time"),"creation_time","IPM.StickyNote");
	this.writeLine(_("Modified"),"last_modification_time");
	
	this.writeLine(_("Location"),"location");//appointment
	this.writeLine(_("Start Date"),"startdate");//appointment, task
	this.writeLine(_("End Date"),"duedate");//appointment, task
	this.writeLine(_("Recurrence Pattern"),"RecurrencePattern");//appointment
	
	//task
	this.writeLine("","","IPM.Task");
	if(this.props["status"]){
		switch(this.props["status"]){
			case "1":
				this.props["status"] = _("In Progress");
				break;
			case "2":
				this.props["status"] = _("Complete");
				break;
			case "3":
				this.props["status"] = _("Wait for other person");
				break;
			case "4":
				this.props["status"] = _("Deferred");
				break;
		}
		this.writeLine(_("Status"),"status");
	}
	if(this.props["percent_complete"]){
		this.props["percent_complete"] = (this.props["percent_complete"]*100)+'%';
		this.writeLine(_("Percent Complete"),"percent_complete");
		this.writeLine(_("Date completed"),"datecompleted");
	}
	this.writeLine("","","IPM.Task");
	if(this.props["totalwork"]){
		this.props["totalwork"] = Math.round(this.props["totalwork"]/6)/10+' '+_("hours");
		this.writeLine(_("Total Work"),"totalwork");
	}
	if(this.props["actualwork"]){
		this.props["actualwork"] = Math.round(this.props["actualwork"]/6)/10+' '+_("hours");
		this.writeLine(_("Actual Work"),"actualwork");
	}
	this.writeLine("","","IPM.Task");
	this.writeLine(_("Owner"),"owner");
	this.writeLine("","","IPM.Task");
	
	this.writeLine(_("Contacts"),"contacts_string");
	this.writeLine("","","IPM.Task");
	
	//contacts
	this.writeLine(_("Full Name"),"display_name");
	this.writeLine(_("Last Name"),"surname");
	this.writeLine(_("First Name"),"given_name");
	this.writeLine(_("Middle Name"),"middle_name");
	this.writeLine(_("Job Title"),"title");
	this.writeLine("","","IPM.Contact");
	this.writeLine(_("Mobile"),"cellular_telephone_number");
	this.writeLine(_("IM Address"),"im");
	this.writeLine("","","IPM.Contact");
	this.writeLine(_("Company"),"company_name");
	this.writeLine(_("Business Address"),"business_address");
	this.writeLine(_("Business")+" "+_("Phone"),"office_telephone_number");
	this.writeLine(_("Business Fax"),"business_fax_number");
	this.writeLine(_("Home address"),"home_address");
	this.writeLine(_("Home")+" "+_("Phone"),"home_telephone_number");
	this.writeLine("","","IPM.Contact");
	this.writeLine(_("E-mail"),"email_address_1");
	this.writeLine(_("Display Name"),"email_address_display_name_1");
	this.writeLine(_("E-mail")+"(2)","email_address_2");
	this.writeLine(_("Display Name"),"email_address_display_name_2");
	this.writeLine(_("E-mail")+"(3)","email_address_3");
	this.writeLine(_("Display Name"),"email_address_display_name_3");
	this.writeLine(_("Web Page"),"webpage");
		
	this.writeLine(_("Categories"),"categories");
	this.writeLine(_("Company"), "companies");
	this.writeLine(_("Billing information"), "billinginformation");
	this.writeLine(_("Mileage"), "mileage");

	// Recurrence type
	this.writeLine(_("Recurrence Type"), "recurrencetype");

	// Recurrence pattern
	this.writeLine(_("Recurrence Pattern"), "recurring_pattern");

	this.writeLine(_("Attachments"), "attachments");

	// write member list
	this.writeLine("", "", "IPM.DistList");
	this.writeMembers("IPM.DistList");

	this.doc.writeln('		</table>');
	this.doc.writeln('		<br>');

	// write mail
	this.writeBody();

	// write footer
	this.doc.writeln('	</body>');
	this.doc.writeln('</html>');

	this.doc.close();
}

/*
* This function makes sure that the body of the mail is written correctly. 
* In Firefox for example there are multiple textnodes that holds the 
* message, so get them all.
*/
printMessageItem.prototype.writeBody = function()
{
	var body = this.props["body"];
	
	if(body && body.childNodes.length > 0) {
		var content = "";
		var element = body.firstChild;
		for(var i = 0; i < body.childNodes.length; i++)
		{
			content += element.nodeValue;
			element = element.nextSibling;
		}

		if (!this.props["isHTML"] || this.props["isHTML"]=="0"){
			content = convertPlainToHtml(content);
			content = "<pre style=\"white-space: -moz-pre-wrap; word-wrap: break-word;\">" + content + "</pre>";
		}

		this.doc.write(content);
	}
}

printMessageItem.prototype.writeLine = function(label, field, msgClass)
{
	if (this.props[field] && (!msgClass || msgClass == this.props["message_class"])){		
		this.doc.writeln('			<tr><th align="left" width=160px>'+label+':</th><td style="padding-left: 10px">'+this.props[field].replace(/</g,"&lt;").replace(/>/g,"&gt;")+'</td></tr>');
	}
	if(label == "" && field == "" && msgClass == this.props["message_class"]){
		this.doc.writeln('			<tr><th align="left">'+NBSP+'</th><td style="padding-left: 10px">'+NBSP+'</td></tr>');
	}
}

printMessageItem.prototype.writeMembers = function(msgClass) {
	var members = this.props["members"];
	var name, address, missing;

	if(this.props["message_class"] == msgClass) {
		this.doc.writeln('<tr><th align="left">'+ _("Members") +':</th></tr>');

		if(members && members.childNodes) {
			for(var i=0; i < members.childNodes.length; i++) {
				if(members && members.firstChild) {
					var member = members.childNodes[i];

					if(member.tagName == "member") {
						name = member.getElementsByTagName("name")[0].firstChild.nodeValue;
						address = member.getElementsByTagName("address")[0].firstChild.nodeValue;
						missing = member.getElementsByTagName("missing")[0] ? member.getElementsByTagName("missing")[0].firstChild.nodeValue : 0;

						if(missing != 1) {
							this.doc.writeln('<tr><td align="left">' + name + '</td><td style="padding-left: 10px">' + address + '</td></tr>');
						}
					}
				}
			}
		}
	}
}