/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.util;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.util.ValueArray;
import com.sun.xml.fastinfoset.util.ValueArrayResourceException;

public class StringArray
extends ValueArray {
    public String[] _array;
    private StringArray _readOnlyArray;

    public StringArray() {
        this(10, Integer.MAX_VALUE);
    }

    public final void clear() {
        int i = this._readOnlyArraySize;
        while (i < this._size) {
            this._array[i] = null;
            ++i;
        }
        this._size = this._readOnlyArraySize;
    }

    protected final void resize() {
        if (this._size == this._maximumCapacity) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.arrayMaxCapacity"));
        }
        int newSize = this._size * 3 / 2 + 1;
        if (newSize > this._maximumCapacity) {
            newSize = this._maximumCapacity;
        }
        String[] newArray = new String[newSize];
        System.arraycopy(this._array, 0, newArray, 0, this._size);
        this._array = newArray;
    }

    public StringArray(int initialCapacity, int maximumCapacity) {
        this._array = new String[initialCapacity];
        this._maximumCapacity = maximumCapacity;
    }

    public final void setReadOnlyArray(StringArray readOnlyArray, boolean clear) {
        if (readOnlyArray != null) {
            this._readOnlyArray = readOnlyArray;
            this._readOnlyArraySize = readOnlyArray.getSize();
            if (clear) {
                this.clear();
            }
            this._array = this.getCompleteArray();
            this._size = this._readOnlyArraySize;
        }
    }

    public final void setReadOnlyArray(ValueArray readOnlyArray, boolean clear) {
        if (!(readOnlyArray instanceof StringArray)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{readOnlyArray}));
        }
        this.setReadOnlyArray((StringArray)readOnlyArray, clear);
    }

    public final String[] getArray() {
        return this._array;
    }

    public final String[] getCompleteArray() {
        if (this._readOnlyArray == null) {
            return this._array;
        }
        String[] ra = this._readOnlyArray.getCompleteArray();
        String[] a = new String[this._readOnlyArraySize + this._array.length];
        System.arraycopy(ra, 0, a, 0, this._readOnlyArraySize);
        return a;
    }

    public final String get(int i) {
        return this._array[i];
    }

    public final int add(String s) {
        if (this._size == this._array.length) {
            this.resize();
        }
        this._array[this._size++] = s;
        return this._size;
    }
}

