/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class MaximizeWindowAction
extends AbstractAction {
    private final PropertyChangeListener propListener;
    private TopComponent topComponent;
    private boolean isPopup;
    private static boolean isFirstActivated = true;

    public MaximizeWindowAction() {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("maximizedMode".equals(propName) || "editorAreaState".equals(evt.getPropertyName()) || "activeMode".equals(evt.getPropertyName())) {
                    MaximizeWindowAction.this.updateState();
                }
                if (isFirstActivated && "activated".equals(propName)) {
                    isFirstActivated = false;
                    MaximizeWindowAction.this.updateState();
                }
            }
        };
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        wm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)wm)));
        this.updateState();
    }

    MaximizeWindowAction(TopComponent tc) {
        this.topComponent = tc;
        this.propListener = null;
        this.isPopup = true;
        this.updateState();
    }

    public void actionPerformed(ActionEvent ev) {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (wm.getEditorAreaState() == 0) {
            if (this.topComponent != null) {
                ModeImpl mode = MaximizeWindowAction.getModeToMaximize(this.topComponent);
                if (mode == null || mode.getKind() != 2) {
                    wm.setMaximizedMode(mode);
                }
            } else {
                ModeImpl activeMode = wm.getActiveMode();
                ModeImpl mode = wm.getMaximizedMode();
                if (activeMode != null && activeMode.getKind() != 2) {
                    if (mode != null) {
                        wm.setMaximizedMode(null);
                    } else {
                        wm.setMaximizedMode(activeMode);
                    }
                }
            }
        } else {
            ModeImpl activeMode = this.topComponent != null ? (ModeImpl)wm.findMode(this.topComponent) : wm.getActiveMode();
            if (activeMode != null) {
                if (activeMode.getKind() == 1) {
                    if (wm.getEditorAreaFrameState() == 0) {
                        wm.setEditorAreaFrameState(6);
                    } else {
                        wm.setEditorAreaFrameState(0);
                    }
                } else if (activeMode.getKind() == 0) {
                    if (activeMode.getFrameState() == 0) {
                        activeMode.setFrameState(6);
                    } else {
                        activeMode.setFrameState(0);
                    }
                }
            }
        }
        this.updateState();
    }

    private void updateState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MaximizeWindowAction.this.doUpdateState();
                }
            });
        }
    }

    private void doUpdateState() {
        boolean maximize;
        TopComponent active = null;
        active = this.topComponent != null ? this.topComponent : TopComponent.getRegistry().getActivated();
        String param = active == null ? "" : active.getName();
        ModeImpl activeMode = (ModeImpl)WindowManagerImpl.getInstance().findMode(active);
        if (WindowManagerImpl.getInstance().getEditorAreaState() == 0) {
            maximize = WindowManagerImpl.getInstance().getMaximizedMode() == null;
        } else if (activeMode != null) {
            maximize = activeMode.getKind() == 1 ? WindowManagerImpl.getInstance().getEditorAreaFrameState() == 0 : activeMode.getFrameState() == 0;
        } else {
            return;
        }
        String label = maximize ? NbBundle.getMessage((Class)MaximizeWindowAction.class, (String)"CTL_MaximizeWindowAction", (Object)param) : NbBundle.getMessage((Class)MaximizeWindowAction.class, (String)"CTL_UnmaximizeWindowAction", (Object)param);
        this.putValue("Name", this.isPopup ? Actions.cutAmpersand((String)label) : label);
        if (activeMode != null && activeMode.getKind() == 2) {
            maximize = false;
        }
        this.setEnabled(activeMode != null && activeMode.getKind() != 2);
    }

    private static ModeImpl getModeToMaximize(TopComponent tc) {
        ModeImpl maximizedMode;
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        ModeImpl mode = (ModeImpl)wm.findMode(tc);
        if (mode == (maximizedMode = wm.getMaximizedMode())) {
            return null;
        }
        return mode;
    }

    public void putValue(String key, Object newValue) {
        if ("AcceleratorKey".equals(key)) {
            ActionUtils.putSharedAccelerator("MaximizeWindow", newValue);
        } else {
            super.putValue(key, newValue);
        }
    }

    public Object getValue(String key) {
        if ("AcceleratorKey".equals(key)) {
            return ActionUtils.getSharedAccelerator("MaximizeWindow");
        }
        return super.getValue(key);
    }
}

