/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyMapsStorage;
import org.netbeans.modules.editor.settings.storage.MimeLookupInitializerImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;

public class KeyBindingSettingsImpl
extends KeyBindingSettingsFactory
implements MimeLookupInitializerImpl.Factory {
    private String[] mimeTypes;
    private PropertyChangeSupport pcs;
    private Map keyMaps = new HashMap();
    private KeyBindingSettingsFactory baseKBS;
    private Listener listener;
    private boolean init = false;
    private EditorSettingsImpl editorSettingsImpl;
    private Map defaults = new HashMap();
    private boolean isLoggable = false;
    private String logActionName = null;

    KeyBindingSettingsImpl(String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
        this.pcs = new PropertyChangeSupport(this);
        String myClassName = KeyBindingSettingsImpl.class.getName();
        if (System.getProperty(myClassName) != null) {
            this.isLoggable = true;
            if (!"true".equals(System.getProperty(myClassName))) {
                this.logActionName = System.getProperty(myClassName);
            }
            return;
        }
        if (mimeTypes.length != 1) {
            return;
        }
        String propertyValue = System.getProperty(myClassName + '.' + mimeTypes[0]);
        if (propertyValue == null) {
            return;
        }
        this.isLoggable = true;
        this.logActionName = propertyValue;
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.mimeTypes.length != 1 || !this.mimeTypes[0].equals("text/base")) {
            this.baseKBS = this.getEditorSettingsImpl().getKeyBindingSettings(new String[]{"text/base"});
        }
        this.listener = new Listener(this, this.mimeTypes, this.baseKBS, this.getEditorSettingsImpl());
    }

    public List getKeyBindings() {
        List result = this.getKeyBindings(this.getEditorSettingsImpl().getCurrentKeyMapProfile());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeyBindings(String profile) {
        this.init();
        String ss = this.getEditorSettingsImpl().getInternalKeymapProfile(profile);
        if (ss == null) {
            ss = profile;
        }
        ArrayList result = new ArrayList();
        if (!this.keyMaps.containsKey(profile)) {
            KeyBindingSettingsImpl keyBindingSettingsImpl = this;
            synchronized (keyBindingSettingsImpl) {
                HashMap defaults = new HashMap(this.getDefaults(profile));
                Object[] s = KeyMapsStorage.loadKeyMaps(this.mimeTypes, profile, "keybindings.xml");
                Map shortcuts = (Map)s[0];
                Set removedShortcuts = (Set)s[1];
                Iterator it = removedShortcuts.iterator();
                while (it.hasNext()) {
                    defaults.remove(it.next());
                }
                defaults.putAll(shortcuts);
                ArrayList localShortcuts = new ArrayList(defaults.values());
                this.keyMaps.put(profile, localShortcuts);
                result.addAll(localShortcuts);
            }
        } else {
            result.addAll((List)this.keyMaps.get(profile));
        }
        this.log("getKeyBindings", result);
        if (this.baseKBS != null) {
            List baseShortcuts = this.baseKBS.getKeyBindings(profile);
            this.log("", Collections.EMPTY_LIST);
            result.addAll(baseShortcuts);
        }
        return Collections.unmodifiableList(result);
    }

    public List getKeyBindingDefaults(String profile) {
        return Collections.unmodifiableList(new ArrayList(this.getDefaults(profile).values()));
    }

    public synchronized void setKeyBindings(String profile, List keyBindings) {
        this.log("setKeyBindings", keyBindings);
        this.init();
        if (keyBindings == null) {
            this.keyMaps.remove(profile);
            KeyMapsStorage.deleteProfile(this.mimeTypes, profile, "keybindings.xml");
            return;
        }
        this.keyMaps.put(profile, keyBindings);
        HashMap<List, MultiKeyBinding> m = new HashMap<List, MultiKeyBinding>();
        Iterator<Object> it = keyBindings.iterator();
        while (it.hasNext()) {
            MultiKeyBinding mkb = (MultiKeyBinding)it.next();
            m.put(mkb.getKeyStrokeList(), mkb);
        }
        Map defaults = this.getDefaults(profile);
        HashSet<List> removed = new HashSet<List>();
        it = defaults.keySet().iterator();
        while (it.hasNext()) {
            List shortcut = (List)it.next();
            MultiKeyBinding mkb2 = (MultiKeyBinding)defaults.get(shortcut);
            if (!m.containsKey(shortcut)) {
                removed.add(shortcut);
                continue;
            }
            MultiKeyBinding mkb1 = (MultiKeyBinding)m.get(shortcut);
            if (!mkb1.getActionName().equals(mkb2.getActionName())) continue;
            m.remove(shortcut);
        }
        this.log("  changed:", m.values());
        this.log("  removed:", removed);
        this.log("", Collections.EMPTY_LIST);
        this.listener.removeListeners();
        KeyMapsStorage.saveKeyMaps(this.mimeTypes, profile, "keybindings.xml", m.values(), removed);
        this.listener.addListeners();
        this.pcs.firePropertyChange(null, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private EditorSettingsImpl getEditorSettingsImpl() {
        if (this.editorSettingsImpl == null) {
            this.editorSettingsImpl = (EditorSettingsImpl)EditorSettings.getDefault();
        }
        return this.editorSettingsImpl;
    }

    private Map getDefaults(String profile) {
        if (!this.defaults.containsKey(profile)) {
            FileObject defaultFo = Utils.getFileObject(this.mimeTypes, "NetBeans".equals(profile) ? null : profile, "Defaults/keybindings.xml");
            if (defaultFo != null) {
                this.defaults.put(profile, (Map)KeyMapsStorage.loadKeyMaps(defaultFo)[0]);
            } else {
                this.defaults.put(profile, Collections.EMPTY_MAP);
            }
        }
        return (Map)this.defaults.get(profile);
    }

    private void refresh() {
        this.keyMaps = new HashMap();
        this.log("refresh", Collections.EMPTY_SET);
        this.pcs.firePropertyChange(null, null, null);
    }

    private void log(String text, Collection keymap) {
        if (!this.isLoggable) {
            return;
        }
        if (!text.equals("")) {
            if (this.mimeTypes.length == 1) {
                text = text + " " + this.mimeTypes[0];
            }
            text = text + " " + this.getEditorSettingsImpl().getCurrentKeyMapProfile();
        }
        if (keymap == null) {
            System.out.println(text + " : null");
            return;
        }
        System.out.println(text);
        Iterator it = keymap.iterator();
        while (it.hasNext()) {
            Object mkb = it.next();
            if (this.logActionName == null || !(mkb instanceof MultiKeyBinding)) {
                System.out.println("  " + mkb);
                continue;
            }
            if (!(mkb instanceof MultiKeyBinding) || !this.logActionName.equals(((MultiKeyBinding)mkb).getActionName())) continue;
            System.out.println("  " + mkb);
        }
    }

    public Object createInstance() {
        List keyB = this.getKeyBindings();
        return new Immutable(new ArrayList(keyB));
    }

    private static final class Immutable
    extends KeyBindingSettings {
        private List keyBindings;

        public Immutable(List keyBindings) {
            this.keyBindings = keyBindings;
        }

        public List getKeyBindings() {
            return Collections.unmodifiableList(this.keyBindings);
        }
    }

    private static class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private WeakReference wr;
        private FileObject fo;
        private String[] mimeTypes;
        private KeyBindingSettingsFactory baseKBS;
        private EditorSettings editorSettings;

        Listener(KeyBindingSettingsImpl kb, String[] mimeTypes, KeyBindingSettingsFactory baseKBS, EditorSettings editorSettings) {
            this.mimeTypes = mimeTypes;
            this.editorSettings = editorSettings;
            this.baseKBS = baseKBS;
            this.addListeners();
            this.wr = new WeakReference<KeyBindingSettingsImpl>(kb);
        }

        private KeyBindingSettingsImpl getSettings() {
            KeyBindingSettingsImpl r = (KeyBindingSettingsImpl)this.wr.get();
            if (r != null) {
                return r;
            }
            this.removeListeners();
            return null;
        }

        private void addListeners() {
            this.editorSettings.addPropertyChangeListener("currentKeyMapProfile", this);
            if (this.baseKBS != null) {
                this.baseKBS.addPropertyChangeListener(this);
            }
            this.setFolderListener();
        }

        private void removeListeners() {
            this.fo.removeFileChangeListener((FileChangeListener)this);
            if (this.baseKBS != null) {
                this.baseKBS.removePropertyChangeListener(this);
            }
            this.editorSettings.removePropertyChangeListener("currentKeyMapProfile", this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            KeyBindingSettingsImpl r = this.getSettings();
            if (r == null) {
                return;
            }
            if ("currentKeyMapProfile".equals(evt.getPropertyName())) {
                this.setFolderListener();
            }
            r.log("refresh2", Collections.EMPTY_SET);
            r.pcs.firePropertyChange(null, null, null);
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            KeyBindingSettingsImpl r = this.getSettings();
            if (r == null) {
                return;
            }
            if (fe.getFile().getNameExt().equals("keybindings.xml")) {
                r.refresh();
            }
        }

        public void fileDeleted(FileEvent fe) {
            KeyBindingSettingsImpl r = this.getSettings();
            if (r == null) {
                return;
            }
            if (fe.getFile().getNameExt().equals("keybindings.xml")) {
                r.refresh();
            }
        }

        private void setFolderListener() {
            String profile;
            if (this.fo != null) {
                this.fo.removeFileChangeListener((FileChangeListener)this);
            }
            if ((profile = this.editorSettings.getCurrentKeyMapProfile()).equals("NetBeans")) {
                profile = null;
            }
            this.fo = Utils.createFileObject(this.mimeTypes, profile, null);
            this.fo.addFileChangeListener((FileChangeListener)this);
        }
    }
}

