/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientProjectUtil {
    private AppClientProjectUtil() {
    }

    public static Object getEvaluatedProperty(Project p, String value) {
        if (value == null) {
            return null;
        }
        AppClientProject j2seprj = (AppClientProject)p.getLookup().lookup(AppClientProject.class);
        if (j2seprj != null) {
            return j2seprj.evaluator().evaluate(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMainMethod(FileObject fo) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        if (fo == null) {
            return false;
        }
        boolean has = false;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((FileObject)fo);
            Resource res = JavaModel.getResource((FileObject)fo);
            assert (res != null) : "Resource found for FileObject " + fo;
            has = !res.getMain().isEmpty();
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        return has;
    }

    public static List<String> getMainClasses(FileObject[] roots) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < roots.length; ++i) {
            AppClientProjectUtil.getMainClasses(roots[i], result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getMainClasses(FileObject root, List<String> addInto) {
        JMManager.getManager().waitScanFinished();
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModelPackage mofPackage = JavaModel.getJavaExtent((FileObject)root);
            ClassIndex index = ClassIndex.getIndex((JavaModelPackage)mofPackage);
            Collection col = index.findResourcesForIdent("main");
            Object[] arr = col.toArray();
            if (arr == null) {
                return;
            }
            for (int i = 0; i < arr.length; ++i) {
                Resource res = (Resource)arr[i];
                for (JavaClass jcls : res.getMain()) {
                    addInto.add(jcls.getName());
                }
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }

    public static boolean isMainClass(String className, FileObject[] roots) {
        return AppClientProjectUtil.isMainClass(className, ClassPathSupport.createClassPath((FileObject[])roots));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMainClass(String className, ClassPath cp) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        JavaModel.getJavaRepository().beginTrans(false);
        boolean isMain = false;
        try {
            Resource res;
            JavaModel.setClassPath((ClassPath)cp);
            Type clazz = JavaModel.getDefaultExtent().getType().resolve(className);
            if (clazz != null && (res = clazz.getResource()) != null) {
                isMain = res.getMain().contains(clazz);
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        return isMain;
    }

    public static URL getRootURL(File root, String offset) throws MalformedURLException {
        URL url = root.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        } else if (!root.exists()) {
            url = new URL(url.toExternalForm() + "/");
        }
        if (offset != null) {
            assert (offset.endsWith("/"));
            url = new URL(url.toExternalForm() + offset);
        }
        return url;
    }

    public static JavaPlatform getActivePlatform(String activePlatformId) {
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        if (activePlatformId == null) {
            return pm.getDefaultPlatform();
        }
        JavaPlatform[] installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String antName = (String)installedPlatforms[i].getProperties().get("platform.ant.name");
            if (antName == null || !antName.equals(activePlatformId)) continue;
            return installedPlatforms[i];
        }
        return null;
    }
}

