/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ElementFormat;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ConstructorElementNode;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class MethodElementNode
extends ConstructorElementNode {
    public MethodElementNode(MethodElement element, boolean writeable) {
        super(element, writeable);
        this.setElementFormat0(sourceOptions.getMethodElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.nodes.MethodNode");
    }

    protected String resolveIconBase() {
        int modif = ((MethodElement)this.element).getModifiers();
        if (Modifier.isStatic(modif)) {
            if (Modifier.isPrivate(modif)) {
                return "org/openide/src/resources/methodStPrivate";
            }
            if (Modifier.isProtected(modif)) {
                return "org/openide/src/resources/methodStProtected";
            }
            if (Modifier.isPublic(modif)) {
                return "org/openide/src/resources/methodStPublic";
            }
            return "org/openide/src/resources/methodStPackage";
        }
        if (Modifier.isPrivate(modif)) {
            return "org/openide/src/resources/methodPrivate";
        }
        if (Modifier.isProtected(modif)) {
            return "org/openide/src/resources/methodProtected";
        }
        if (Modifier.isPublic(modif)) {
            return "org/openide/src/resources/methodPublic";
        }
        return "org/openide/src/resources/methodPackage";
    }

    public boolean canRename() {
        return true;
    }

    protected ElementFormat getHintElementFormat() {
        return sourceOptions.getMethodElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.writeable));
        ps.put(this.createNameProperty(this.writeable));
        ps.put(this.createParametersProperty(this.writeable));
        ps.put(this.createReturnProperty(this.writeable));
        ps.put(this.createExceptionsProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                MethodElement el = (MethodElement)MethodElementNode.this.element;
                el.getDeclaringClass().removeMethod(el);
            }
        });
        super.destroy();
    }

    protected Node.Property createReturnProperty(boolean canW) {
        return new ElementNode.ElementProp("return", Type.class, canW){

            public Object getValue() {
                return ((MethodElement)MethodElementNode.this.element).getReturn();
            }

            public void setValue(final Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(MethodElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((MethodElement)(this).MethodElementNode.this.element).setReturn((Type)val);
                    }
                });
            }
        };
    }
}

