/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.src.DefaultElementPrinter;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.ElementProperties;
import org.openide.src.JavaDoc;
import org.openide.src.SourceException;
import org.openide.text.FilterDocument;
import org.openide.text.IndentEngine;

public abstract class Element
implements Serializable,
ElementProperties,
Node.Cookie {
    protected Impl impl;
    protected Impl2 impl2;
    static final long serialVersionUID = 967040188302141522L;

    protected Element(Impl impl) {
        this.impl = impl;
        if (impl instanceof Impl2) {
            this.impl2 = (Impl2)impl;
        }
        impl.attachedToElement(this);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.impl.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.impl.removePropertyChangeListener(l);
    }

    public final void addVetoableChangeListener(VetoableChangeListener l) {
        if (this.impl2 != null) {
            this.impl2.addVetoableChangeListener(l);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.impl2 != null) {
            this.impl2.removeVetoableChangeListener(l);
        }
    }

    public void markCurrent(boolean beforeAfter) {
        this.impl.markCurrent(beforeAfter);
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie c = this.impl.getCookie(type);
        if (c == null && type.isAssignableFrom(this.getClass())) {
            c = this;
        }
        return c;
    }

    protected Object writeReplace() {
        return this.impl;
    }

    public abstract void print(ElementPrinter var1) throws ElementPrinterInterruptException;

    static boolean print(Element[] el, ElementPrinter printer) throws ElementPrinterInterruptException {
        for (int i = 0; i < el.length; ++i) {
            if (i > 0) {
                printer.println("");
                printer.println("");
            }
            el[i].print(printer);
        }
        return el.length > 0;
    }

    static void printJavaDoc(JavaDoc doc, ElementPrinter printer) throws ElementPrinterInterruptException {
        if (doc.isEmpty()) {
            return;
        }
        String javaText = doc.getRawText();
        String[] lines = javaText.split("\\n");
        printer.print("/**\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            printer.print("*");
            if (line.length() > 0 && line.charAt(0) != ' ') {
                printer.print(" ");
            }
            printer.println(line);
        }
        printer.print(" */");
    }

    StyledDocument createDocument() {
        Document doc;
        EditorKit kit = JEditorPane.createEditorKitForContentType("text/x-java");
        if (kit == null) {
            kit = new DefaultEditorKit();
        }
        if ((doc = kit.createDefaultDocument()) instanceof StyledDocument) {
            return (StyledDocument)doc;
        }
        return new FilterDocument(doc);
    }

    void throwSourceException(String message) throws SourceException {
        SourceException ex = new SourceException(message);
        ErrorManager.getDefault().annotate((Throwable)ex, 256, null, message, null, null);
        throw ex;
    }

    void throwSourceException(Throwable nested) throws SourceException {
        SourceException ex = new SourceException(nested.getMessage());
        ErrorManager.getDefault().annotate((Throwable)ex, nested);
        throw ex;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        StyledDocument doc = this.createDocument();
        IndentEngine indentator = IndentEngine.find((Document)doc);
        PrintWriter pw = new PrintWriter(indentator.createWriter((Document)doc, 0, (Writer)sw));
        try {
            this.print(new DefaultElementPrinter(pw));
        }
        catch (ElementPrinterInterruptException e) {
            // empty catch block
        }
        pw.close();
        return sw.toString();
    }

    static abstract class Memory
    implements Impl2,
    Node.Cookie {
        protected Element element;
        private PropertyChangeSupport support;
        private VetoableChangeSupport vetoSupport;
        static final long serialVersionUID = 7734412320645883859L;

        Memory() {
        }

        public void attachedToElement(Element element) {
            this.element = element;
        }

        protected final void firePropertyChange(String name, Object o, Object n) {
            if (this.support != null) {
                this.support.firePropertyChange(name, o, n);
            }
        }

        protected final void firePropertyChange(PropertyChangeEvent evt) {
            if (this.support != null) {
                this.support.firePropertyChange(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            if (this.support == null) {
                Memory memory = this;
                synchronized (memory) {
                    if (this.support == null) {
                        this.support = new PropertyChangeSupport(this.element);
                    }
                }
            }
            this.support.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.support != null) {
                this.support.removePropertyChangeListener(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addVetoableChangeListener(VetoableChangeListener l) {
            if (this.vetoSupport == null) {
                Memory memory = this;
                synchronized (memory) {
                    if (this.vetoSupport == null) {
                        this.vetoSupport = new VetoableChangeSupport(this);
                    }
                }
            }
            this.vetoSupport.addVetoableChangeListener(l);
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
            if (this.vetoSupport != null) {
                this.vetoSupport.removeVetoableChangeListener(l);
            }
        }

        protected void fireVetoableChange(String name, Object o, Object v) throws PropertyVetoException {
            if (this.vetoSupport != null) {
                this.vetoSupport.fireVetoableChange(name, o, v);
            }
        }

        protected void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (this.vetoSupport != null) {
                this.vetoSupport.fireVetoableChange(evt);
            }
        }

        public Node.Cookie getCookie(Class type) {
            if (type.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public void markCurrent(boolean beforeAfter) {
        }

        public boolean isValid() {
            return true;
        }
    }

    public static interface Impl2
    extends Impl {
        public void addVetoableChangeListener(VetoableChangeListener var1);

        public void removeVetoableChangeListener(VetoableChangeListener var1);

        public boolean isValid();
    }

    public static interface Impl
    extends Serializable {
        public static final long serialVersionUID = -3246061193296761293L;

        public void attachedToElement(Element var1);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public Object readResolve();

        public Node.Cookie getCookie(Class var1);

        public void markCurrent(boolean var1);
    }
}

