/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.WhereUsedAction;
import org.netbeans.modules.refactoring.ui.WhereUsedPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WhereUsedQueryUI
implements RefactoringUI {
    private final WhereUsedQuery query;
    private final String name;
    private WhereUsedPanel panel;
    private final RefObject element;
    private ResourceBundle bundle;

    public WhereUsedQueryUI(RefObject jmiObject) {
        this.query = new WhereUsedQuery(jmiObject);
        this.element = jmiObject;
        this.name = jmiObject instanceof Constructor ? ((JavaClass)((Constructor)jmiObject).getDeclaringClass()).getName() : (jmiObject instanceof NamedElement ? ((NamedElement)jmiObject).getName() : "");
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.element, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.setSearchInComments(this.panel.isSearchInComments());
        if (this.element instanceof Method) {
            this.query.setSearchFromBaseClass(this.panel.isMethodFromBaseClass());
            this.query.setFindOverridingMethods(this.panel.isMethodOverriders());
            this.query.setFindUsages(this.panel.isMethodFindUsages());
            return this.query.checkParameters();
        }
        if (this.element instanceof JavaClass) {
            this.query.setFindSubclasses(this.panel.isClassSubTypes());
            this.query.setFindDirectSubclassesOnly(this.panel.isClassSubTypesDirectOnly());
            return this.query.checkParameters();
        }
        return null;
    }

    public Problem checkParameters() {
        if (this.element instanceof Method) {
            this.query.setSearchFromBaseClass(this.panel.isMethodFromBaseClass());
            this.query.setFindOverridingMethods(this.panel.isMethodOverriders());
            this.query.setFindUsages(this.panel.isMethodFindUsages());
            return this.query.fastCheckParameters();
        }
        if (this.element instanceof JavaClass) {
            this.query.setFindSubclasses(this.panel.isClassSubTypes());
            this.query.setFindDirectSubclassesOnly(this.panel.isClassSubTypesDirectOnly());
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query;
    }

    public String getDescription() {
        if (this.panel != null) {
            if (this.element instanceof JavaClass) {
                if (!this.panel.isClassFindUsages()) {
                    if (!this.panel.isClassSubTypesDirectOnly()) {
                        return this.getString("DSC_WhereUsedFindAllSubTypes", this.name);
                    }
                    return this.getString("DSC_WhereUsedFindDirectSubTypes", this.name);
                }
            } else if (this.element instanceof Method) {
                String description = null;
                if (this.panel.isMethodFindUsages()) {
                    description = this.getString("DSC_FindUsages");
                }
                if (this.panel.isMethodOverriders()) {
                    description = description != null ? description + " " + this.getString("DSC_And") + " " : "";
                    description = description + this.getString("DSC_WhereUsedMethodOverriders");
                }
                description = description + " " + this.getString("DSC_WhereUsedOf", this.panel.getMethodDeclaringClass() + '.' + this.name);
                return description;
            }
        }
        return this.getString("DSC_WhereUsed", this.name);
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)WhereUsedQueryUI.class);
        }
        return this.bundle.getString(key);
    }

    private String getString(String key, String value) {
        return new MessageFormat(this.getString(key)).format(new Object[]{value});
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage((Class)WhereUsedAction.class, (String)"LBL_WhereUsed")).format(new Object[]{this.name});
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WhereUsedQueryUI.class);
    }
}

