/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.BitSet;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDatabase;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MapPage;

class LogFile {
    private int pageSize;
    private int numFiles;
    private final String baseName;
    private String name;
    private BitSet[] pageBitmaps;
    private MapPage currentMap;
    private FileCache cache;
    long fileId;
    private int beforeWriteFailure = -1;
    private int afterCommitFailure = -1;
    private int recoveryFailure = -1;

    LogFile(FileCache fCache, String baseName, int pgSz, int files, long id) throws StorageException {
        this.cache = fCache;
        this.pageSize = pgSz;
        this.baseName = baseName;
        this.numFiles = files;
        this.fileId = id;
        this.pageBitmaps = new BitSet[files];
        for (int i = 0; i < files; ++i) {
            this.pageBitmaps[i] = new BitSet();
        }
        if (new File(BtreeDatabase.getFileName(baseName, 2)).exists()) {
            this.recover();
        }
    }

    private boolean isPageLogged(CachedPage page) {
        return this.pageBitmaps[page.key.fileIndex].get(page.key.offset / this.pageSize);
    }

    private RandomAccessFile createPhysicalLog() throws StorageException {
        String name = BtreeDatabase.getFileName(this.baseName, 2);
        RandomAccessFile file = null;
        try {
            file = FileCache.getFile(name);
            file.setLength(0L);
            this.writeMap(file);
            RandomAccessFile randomAccessFile = file;
            return randomAccessFile;
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        finally {
            if (file != null) {
                this.name = name;
            }
        }
    }

    void addPageToLog(CachedPage page) throws StorageException {
        RandomAccessFile file;
        if (page.key.offset >= this.currentMap.getEOF(page.key.fileIndex)) {
            return;
        }
        if (this.isPageLogged(page)) {
            return;
        }
        try {
            file = this.name == null ? this.createPhysicalLog() : FileCache.getFile(this.name);
            file.seek(this.currentMap.nextPageOffset());
            file.write(page.contents);
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        this.beforeWriteFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.beforeWriteFailure", this.beforeWriteFailure);
        this.pageBitmaps[page.key.fileIndex].set(page.key.offset / this.pageSize);
        this.currentMap.add(page);
        if (this.currentMap.isFull()) {
            this.writeMap(file);
        }
        this.cache.holdForLog(page);
    }

    private void writeMap(RandomAccessFile file) throws StorageException {
        this.flushFile(file);
        this.currentMap.write(file);
        this.flushFile(file);
        if (this.currentMap.isFull()) {
            this.currentMap = new MapPage(this.currentMap);
        }
    }

    private void flushFile(RandomAccessFile file) throws StorageException {
        try {
            file.getFD().sync();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    void flush() throws StorageException {
        try {
            this.writeMap(FileCache.getFile(this.name));
            this.cache.logWasFlushed();
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    void begin(String[] fileNames, long timeStamp, long newTimeStamp) throws StorageException {
        RandomAccessFile[] files;
        this.name = null;
        this.currentMap = new MapPage(this.pageSize, this.numFiles, 0);
        try {
            files = FileCache.getFiles(fileNames);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
        this.currentMap.setEOFs(files);
        for (int i = 0; i < this.numFiles; ++i) {
            this.pageBitmaps[i].xor(this.pageBitmaps[i]);
        }
        this.currentMap.setTimeStamps(timeStamp, newTimeStamp);
        this.currentMap.setFileID(this.fileId);
    }

    void commit() throws StorageException {
        try {
            if (this.name != null) {
                FileCache.closeFile(this.name);
                new File(this.name).delete();
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        this.name = null;
        this.afterCommitFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.afterCommitFailure", this.afterCommitFailure);
    }

    void close() throws StorageException {
        try {
            if (this.name != null) {
                FileCache.closeFile(this.name);
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    int fileSize() {
        return this.currentMap.nextPageOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recover() throws StorageException {
        RandomAccessFile[] files = null;
        RandomAccessFile logFile = null;
        try {
            try {
                logFile = new RandomAccessFile(BtreeDatabase.getFileName(this.baseName, 2), "r");
                files = this.cache.getFiles();
                if (files.length != this.numFiles) {
                    throw new StorageBadRequestException(MessageFormat.format("Log file contains {0} files; {1} were requested", new Integer(this.numFiles), new Integer(files.length)));
                }
                int numPages = (int)logFile.length() / this.pageSize;
                if (numPages > 0) {
                    byte[] pageBuffer = new byte[this.pageSize];
                    MapPage page = new MapPage(logFile, 0, this.pageSize);
                    page.checkParameters(this.pageSize, this.numFiles);
                    for (int i = 0; i < this.numFiles; ++i) {
                        page.checkFileHeader(files[i]);
                    }
                    while (true) {
                        page.recover(files, logFile, numPages, pageBuffer);
                        this.recoveryFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.recoveryFailure", this.recoveryFailure);
                        MapPage newPage = page.getNext(logFile, numPages);
                        if (newPage == null || newPage.isEmpty()) break;
                        page = newPage;
                    }
                    page.truncateFiles(files);
                    logFile.close();
                    new File(BtreeDatabase.getFileName(this.baseName, 2)).delete();
                }
            }
            finally {
                if (logFile != null) {
                    logFile.close();
                }
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }
}

