/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.DeployDataExtraPanel;
import org.netbeans.modules.web.wizards.DeployDataPanel;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

public class ServletPanel
implements WizardDescriptor.FinishPanel {
    private transient BaseWizardPanel wizardPanel;
    private transient TemplateWizard wizard;
    private ChangeListener listener;
    private DeployData deployData;
    private transient TargetEvaluator evaluator;

    private ServletPanel(TargetEvaluator evaluator, TemplateWizard wizard, boolean first) {
        this.evaluator = evaluator;
        this.wizard = wizard;
        this.deployData = evaluator.getDeployData();
        this.wizardPanel = first ? new DeployDataPanel(evaluator) : new DeployDataExtraPanel(evaluator);
    }

    public static ServletPanel createServletPanel(TargetEvaluator evaluator, TemplateWizard wizard) {
        return new ServletPanel(evaluator, wizard, true);
    }

    public static ServletPanel createFilterPanel(TargetEvaluator evaluator, TemplateWizard wizard) {
        return new ServletPanel(evaluator, wizard, false);
    }

    public Component getComponent() {
        return this.wizardPanel;
    }

    public boolean isValid() {
        if (this.deployData.isValid()) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)this.deployData.getErrorMessage());
        return false;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        if (this.wizardPanel != null) {
            this.wizardPanel.addChangeListener(l);
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
        if (this.wizardPanel != null) {
            this.wizardPanel.removeChangeListener(l);
        }
    }

    public void readSettings(Object settings) {
        if (settings instanceof TemplateWizard) {
            TemplateWizard w = (TemplateWizard)settings;
            String targetName = w.getTargetName();
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)w);
            Project project = Templates.getProject((WizardDescriptor)w);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            String packageName = null;
            for (int i = 0; i < groups.length && packageName == null; ++i) {
                if (WebModule.getWebModule((FileObject)groups[i].getRootFolder()) == null) continue;
                packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
            }
            packageName = packageName != null ? packageName.replace('/', '.') : "";
            if (targetName == null) {
                this.evaluator.setClassName(w.getTemplate().getName(), packageName);
            } else {
                this.evaluator.setClassName(targetName, packageName);
            }
        }
        this.wizardPanel.setData();
    }

    public void storeSettings(Object settings) {
    }
}

