/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.regexp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.i18n.regexp.TreeNode;

class Generator {
    private StringBuffer buf = new StringBuffer(20);
    private Map tokenReplacements;
    private boolean generatingSetOfChars = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    Generator() {
    }

    public static String generateRegexp(TreeNode parseTree) {
        return Generator.generateRegexp(parseTree, null);
    }

    public static String generateRegexp(TreeNode parseTree, Map tokenReplacements) {
        if (parseTree == null) {
            return null;
        }
        Generator g = new Generator();
        g.setTokenReplacements(tokenReplacements);
        g.generate(parseTree);
        return g.buf.toString();
    }

    private static String quoteString(String string) {
        StringBuffer buf;
        if (string.length() == 0) {
            return string;
        }
        int startIndex = 0;
        int endIndex = string.indexOf(92);
        if (endIndex == -1) {
            buf = new StringBuffer(string.length() + 4);
            buf.append("\\Q").append(string).append("\\E");
        } else {
            buf = new StringBuffer(string.length() + 16);
            do {
                if (endIndex != startIndex) {
                    buf.append("\\Q");
                    buf.append(string.substring(startIndex, endIndex));
                    buf.append("\\E");
                }
                buf.append('\\').append('\\');
            } while ((endIndex = string.indexOf(92, startIndex = endIndex + 1)) != -1);
            if (startIndex != string.length()) {
                buf.append("\\Q");
                buf.append(string.substring(startIndex));
                buf.append("\\E");
            }
        }
        return buf.toString();
    }

    private void setTokenReplacements(Map tokenReplacements) {
        if (tokenReplacements != null && tokenReplacements.isEmpty()) {
            tokenReplacements = null;
        }
        this.tokenReplacements = tokenReplacements;
        if (tokenReplacements != null) {
            this.quoteTokenReplacements();
        }
    }

    private void quoteTokenReplacements() {
        if (this.tokenReplacements == null || this.tokenReplacements.isEmpty()) {
            return;
        }
        Set replacementEntries = this.tokenReplacements.entrySet();
        Iterator i = replacementEntries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            entry.setValue(Generator.quoteString((String)entry.getValue()));
        }
    }

    private void generate(TreeNode treeNode) {
        List children = treeNode.getChildren();
        int tokenType = treeNode.getTokenType();
        Object attribs = treeNode.getAttribs();
        block0 : switch (tokenType) {
            case 8: {
                char ch = ((Character)attribs).charValue();
                switch (ch) {
                    case '\t': {
                        this.buf.append('\\').append('t');
                        break block0;
                    }
                    case '\n': {
                        this.buf.append('\\').append('n');
                        break block0;
                    }
                    case '\r': {
                        this.buf.append('\\').append('r');
                        break block0;
                    }
                    case '\f': {
                        this.buf.append('\\').append('f');
                        break block0;
                    }
                    case '\\': {
                        this.buf.append('\\').append('\\');
                        break block0;
                    }
                }
                if (!this.generatingSetOfChars && "^$|*+?.()[]{}".indexOf(ch) != -1) {
                    this.buf.append('\\');
                }
                this.buf.append(ch);
                break;
            }
            case 6: {
                char charType = ((Character)attribs).charValue();
                if (charType == '.') {
                    this.buf.append('.');
                    break;
                }
                this.buf.append('\\').append(charType);
                break;
            }
            case 4: {
                if (attribs instanceof Character) {
                    char charType = ((Character)attribs).charValue();
                    this.buf.append(charType);
                    break;
                }
                String type = (String)attribs;
                this.buf.append('{');
                this.generate((TreeNode)children.get(0));
                if (type.length() > 3) {
                    this.buf.append(',');
                    if (type.length() == 5) {
                        this.generate((TreeNode)children.get(1));
                    }
                }
                this.buf.append('}');
                break;
            }
            case 3: {
                this.generate((TreeNode)children.get(0));
                if (children.size() != 2) break;
                this.generate((TreeNode)children.get(1));
                break;
            }
            case 12: {
                this.generate((TreeNode)children.get(0));
                this.buf.append('-');
                this.generate((TreeNode)children.get(1));
                break;
            }
            case 11: {
                this.buf.append('[');
                if (attribs != null) {
                    this.buf.append((String)attribs);
                }
                if (children != null) {
                    this.generatingSetOfChars = true;
                    if (children.size() == 1) {
                        this.generate((TreeNode)children.get(0));
                    } else {
                        Iterator i = children.iterator();
                        while (i.hasNext()) {
                            this.generate((TreeNode)i.next());
                        }
                    }
                    this.generatingSetOfChars = false;
                }
                this.buf.append(']');
                break;
            }
            case 2: {
                if (children == null) break;
                if (children.size() == 1) {
                    this.generate((TreeNode)children.get(0));
                    break;
                }
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    this.generate((TreeNode)i.next());
                }
                break;
            }
            case 9: {
                this.buf.append('(').append('?').append(':');
                this.generate((TreeNode)children.get(0));
                this.buf.append(')');
                break;
            }
            case 1: {
                this.generate((TreeNode)children.get(0));
                if (children.size() <= 1) break;
                Iterator i = children.iterator();
                i.next();
                do {
                    this.buf.append('|');
                    this.generate((TreeNode)i.next());
                } while (i.hasNext());
                break;
            }
            case 5: {
                this.buf.append(attribs.toString());
                break;
            }
            case 7: {
                int code = (Integer)attribs;
                this.buf.append((char)code);
                break;
            }
            case 10: {
                this.buf.append('\\').append('p');
                this.buf.append('{');
                String className = (String)attribs;
                if (className.equals("ascii")) {
                    this.buf.append("ASCII");
                } else if (className.equals("xdigit")) {
                    this.buf.append("XDigit");
                } else {
                    this.buf.append(Character.toUpperCase(className.charAt(0)));
                    this.buf.append(className.substring(1));
                }
                this.buf.append('}');
                break;
            }
            case 0: {
                String attrString = (String)attribs;
                if (attrString != null && attrString.charAt(0) == '^') {
                    this.buf.append('^');
                }
                if (children != null) {
                    this.generate((TreeNode)children.get(0));
                }
                if (attrString == null || attrString.length() != 2 && attrString.charAt(0) != '$') break;
                this.buf.append('$');
                break;
            }
            case 13: {
                Object replacement;
                String tokenName = (String)attribs;
                Object object = replacement = this.tokenReplacements != null ? (Object)this.tokenReplacements.get(tokenName) : null;
                if (replacement != null) {
                    this.buf.append('(').append('?').append(':');
                    this.buf.append(replacement.toString());
                    this.buf.append(')');
                    break;
                }
                this.buf.append('{').append(tokenName).append('}');
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    static {
        $assertionsDisabled = !Generator.class.desiredAssertionStatus();
    }
}

