/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.modules.form.codestructure.CodeStructureChange;
import org.netbeans.modules.form.codestructure.UsedCodeObject;
import org.netbeans.modules.form.codestructure.UsingCodeObject;

final class CodeObjectUsage {
    private UsedCodeObject usedObject;
    private List usageList;

    public CodeObjectUsage(UsedCodeObject usedObject) {
        this.usedObject = usedObject;
    }

    public CodeStructureChange addUsingObject(UsingCodeObject usingObject, int useType, Object useCategory, boolean provideUndoableChange) {
        if (useCategory == null) {
            throw new IllegalArgumentException();
        }
        if (this.usageList == null) {
            this.usageList = new LinkedList();
        }
        ObjectUse use = new ObjectUse(usingObject, useType, useCategory);
        this.usageList.add(use);
        usingObject.usageRegistered(this.usedObject);
        return provideUndoableChange ? new UsageChange(this.usedObject, use, true) : null;
    }

    public CodeStructureChange removeUsingObject(UsingCodeObject usingObject, boolean provideUndoableChange) {
        if (this.usageList == null) {
            return null;
        }
        ObjectUse removed = null;
        Iterator it = this.usageList.iterator();
        while (it.hasNext()) {
            ObjectUse use = (ObjectUse)it.next();
            if (usingObject != use.usingObject) continue;
            removed = use;
            it.remove();
        }
        if (removed != null) {
            usingObject.usedObjectRemoved(this.usedObject);
        }
        return provideUndoableChange && removed != null ? new UsageChange(this.usedObject, removed, false) : null;
    }

    public Iterator getUsingObjectsIterator(int useType, Object useCategory) {
        Iterator it = this.usageList != null ? this.usageList.iterator() : null;
        return new UsageIterator(it, useType, useCategory);
    }

    public boolean isEmpty() {
        return this.usageList == null || this.usageList.size() == 0;
    }

    private static class UsageIterator
    implements Iterator {
        private int useType;
        private Object useCategory;
        private Iterator iterator;
        private Object next;

        public UsageIterator(Iterator iterator, int useType, Object useCategory) {
            this.iterator = iterator;
            this.useType = useType;
            this.useCategory = useCategory;
        }

        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                ObjectUse use = (ObjectUse)this.iterator.next();
                if (!use.matches(this.useType, this.useCategory)) continue;
                this.next = use.usingObject;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object nextObject = this.next;
            this.next = null;
            return nextObject;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UsageChange
    implements CodeStructureChange {
        private UsedCodeObject usedObject;
        private ObjectUse use;
        private boolean added;

        UsageChange(UsedCodeObject usedObject, ObjectUse use, boolean added) {
            this.usedObject = usedObject;
            this.use = use;
            this.added = added;
        }

        public void undo() {
            if (this.added) {
                this.usedObject.removeUsingObject(this.use.usingObject);
            } else {
                this.usedObject.addUsingObject(this.use.usingObject, this.use.type, this.use.category);
            }
        }

        public void redo() {
            if (this.added) {
                this.usedObject.addUsingObject(this.use.usingObject, this.use.type, this.use.category);
            } else {
                this.usedObject.removeUsingObject(this.use.usingObject);
            }
        }
    }

    private static class ObjectUse {
        private UsingCodeObject usingObject;
        private int type;
        private Object category;

        ObjectUse(UsingCodeObject usingObject, int useType, Object useCategory) {
            this.usingObject = usingObject;
            this.type = useType;
            this.category = useCategory;
        }

        boolean matches(int type, Object category) {
            if (type != 0 && type != this.type) {
                return false;
            }
            if (category == null) {
                return true;
            }
            return category.equals(this.category);
        }
    }
}

