/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.METACustomizer;
import org.openide.text.ActiveEditorDrop;

public class META
implements ActiveEditorDrop {
    public static final String TYPE_HEADERS = "HEADERS";
    public static final String TYPE_ENGINES = "ENGINES";
    public static final String[] headers = new String[]{"Content-Type", "Content-Language", "Refresh", "Cache-Control", "Expires"};
    public static final int HEADER_DEFAULT = 0;
    public static final String[] engines = new String[]{"robots", "description", "keywords"};
    public static final int ENGINE_DEFAULT = 0;
    private String type = "HEADERS";
    private int nameIndex = 0;
    private String name = "";
    private String content = "";

    public boolean handleTransfer(JTextComponent targetComponent) {
        METACustomizer c = new METACustomizer(this);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                HTMLPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        if (this.getNameIndex() != -1) {
            if (this.getType().equals(TYPE_HEADERS) && this.getNameIndex() != -1) {
                this.setName(headers[this.getNameIndex()]);
            } else if (this.getType().equals(TYPE_ENGINES) && this.getNameIndex() != -1) {
                this.setName(engines[this.getNameIndex()]);
            }
        }
        String strType = "";
        strType = this.getType().equals(TYPE_HEADERS) ? " http-equiv=\"" + this.getName() + "\"" : " name=\"" + this.getName() + "\"";
        String strContent = " content=\"\"";
        if (this.getContent().length() > 0) {
            strContent = " content=\"" + this.getContent() + "\"";
        }
        String meta = "<meta" + strType + strContent + " />";
        return meta;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

