/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonListener;

class AquaToolBarButtonUI
extends ButtonUI
implements ChangeListener {
    private static BasicButtonListener listener = new BasicButtonListener(null);
    private final Rectangle scratch = new Rectangle();
    private FontMetrics fm = null;
    private static final int minButtonSize = 32;

    public void installUI(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        b.addMouseListener(listener);
        b.addChangeListener(this);
        b.setContentAreaFilled(false);
        b.setOpaque(false);
        b.setFocusable(false);
        b.setBorderPainted(false);
        b.setBorder(BorderFactory.createEmptyBorder());
    }

    public void uninstallUI(JComponent c) {
        c.removeMouseListener(listener);
    }

    public void stateChanged(ChangeEvent e) {
        ((AbstractButton)e.getSource()).repaint();
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle r = c.getBounds(this.scratch);
        AbstractButton b = (AbstractButton)c;
        r.x = 0;
        r.y = 0;
        Paint temp = ((Graphics2D)g).getPaint();
        this.paintBackground((Graphics2D)g, b, r);
        this.paintIcon(g, b, r);
        this.paintText(g, b, r);
        ((Graphics2D)g).setPaint(temp);
    }

    private void paintText(Graphics g, AbstractButton b, Rectangle r) {
        String s = b.getText();
        if (s == null || s.length() == 0) {
            return;
        }
        g.setColor(b.getForeground());
        Font f = b.getFont();
        if (b.isSelected()) {
            f = new Font(f.getName(), 1, f.getSize());
        }
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        if (this.fm == null) {
            this.fm = fm;
        }
        int x = 0;
        Icon ic = b.getIcon();
        if (ic != null) {
            x = ic.getIconWidth() + 2;
        } else {
            int w = fm.stringWidth(s);
            if (w <= r.width) {
                x = r.width / 2 - w / 2;
            }
        }
        int h = fm.getHeight();
        int y = fm.getMaxAscent();
        if (h <= r.height) {
            y += r.height / 2 - h / 2;
        }
        g.drawString(s, x, y);
    }

    private void paintBackground(Graphics2D g, AbstractButton b, Rectangle r) {
        if (b.isEnabled()) {
            if (b.getModel().isPressed()) {
                this.compositeColor(g, r, Color.BLUE, 0.3f);
            } else if (b.getModel().isSelected()) {
                this.compositeColor(g, r, new Color(0, 120, 255), 0.2f);
            }
        }
    }

    private void compositeColor(Graphics2D g, Rectangle r, Color c, float alpha) {
        g.setColor(c);
        Composite comp = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setComposite(comp);
    }

    private static boolean isFirst(AbstractButton b) {
        if (b.getParent() != null && b.getParent().getComponentCount() > 1) {
            return b == b.getParent().getComponent(1);
        }
        return false;
    }

    private void paintIcon(Graphics g, AbstractButton b, Rectangle r) {
        boolean noText;
        Icon ic = this.getIconForState(b);
        boolean bl = noText = b.getText() == null || b.getText().length() == 0;
        if (ic != null) {
            int iconX = 0;
            int iconY = 0;
            int iconW = ic.getIconWidth();
            int iconH = ic.getIconHeight();
            if (iconW <= r.width && noText) {
                iconX = r.width / 2 - iconW / 2;
            }
            if (iconH <= r.height) {
                iconY = r.height / 2 - iconH / 2;
            }
            ic.paintIcon(b, g, iconX, iconY);
        }
    }

    private Icon getIconForState(AbstractButton b) {
        ButtonModel mdl = b.getModel();
        Icon result = null;
        if (!b.isEnabled()) {
            Icon icon = result = mdl.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            if (result == null && mdl.isSelected()) {
                result = b.getDisabledIcon();
            }
        } else {
            if (mdl.isArmed() && !mdl.isPressed() && (result = mdl.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon()) == null & mdl.isSelected()) {
                result = b.getRolloverIcon();
            }
            if (mdl.isPressed()) {
                result = b.getPressedIcon();
            } else if (mdl.isSelected()) {
                result = b.getSelectedIcon();
            }
        }
        if (result == null) {
            result = b.getIcon();
        }
        return result;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension result;
        int w;
        AbstractButton b = (AbstractButton)c;
        boolean noText = b.getText() == null || b.getText().length() == 0;
        Icon ic = this.getIconForState((AbstractButton)c);
        int n = w = AquaToolBarButtonUI.isFirst(b) ? 0 : 32;
        Dimension dimension = ic == null ? new Dimension(noText ? 32 : 0, 32) : (result = new Dimension(Math.max(w, ic.getIconWidth() + 1), Math.max(32, ic.getIconHeight() + 1)));
        if (!noText) {
            FontMetrics fm = this.fm;
            if (fm == null && c.getGraphicsConfiguration() != null) {
                fm = c.getGraphicsConfiguration().createCompatibleImage(1, 1).getGraphics().getFontMetrics(c.getFont());
            }
            if (fm == null) {
                fm = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(c.getFont());
            }
            result.width += fm.stringWidth(b.getText());
        }
        return result;
    }
}

