/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.LogExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.RLogExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private static Set misconfiguredServers = Collections.synchronizedSet(new HashSet());
    private final SearchHistoryPanel master;
    private File[] folders;
    private File[] files;
    private final SearchCriteriaPanel criteria;
    private List results = new ArrayList();

    public SearchExecutor(SearchHistoryPanel master) {
        this.master = master;
        File[] roots = master.getRoots();
        HashSet<String> printedWarnings = new HashSet<String>(1);
        HashSet<File> foldersSet = new HashSet<File>(roots.length);
        HashSet<File> filesSet = new HashSet<File>(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            boolean isMisconfiguredServer = false;
            try {
                String cvsRoot = Utils.getCVSRootFor(root);
                isMisconfiguredServer = misconfiguredServers.contains(cvsRoot);
                if (root.isDirectory() && isMisconfiguredServer && printedWarnings.add(cvsRoot)) {
                    this.showMisconfiguredServerWarning(cvsRoot);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (root.isFile() || isMisconfiguredServer) {
                filesSet.add(root);
                continue;
            }
            foldersSet.add(root);
        }
        this.files = filesSet.toArray(new File[filesSet.size()]);
        this.folders = foldersSet.toArray(new File[foldersSet.size()]);
        this.criteria = master.getCriteria();
    }

    public void run() {
        ExecutorSupport[] lexecutors;
        String from = this.criteria.getFrom();
        String to = this.criteria.getTo();
        Date fromDate = this.parseDate(from);
        Date toDate = this.parseDate(to);
        RlogCommand rcmd = new RlogCommand();
        LogCommand lcmd = new LogCommand();
        if (fromDate != null || toDate != null) {
            String dateFilter = "";
            if (fromDate != null) {
                dateFilter = fullDateFormat.format(fromDate);
            }
            dateFilter = dateFilter + "<=";
            if (toDate != null) {
                dateFilter = dateFilter + fullDateFormat.format(toDate);
            }
            rcmd.setDateFilter(dateFilter);
            lcmd.setDateFilter(dateFilter);
        } else if (from != null || to != null) {
            String revFilter = "";
            if (from != null) {
                revFilter = from;
            }
            revFilter = revFilter + ":";
            if (to != null) {
                revFilter = revFilter + to;
            }
            rcmd.setRevisionFilter(revFilter);
            lcmd.setRevisionFilter(revFilter);
        }
        rcmd.setNoTags(true);
        rcmd.setUserFilter(this.criteria.getUsername());
        lcmd.setUserFilter(this.criteria.getUsername());
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage((Class)SearchExecutor.class, (String)"BK0001"), false);
        ExecutorSupport[] rexecutors = this.folders.length > 0 ? RLogExecutor.splitCommand(rcmd, this.folders, null) : new RLogExecutor[]{};
        group.addExecutors(rexecutors);
        if (this.files.length > 0) {
            lcmd.setFiles(this.files);
            lexecutors = LogExecutor.splitCommand(lcmd, null);
        } else {
            lexecutors = new LogExecutor[]{};
        }
        group.addExecutors(lexecutors);
        ExecutorSupport[] frexecutors = rexecutors;
        ExecutorSupport[] flexecutors = lexecutors;
        Runnable action = new Runnable((RLogExecutor[])frexecutors, (LogExecutor[])flexecutors){
            private final /* synthetic */ RLogExecutor[] val$frexecutors;
            private final /* synthetic */ LogExecutor[] val$flexecutors;
            {
                this.val$frexecutors = rLogExecutorArray;
                this.val$flexecutors = logExecutorArray;
            }

            public void run() {
                List newResults = SearchExecutor.this.processResults(this.val$frexecutors, this.val$flexecutors);
                SearchExecutor.this.results.addAll(newResults);
                if (SearchExecutor.this.testForRLogFailures(this.val$frexecutors)) {
                    SearchExecutor.this.run();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchExecutor.this.master.setResults(SearchExecutor.this.results);
                    }
                });
            }
        };
        group.addBarrier(action);
        group.execute();
    }

    private boolean testForRLogFailures(RLogExecutor[] executors) {
        HashSet<File> failedFiles = new HashSet<File>();
        HashSet<String> printedWarnings = new HashSet<String>(1);
        for (int i = 0; i < executors.length; ++i) {
            RLogExecutor executor = executors[i];
            if (!executor.hasFailedOnSymbolicLink()) continue;
            try {
                String cvsRoot = Utils.getCVSRootFor(executor.getFile());
                if (printedWarnings.add(cvsRoot)) {
                    this.showMisconfiguredServerWarning(cvsRoot);
                }
                misconfiguredServers.add(cvsRoot);
            }
            catch (IOException e) {
                // empty catch block
            }
            failedFiles.add(executor.getFile());
        }
        if (failedFiles.size() > 0) {
            this.files = failedFiles.toArray(new File[failedFiles.size()]);
            this.folders = new File[0];
            return true;
        }
        return false;
    }

    private void showMisconfiguredServerWarning(String cvsRoot) {
        String relNotesUrl = "http://javacvs.netbeans.org/release/5.0";
        ClientRuntime runtime = CvsVersioningSystem.getInstance().getClientRuntime(cvsRoot);
        runtime.log(NbBundle.getMessage((Class)SearchExecutor.class, (String)"MSG_SymlinkWarning1") + "\n", null);
        runtime.log(NbBundle.getMessage((Class)SearchExecutor.class, (String)"MSG_SymlinkWarning2", (Object)"http://javacvs.netbeans.org/release/5.0") + "\n", new OutputListener(){

            public void outputLineSelected(OutputEvent ev) {
            }

            public void outputLineAction(OutputEvent ev) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://javacvs.netbeans.org/release/5.0"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }

            public void outputLineCleared(OutputEvent ev) {
            }
        });
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)SearchExecutor.class, (String)"MSG_StatusSymlinkWarning"));
    }

    private List processResults(RLogExecutor[] rexecutors, LogExecutor[] lexecutors) {
        ExecutorSupport executor;
        int i;
        ArrayList log = new ArrayList(200);
        for (i = 0; i < rexecutors.length; ++i) {
            executor = rexecutors[i];
            log.addAll(((RLogExecutor)executor).getLogEntries());
        }
        for (i = 0; i < lexecutors.length; ++i) {
            executor = lexecutors[i];
            log.addAll(((LogExecutor)executor).getLogEntries());
        }
        String commitMessage = this.criteria.getCommitMessage();
        ArrayList newResults = new ArrayList(log.size());
        Iterator i2 = log.iterator();
        while (i2.hasNext()) {
            LogInformation info = (LogInformation)i2.next();
            newResults.addAll(info.getRevisionList());
        }
        if (commitMessage != null) {
            i2 = newResults.iterator();
            while (i2.hasNext()) {
                LogInformation.Revision revision = (LogInformation.Revision)i2.next();
                String msg = revision.getMessage();
                if (msg.indexOf(commitMessage) != -1) continue;
                i2.remove();
            }
        }
        return newResults;
    }

    private Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        for (int i = 0; i < dateFormats.length; ++i) {
            DateFormat dateformat = dateFormats[i];
            try {
                return dateformat.parse(s);
            }
            catch (ParseException e) {
                continue;
            }
        }
        return null;
    }
}

