/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

public class ProjectUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProjectUtils() {
    }

    public static ProjectInformation getInformation(Project p) {
        ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
        if (pi != null) {
            return pi;
        }
        return new BasicInformation(p);
    }

    public static Sources getSources(Project p) {
        Sources s = (Sources)p.getLookup().lookup(Sources.class);
        if (s != null) {
            return s;
        }
        return GenericSources.genericOnly(p);
    }

    public static boolean hasSubprojectCycles(final Project master, final Project candidate) {
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                return ProjectUtils.visit(new HashSet(), master, master, candidate);
            }
        });
    }

    private static boolean visit(Set encountered, Project curr, Project master, Project candidate) {
        if (!encountered.add(curr)) {
            return true;
        }
        SubprojectProvider spp = (SubprojectProvider)curr.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            Iterator children = spp.getSubprojects().iterator();
            while (children.hasNext()) {
                Project child = (Project)children.next();
                if (candidate == child) {
                    candidate = null;
                }
                if (!ProjectUtils.visit(encountered, child, master, candidate)) continue;
                return true;
            }
        }
        if (candidate != null && curr == master && ProjectUtils.visit(encountered, candidate, master, candidate)) {
            return true;
        }
        if (!$assertionsDisabled && !encountered.contains(curr)) {
            throw new AssertionError();
        }
        encountered.remove(curr);
        return false;
    }

    static {
        $assertionsDisabled = !ProjectUtils.class.desiredAssertionStatus();
    }

    private static final class BasicInformation
    implements ProjectInformation {
        private final Project p;

        public BasicInformation(Project p) {
            this.p = p;
        }

        public String getName() {
            try {
                return this.p.getProjectDirectory().getURL().toExternalForm();
            }
            catch (FileStateInvalidException e) {
                return e.toString();
            }
        }

        public String getDisplayName() {
            return this.p.getProjectDirectory().getNameExt();
        }

        public Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/projectapi/resources/empty.gif"));
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public Project getProject() {
            return this.p;
        }
    }
}

