/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleFactory;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public class WebModules
implements WebModuleProvider,
AntProjectListener,
ClassPathProvider {
    private ArrayList modules = new ArrayList();
    private HashMap cache = new HashMap();
    private Project project;
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WebModules(Project project, AntProjectHelper helper, PropertyEvaluator evaluator) {
        if (!$assertionsDisabled && project == null) {
            throw new AssertionError();
        }
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        helper.addAntProjectListener((AntProjectListener)this);
    }

    public synchronized WebModule findWebModule(FileObject file) {
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (this.project.equals(owner)) {
            if (this.modules.isEmpty()) {
                this.readAuxData();
            }
            Iterator iter = this.modules.iterator();
            while (iter.hasNext()) {
                FFWebModule wm = (FFWebModule)iter.next();
                if (!wm.contais(file)) continue;
                if (this.cache.get(wm) == null) {
                    this.cache.put(wm, WebModuleFactory.createWebModule((WebModuleImplementation)wm));
                }
                return (WebModule)this.cache.get(wm);
            }
        }
        return null;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (owner != null && owner.equals(this.project)) {
            if (this.modules == null) {
                this.readAuxData();
            }
            Iterator iter = this.modules.iterator();
            while (iter.hasNext()) {
                FFWebModule wm = (FFWebModule)iter.next();
                if (!wm.contais(file)) continue;
                return wm.findClassPath(file, type);
            }
        }
        return null;
    }

    public synchronized void readAuxData() {
        this.modules.clear();
        this.cache.clear();
        AuxiliaryConfiguration aux = (AuxiliaryConfiguration)this.project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (!$assertionsDisabled && aux == null) {
            throw new AssertionError();
        }
        Element web = aux.getConfigurationFragment("web-data", "http://www.netbeans.org/ns/freeform-project-web/1", true);
        if (web == null) {
            return;
        }
        List webModules = Util.findSubElements((Element)web);
        Iterator it = webModules.iterator();
        while (it.hasNext()) {
            Element webModulesEl = (Element)it.next();
            if (!$assertionsDisabled && !webModulesEl.getLocalName().equals("web-module")) {
                throw new AssertionError(webModulesEl);
            }
            FileObject docRootFO = this.getFile(webModulesEl, "doc-root");
            Element j2eeSpecEl = Util.findElement((Element)webModulesEl, (String)"j2ee-spec-level", (String)"http://www.netbeans.org/ns/freeform-project-web/1");
            String j2eeSpec = j2eeSpecEl == null ? null : this.evaluator.evaluate(Util.findText((Element)j2eeSpecEl));
            Element contextPathEl = Util.findElement((Element)webModulesEl, (String)"context-path", (String)"http://www.netbeans.org/ns/freeform-project-web/1");
            String contextPathText = contextPathEl == null ? null : Util.findText((Element)contextPathEl);
            String contextPath = contextPathText == null ? null : this.evaluator.evaluate(contextPathText);
            Element classpathEl = Util.findElement((Element)webModulesEl, (String)"classpath", (String)"http://www.netbeans.org/ns/freeform-project-web/1");
            FileObject[] sources = this.getSources();
            ClassPath cp = classpathEl == null ? null : this.createClasspath(classpathEl, sources);
            this.modules.add(new FFWebModule(docRootFO, j2eeSpec, contextPath, sources, cp));
        }
    }

    private FileObject getFile(Element parent, String fileElName) {
        Element el = Util.findElement((Element)parent, (String)fileElName, (String)"http://www.netbeans.org/ns/freeform-project-web/1");
        String fname = Util.findText((Element)el);
        String locationEval = this.evaluator.evaluate(fname);
        if (locationEval != null) {
            File locationFile = this.helper.resolveFile(locationEval);
            return FileUtil.toFileObject((File)locationFile);
        }
        return null;
    }

    private FileObject[] getSources() {
        SourceGroup[] sg = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        HashSet<FileObject> srcRootSet = new HashSet<FileObject>();
        for (int i = 0; i < sg.length; ++i) {
            URL entry;
            try {
                entry = sg[i].getRootFolder().getURL();
            }
            catch (FileStateInvalidException x) {
                throw new AssertionError((Object)x);
            }
            SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)entry);
            FileObject[] srcForBin = res.getRoots();
            for (int j = 0; j < srcForBin.length; ++j) {
                srcRootSet.add(srcForBin[j]);
            }
        }
        FileObject[] roots = new FileObject[sg.length];
        for (int i = 0; i < sg.length; ++i) {
            roots[i] = sg[i].getRootFolder();
        }
        return roots;
    }

    private ClassPath createClasspath(Element classpathEl, FileObject[] sources) {
        int i;
        String cpEval;
        String cp = Util.findText((Element)classpathEl);
        if (cp == null) {
            cp = "";
        }
        if ((cpEval = this.evaluator.evaluate(cp)) == null) {
            return null;
        }
        String[] path = PropertyUtils.tokenizePath((String)cpEval);
        HashSet<File> entries = new HashSet<File>();
        for (i = 0; i < path.length; ++i) {
            entries.add(this.helper.resolveFile(path[i]));
        }
        if (entries.size() == 0) {
            for (i = 0; i < sources.length; ++i) {
                entries.add(FileUtil.toFile((FileObject)sources[i]));
            }
        }
        URL[] pathURL = new URL[entries.size()];
        int i2 = 0;
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            URL entry;
            File entryFile = (File)it.next();
            try {
                entry = entryFile.toURI().toURL();
                if (FileUtil.isArchiveFile((URL)entry)) {
                    entry = FileUtil.getArchiveRoot((URL)entry);
                } else {
                    String s = entry.toExternalForm();
                    if (!s.endsWith("/")) {
                        entry = new URL(s + '/');
                    }
                }
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
            pathURL[i2++] = entry;
        }
        return ClassPathSupport.createClassPath((URL[])pathURL);
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.readAuxData();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    static {
        $assertionsDisabled = !WebModules.class.desiredAssertionStatus();
    }

    private final class FFWebModule
    implements WebModuleImplementation {
        public static final String FOLDER_WEB_INF = "WEB-INF";
        public static final String FILE_DD = "web.xml";
        private FileObject docRootFO;
        private FileObject[] sourcesFOs;
        private ClassPath webClassPath;
        private ClassPath javaSourcesClassPath;
        private ClassPath composedClassPath = null;
        private String j2eeSpec;
        private String contextPath;

        FFWebModule(FileObject docRootFO, String j2eeSpec, String contextPath, FileObject[] sourcesFOs, ClassPath classPath) {
            this.docRootFO = docRootFO;
            this.j2eeSpec = j2eeSpec;
            this.contextPath = contextPath == null ? "" : contextPath;
            this.sourcesFOs = sourcesFOs;
            this.webClassPath = classPath == null ? ClassPathSupport.createClassPath((List)Collections.EMPTY_LIST) : classPath;
            this.javaSourcesClassPath = sourcesFOs == null ? ClassPathSupport.createClassPath((List)Collections.EMPTY_LIST) : ClassPathSupport.createClassPath((FileObject[])sourcesFOs);
        }

        boolean contais(FileObject fo) {
            if (this.docRootFO == fo || FileUtil.isParentOf((FileObject)this.docRootFO, (FileObject)fo)) {
                return true;
            }
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                if (this.sourcesFOs[i] != fo && !FileUtil.isParentOf((FileObject)this.sourcesFOs[i], (FileObject)fo)) continue;
                return true;
            }
            return false;
        }

        public FileObject getDocumentBase() {
            return this.docRootFO;
        }

        public ClassPath findClassPath(FileObject file, String type) {
            int fileType = this.getType(file);
            if (fileType == 0) {
                if (type != "classpath/source") {
                    return null;
                }
                return this.javaSourcesClassPath;
            }
            if (fileType == 1) {
                if (this.composedClassPath == null) {
                    int i;
                    HashSet<FileObject> all = new HashSet<FileObject>();
                    FileObject[] javaRoots = null;
                    for (i = 0; i < this.sourcesFOs.length; ++i) {
                        javaRoots = ClassPath.getClassPath((FileObject)this.sourcesFOs[i], (String)type).getRoots();
                        for (int j = 0; j < javaRoots.length; ++j) {
                            if (all.contains(javaRoots[j])) continue;
                            all.add(javaRoots[j]);
                        }
                    }
                    for (i = 0; i < this.webClassPath.getRoots().length; ++i) {
                        if (all.contains(this.webClassPath.getRoots()[i])) continue;
                        all.add(this.webClassPath.getRoots()[i]);
                    }
                    FileObject[] roots = new FileObject[all.size()];
                    int i2 = 0;
                    Iterator it = all.iterator();
                    while (it.hasNext()) {
                        roots[i2++] = (FileObject)it.next();
                    }
                    this.composedClassPath = ClassPathSupport.createClassPath((FileObject[])roots);
                }
                return this.composedClassPath;
            }
            return this.webClassPath;
        }

        public String getJ2eePlatformVersion() {
            return this.j2eeSpec;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("web module in freeform project\n\tdoc root:" + this.docRootFO.getPath() + "\n\tcontext path:" + this.contextPath + "\n\tj2ee version:" + this.j2eeSpec);
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                sb.append("\n\tsource root:" + this.sourcesFOs[i].getPath());
            }
            return sb.toString();
        }

        public FileObject getDeploymentDescriptor() {
            FileObject winf = this.getWebInf();
            if (winf == null) {
                return null;
            }
            return winf.getFileObject(FILE_DD);
        }

        public FileObject getWebInf() {
            return this.getDocumentBase().getFileObject(FOLDER_WEB_INF);
        }

        public FileObject[] getJavaSources() {
            return this.sourcesFOs;
        }

        private int getType(FileObject file) {
            FileObject dir = this.getDocumentBase();
            if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
                return 1;
            }
            for (int i = 0; i < this.sourcesFOs.length; ++i) {
                FileObject root = this.sourcesFOs[i];
                if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                return 0;
            }
            return -1;
        }
    }
}

