/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IndexBuilder
implements Runnable,
ChangeListener {
    private static final String[] INDEX_FILE_NAMES = new String[]{"overview-summary.html", "index.html", "index.htm"};
    private static IndexBuilder INSTANCE;
    private static RequestProcessor.Task task;
    private static final ErrorManager err;
    private Reference cachedData;
    private JavadocRegistry jdocRegs;
    Map filesystemInfo = Collections.EMPTY_MAP;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$search$IndexBuilder;

    private IndexBuilder() {
        this.jdocRegs = JavadocRegistry.getDefault();
        this.jdocRegs.addChangeListener(this);
        if (err.isLoggable(1)) {
            err.log("new IndexBuilder");
        }
    }

    public static synchronized IndexBuilder getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new IndexBuilder();
        IndexBuilder.scheduleTask();
        return INSTANCE;
    }

    public void run() {
        this.cachedData = null;
        this.refreshIndex();
    }

    public void stateChanged(ChangeEvent event) {
        IndexBuilder.scheduleTask();
    }

    public List[] getIndices() {
        List[] data;
        task.waitFinished();
        if (this.cachedData != null && (data = (List[])this.cachedData.get()) != null) {
            if (err.isLoggable(1)) {
                err.log("getIndices (cached)");
            }
            return data;
        }
        if (err.isLoggable(1)) {
            err.log("getIndices");
        }
        Map m = this.filesystemInfo;
        Iterator it = m.entrySet().iterator();
        Collator c = Collator.getInstance();
        class Pair
        implements Comparable {
            public String display;
            public FileObject fo;
            private final /* synthetic */ Collator val$c;

            Pair(Collator collator) {
                this.val$c = collator;
            }

            public int compareTo(Object o) {
                return this.val$c.compare(this.display, ((Pair)o).display);
            }
        }
        TreeSet<Pair> pairs = new TreeSet<Pair>();
        for (int i = 0; i < m.size(); ++i) {
            Map.Entry e = it.next();
            FileObject f = (FileObject)e.getKey();
            Info info = (Info)e.getValue();
            FileObject fo = f.getFileObject(info.indexFileName);
            if (fo == null) continue;
            Pair p = new Pair(c);
            p.display = info.title;
            p.fo = fo;
            pairs.add(p);
        }
        ArrayList<String> display = new ArrayList<String>(pairs.size());
        ArrayList<FileObject> fos = new ArrayList<FileObject>(pairs.size());
        it = pairs.iterator();
        while (it.hasNext()) {
            Pair p = (Pair)((Object)it.next());
            display.add(p.display);
            fos.add(p.fo);
        }
        List[] data2 = new List[]{display, fos};
        this.cachedData = new WeakReference<List[]>(data2);
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIndex() {
        Map oldMap;
        if (err.isLoggable(1)) {
            err.log("refreshIndex");
        }
        IndexBuilder indexBuilder = this;
        synchronized (indexBuilder) {
            oldMap = this.filesystemInfo;
        }
        FileObject[] docRoots = this.jdocRegs.getDocRoots();
        WeakHashMap<FileObject, Info> m = new WeakHashMap<FileObject, Info>();
        for (int ifCount = 0; ifCount < docRoots.length; ++ifCount) {
            FileObject packageList;
            FileObject fo = docRoots[ifCount];
            Info oldInfo = (Info)oldMap.get(fo);
            if (oldInfo != null) {
                m.put(fo, oldInfo);
                continue;
            }
            FileObject index = null;
            for (int i = 0; i < INDEX_FILE_NAMES.length && (index = fo.getFileObject(INDEX_FILE_NAMES[i])) == null; ++i) {
            }
            if ((index == null || index.getName().equals("index")) && (packageList = fo.getFileObject("package-list")) != null) {
                try {
                    InputStream is = packageList.getInputStream();
                    try {
                        String resName;
                        FileObject pindex;
                        BufferedReader r = new BufferedReader(new InputStreamReader(is));
                        String line = r.readLine();
                        if (line != null && r.readLine() == null && (pindex = fo.getFileObject(resName = line.replace('.', '/') + "/package-summary.html")) != null) {
                            index = pindex;
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
            if (index != null) {
                String title = this.parseTitle(index);
                if (title != null) {
                    JavadocSearchType st = this.jdocRegs.findSearchType(fo);
                    if (st == null) continue;
                    title = st.getOverviewTitleBase(title);
                }
                if ("".equals(title)) {
                    title = NbBundle.getMessage((Class)(class$org$netbeans$modules$javadoc$search$IndexBuilder == null ? IndexBuilder.class$("org.netbeans.modules.javadoc.search.IndexBuilder") : class$org$netbeans$modules$javadoc$search$IndexBuilder), (String)"FMT_NoOverviewTitle", (Object[])new Object[]{index.getPath(), fo.getName(), fo.getName()});
                }
                Info info = new Info();
                info.title = title == null ? fo.getName() : title;
                info.indexFileName = FileUtil.getRelativePath((FileObject)fo, (FileObject)index);
                m.put(fo, info);
            }
            IndexBuilder indexBuilder2 = this;
            synchronized (indexBuilder2) {
                this.filesystemInfo = m;
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseTitle(FileObject html) {
        String title = null;
        try {
            BufferedInputStream is = new BufferedInputStream(html.getInputStream(), 1024);
            SimpleTitleParser tp = new SimpleTitleParser(is);
            try {
                tp.parse();
                title = tp.getTitle();
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        if (title == null) {
            title = FileUtil.getFileDisplayName((FileObject)html);
        }
        return title;
    }

    private static synchronized void scheduleTask() {
        if (task == null) {
            task = new RequestProcessor("Javadoc Index Builder").create((Runnable)IndexBuilder.getDefault());
        }
        task.schedule(100);
    }

    static {
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexBuilder");
    }

    static final class SimpleTitleParser {
        private char cc;
        private InputStream is;
        private String charset;
        private String title;
        private int state = 0;
        private static final int CONTINUE = 0;
        private static final int EXIT = 0;

        SimpleTitleParser(InputStream is) {
            this.is = is;
        }

        public String getTitle() {
            return this.title;
        }

        public void parse() throws IOException {
            this.readNext();
            block4: while (this.state == 0) {
                switch (this.cc) {
                    case '<': {
                        this.handleOpenBrace();
                        continue block4;
                    }
                    case '\uffff': {
                        return;
                    }
                }
                this.readNext();
            }
        }

        private void readNext() throws IOException {
            this.cc = (char)this.is.read();
        }

        private void handleOpenBrace() throws IOException {
            StringBuffer sb = new StringBuffer();
            block5: while (true) {
                this.readNext();
                switch (this.cc) {
                    case '>': {
                        String tag = sb.toString().toLowerCase();
                        if (tag.startsWith("body")) {
                            this.state = 0;
                            return;
                        }
                        if (tag.startsWith("meta")) {
                            this.handleMetaTag(tag);
                            return;
                        }
                        if (tag.startsWith("title")) {
                            this.handleTitleTag();
                            return;
                        }
                        return;
                    }
                    case '\uffff': {
                        return;
                    }
                    case ' ': {
                        if (sb.length() == 0) continue block5;
                    }
                    default: {
                        sb.append(this.cc);
                    }
                }
            }
        }

        private void handleMetaTag(String txt) {
            int offset;
            String name = "";
            String value = "";
            char[] txts = txt.toCharArray();
            int start = offset = 5;
            int state = 0;
            while (offset < txts.length) {
                char tc = txt.charAt(offset);
                if (tc == '=' && state == 0) {
                    name = String.valueOf(txts, start, offset++ - start).trim();
                    state = 1;
                    continue;
                }
                if (state == 1 && (tc == '\"' || tc == '\'')) {
                    start = ++offset;
                    state = 2;
                    continue;
                }
                if (state == 2 && (tc == '\"' || tc == '\'')) {
                    value = String.valueOf(txts, start, offset++ - start);
                    if ("content".equals(name)) break;
                    name = "";
                    state = 0;
                    start = offset;
                    continue;
                }
                ++offset;
            }
            StringTokenizer tk = new StringTokenizer(value, ";");
            while (tk.hasMoreTokens()) {
                String str = tk.nextToken().trim();
                if (!str.startsWith("charset") || (str = str.substring(7).trim()).charAt(0) != '=') continue;
                this.charset = str.substring(1).trim();
                return;
            }
        }

        private void handleTitleTag() throws IOException {
            byte[] buf = new byte[200];
            int offset = 0;
            while (true) {
                this.readNext();
                switch (this.cc) {
                    case '\uffff': {
                        return;
                    }
                    case '>': {
                        if (!"</title".equals(new String(buf, offset - 7, 7).toLowerCase())) break;
                        this.state = 0;
                        this.title = this.charset == null ? new String(buf, 0, offset - 7).trim() : new String(buf, 0, offset - 7, this.charset).trim();
                        return;
                    }
                }
                this.cc = (char)(this.cc == '\n' || this.cc == '\r' ? 32 : (int)this.cc);
                if (offset == buf.length) {
                    buf = SimpleTitleParser.enlarge(buf);
                }
                buf[offset++] = (byte)this.cc;
            }
        }

        private static byte[] enlarge(byte[] b) {
            byte[] b2 = new byte[b.length + 200];
            for (int i = 0; i < b.length; ++i) {
                b2[i] = b[i];
            }
            return b2;
        }
    }

    private static class Info {
        String title;
        String indexFileName;

        private Info() {
        }
    }
}

