/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeCDATASection;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeText;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class WritableXMLFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Attr,
AbstractFileSystem.Change,
AbstractFileSystem.Info,
AbstractFileSystem.List,
FileChangeListener,
PropertyChangeListener {
    private final TreeEditorCookie cookie;
    private TreeDocumentRoot doc;
    private URL location;
    private String suffix;
    private final FileChangeListener fileChangeListener;
    private ClassPath classpath;
    private final Set orderAbsorbers = new HashSet();
    private static final int INDENT_STEP = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WritableXMLFileSystem(URL location, TreeEditorCookie cookie, ClassPath classpath) {
        this.attr = this;
        this.change = this;
        this.info = this;
        this.list = this;
        this.cookie = cookie;
        try {
            this.doc = cookie.openDocumentRoot();
        }
        catch (TreeException e) {
            Util.err.notify(1, (Throwable)e);
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        cookie.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cookie));
        this.setLocation(location);
        this.setClasspath(classpath);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("WritableXMLFileSystem is not persistent");
    }

    private void setLocation(URL location) {
        String u = location.toExternalForm();
        if (u.endsWith("/")) {
            throw new IllegalArgumentException(u);
        }
        this.location = location;
    }

    private void setClasspath(ClassPath classpath) {
        this.classpath = classpath;
    }

    public String getDisplayName() {
        FileObject fo = URLMapper.findFileObject((URL)this.location);
        if (fo != null) {
            return FileUtil.getFileDisplayName((FileObject)fo);
        }
        return this.location.toExternalForm();
    }

    public boolean isReadOnly() {
        return false;
    }

    private TreeElement getRootElement() {
        if (this.doc == null) {
            return null;
        }
        Iterator it = this.doc.getChildNodes().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof TreeElement)) continue;
            return (TreeElement)next;
        }
        return null;
    }

    private TreeElement findElement(String name) {
        return WritableXMLFileSystem.findElementIn(this.getRootElement(), name);
    }

    private static TreeElement findElementIn(TreeElement el, String name) {
        String remainder;
        String nextName;
        if (el == null) {
            return null;
        }
        if (name.equals("")) {
            return el;
        }
        int idx = name.indexOf(47);
        if (idx == -1) {
            nextName = name;
            remainder = "";
        } else {
            nextName = name.substring(0, idx);
            remainder = name.substring(idx + 1);
        }
        TreeElement subel = null;
        Iterator it = el.getChildNodes(TreeElement.class).iterator();
        while (it.hasNext()) {
            TreeAttribute attr;
            TreeElement e = (TreeElement)it.next();
            if (!e.getLocalName().equals("file") && !e.getLocalName().equals("folder") || (attr = e.getAttribute("name")) == null || !attr.getValue().equals(nextName)) continue;
            subel = e;
            break;
        }
        return WritableXMLFileSystem.findElementIn(subel, remainder);
    }

    public boolean folder(String name) {
        TreeElement el = this.findElement(name);
        if (el == null) {
            return false;
        }
        boolean res = el.getLocalName().equals("folder");
        return res;
    }

    public String[] children(String f) {
        TreeElement el = this.findElement(f);
        if (el == null) {
            return new String[0];
        }
        Iterator it = el.getChildNodes(TreeElement.class).iterator();
        ArrayList<String> kids = new ArrayList<String>();
        HashSet<String> allNames = new HashSet<String>();
        while (it.hasNext()) {
            String name;
            TreeAttribute attr;
            TreeElement sub = (TreeElement)it.next();
            if (!sub.getLocalName().equals("file") && !sub.getLocalName().equals("folder") || (attr = sub.getAttribute("name")) == null || !allNames.add(name = attr.getValue())) continue;
            kids.add(name);
        }
        return kids.toArray(new String[kids.size()]);
    }

    private byte[] getContentsOf(String name) throws FileNotFoundException {
        TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        TreeAttribute attr = el.getAttribute("url");
        if (attr != null) {
            try {
                URL[] u = LayerUtils.currentify(new URL(this.location, attr.getValue()), this.suffix, this.classpath);
                URLConnection conn = u[0].openConnection();
                conn.connect();
                InputStream is = conn.getInputStream();
                byte[] buf = new byte[conn.getContentLength()];
                if (is.read(buf) != buf.length) {
                    throw new IOException("wrong content length");
                }
                FileObject fo = URLMapper.findFileObject((URL)u[0]);
                if (fo != null) {
                    fo.removeFileChangeListener(this.fileChangeListener);
                    fo.addFileChangeListener(this.fileChangeListener);
                }
                return buf;
            }
            catch (IOException ioe) {
                throw new FileNotFoundException(ioe.getMessage());
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator it = el.getChildNodes().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof TreeCDATASection) {
                buf.append(((TreeCDATASection)o).getData());
                continue;
            }
            if (!(o instanceof TreeText)) continue;
            buf.append(((TreeText)o).getData().trim());
        }
        try {
            return buf.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new FileNotFoundException(uee.getMessage());
        }
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        return new ByteArrayInputStream(this.getContentsOf(name));
    }

    public OutputStream outputStream(final String name) throws IOException {
        final TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        TreeAttribute attr = el.getAttribute("url");
        if (attr != null) {
            String u = attr.getValue();
            if (URI.create(u).isAbsolute()) {
                throw new IOException(name);
            }
            FileObject external = URLMapper.findFileObject((URL)new URL(this.location, u));
            if (external == null) {
                throw new FileNotFoundException(name);
            }
            final FileLock lock = external.lock();
            return new FilterOutputStream(external.getOutputStream(lock)){

                public void close() throws IOException {
                    super.close();
                    lock.releaseLock();
                }
            };
        }
        return new ByteArrayOutputStream(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                block11: {
                    super.close();
                    byte[] contents = this.toByteArray();
                    FileObject parent = WritableXMLFileSystem.this.findLayerParent();
                    String externalName = LayerUtils.findGeneratedName(parent, name);
                    if (!$assertionsDisabled && externalName.indexOf(47) != -1) {
                        throw new AssertionError((Object)externalName);
                    }
                    FileObject externalFile = parent.createData(externalName);
                    FileLock lock = externalFile.lock();
                    try {
                        OutputStream os = externalFile.getOutputStream(lock);
                        try {
                            os.write(contents);
                        }
                        finally {
                            os.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                    externalFile.addFileChangeListener(WritableXMLFileSystem.this.fileChangeListener);
                    try {
                        el.addAttribute("url", externalName);
                    }
                    catch (ReadOnlyException e) {
                        throw (IOException)new IOException(e.toString()).initCause(e);
                    }
                    catch (InvalidArgumentException e) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError((Object)e);
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$layers$WritableXMLFileSystem == null ? (class$org$netbeans$modules$apisupport$project$layers$WritableXMLFileSystem = WritableXMLFileSystem.class$("org.netbeans.modules.apisupport.project.layers.WritableXMLFileSystem")) : class$org$netbeans$modules$apisupport$project$layers$WritableXMLFileSystem).desiredAssertionStatus();
            }
        };
    }

    private FileObject findLayerParent() throws IOException {
        String loc = this.location.toExternalForm();
        int slash = loc.lastIndexOf(47);
        if (!$assertionsDisabled && slash == -1) {
            throw new AssertionError((Object)loc);
        }
        FileObject parent = URLMapper.findFileObject((URL)new URL(loc.substring(0, slash + 1)));
        if (parent == null) {
            throw new IOException(loc);
        }
        return parent;
    }

    private void createFileOrFolder(String name, boolean folder) throws IOException {
        String baseName;
        String parentName;
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            parentName = "";
            baseName = name;
        } else {
            parentName = name.substring(0, idx);
            baseName = name.substring(idx + 1);
        }
        TreeElement el = this.findElement(parentName);
        if (el == null) {
            throw new FileNotFoundException(parentName);
        }
        try {
            TreeElement nue = new TreeElement(folder ? "folder" : "file", true);
            nue.addAttribute("name", baseName);
            WritableXMLFileSystem.appendWithIndent(el, (TreeChild)nue);
        }
        catch (InvalidArgumentException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
        }
        catch (ReadOnlyException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    public void createFolder(String name) throws IOException {
        this.createFileOrFolder(name, true);
    }

    public void createData(String name) throws IOException {
        this.createFileOrFolder(name, false);
    }

    public void delete(String name) throws IOException {
        FileObject externalFile;
        TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        TreeAttribute externalName = el.getAttribute("url");
        if (externalName != null && !URI.create(externalName.getValue()).isAbsolute() && (externalFile = URLMapper.findFileObject((URL)new URL(this.location, externalName.getValue()))) != null) {
            externalFile.removeFileChangeListener(this.fileChangeListener);
            externalFile.delete();
        }
        try {
            WritableXMLFileSystem.deleteWithIndent((TreeChild)el);
        }
        catch (ReadOnlyException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    public void rename(String oldName, String newName) throws IOException {
        block7: {
            TreeElement el = this.findElement(oldName);
            if (el == null) {
                throw new FileNotFoundException(oldName);
            }
            int idx = newName.lastIndexOf(47) + 1;
            if (idx != oldName.lastIndexOf(47) + 1 || !oldName.substring(0, idx).equals(newName.substring(0, idx))) {
                throw new IOException("Cannot rename to a different dir: " + oldName + " -> " + newName);
            }
            String newBaseName = newName.substring(idx);
            if (!$assertionsDisabled && newBaseName.indexOf(47) != -1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && newBaseName.length() <= 0) {
                throw new AssertionError();
            }
            try {
                el.getAttribute("name").setValue(newBaseName);
            }
            catch (ReadOnlyException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            catch (InvalidArgumentException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e);
            }
        }
    }

    public Enumeration attributes(String name) {
        TreeElement el = this.findElement(name);
        if (el == null) {
            return Enumerations.empty();
        }
        ArrayList<String> l = new ArrayList<String>(10);
        Iterator it = el.getChildNodes(TreeElement.class).iterator();
        while (it.hasNext()) {
            TreeAttribute attr;
            TreeElement sub = (TreeElement)it.next();
            if (!sub.getLocalName().equals("attr") || (attr = sub.getAttribute("name")) == null) continue;
            l.add(attr.getValue());
        }
        return Collections.enumeration(l);
    }

    public Object readAttribute(String name, String attrName) {
        if (attrName.equals("WritableXMLFileSystem.cp")) {
            return this.classpath;
        }
        if (attrName.equals("WritableXMLFileSystem.location")) {
            return this.location;
        }
        if (attrName.equals("DataFolder.Index.reorderable")) {
            return Boolean.TRUE;
        }
        TreeElement el = this.findElement(name);
        if (el == null) {
            return null;
        }
        boolean literal = false;
        if (attrName.startsWith("literal:")) {
            attrName = attrName.substring("literal:".length());
            literal = true;
        }
        Iterator it = el.getChildNodes(TreeElement.class).iterator();
        while (it.hasNext()) {
            TreeAttribute attr;
            TreeElement sub = (TreeElement)it.next();
            if (!sub.getLocalName().equals("attr") || (attr = sub.getAttribute("name")) == null || !attrName.equals(attr.getValue())) continue;
            try {
                String clazz;
                attr = sub.getAttribute("stringvalue");
                if (attr != null) {
                    String inStr = attr.getValue();
                    StringBuffer outStr = new StringBuffer(inStr.length());
                    for (int j = 0; j < inStr.length(); ++j) {
                        char ch = inStr.charAt(j);
                        if (ch == '\\' && inStr.charAt(j + 1) == 'u' && j + 5 < inStr.length()) {
                            String hex = inStr.substring(j + 2, j + 6);
                            try {
                                outStr.append((char)Integer.parseInt(hex, 16));
                                j += 5;
                            }
                            catch (NumberFormatException e) {
                                outStr.append(ch);
                            }
                            continue;
                        }
                        outStr.append(ch);
                    }
                    return outStr.toString();
                }
                attr = sub.getAttribute("boolvalue");
                if (attr != null) {
                    return Boolean.valueOf(attr.getValue());
                }
                attr = sub.getAttribute("urlvalue");
                if (attr != null) {
                    return new URL(attr.getValue());
                }
                attr = sub.getAttribute("newvalue");
                if (attr != null) {
                    clazz = attr.getValue();
                    if (!literal) continue;
                    return "new:" + clazz;
                }
                attr = sub.getAttribute("methodvalue");
                if (attr == null) continue;
                clazz = attr.getValue();
                if (!literal) continue;
                return "method:" + clazz;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void writeAttribute(String name, String attrName, Object v) throws IOException {
        if (v != null && v.getClass().getName().equals("org.openide.filesystems.MultiFileObject$VoidValue")) {
            v = null;
        }
        if (v == null && attrName.indexOf(47) != -1) {
            String mebbeOrder = name + '/' + attrName;
            if (this.orderAbsorbers.remove(mebbeOrder)) {
                return;
            }
            v = Boolean.FALSE;
        }
        if (name.indexOf(47) == -1) {
            Iterator it = this.orderAbsorbers.iterator();
            while (it.hasNext()) {
                String n = (String)it.next();
                if (!n.startsWith(name + '/')) continue;
                it.remove();
            }
        }
        if (attrName.equals("OpenIDE-Folder-Order") && v instanceof String) {
            ArrayList<Object> order = Collections.list(new StringTokenizer((String)v, "/"));
            if (!order.isEmpty()) {
                HashSet<String> myOwn = new HashSet<String>(Arrays.asList(this.children(name)));
                Iterator it = order.iterator();
                String prev = (String)it.next();
                while (it.hasNext()) {
                    String next = (String)it.next();
                    if (myOwn.contains(prev) || myOwn.contains(next)) {
                        this.writeAttribute(name, prev + '/' + next, Boolean.TRUE);
                    }
                    prev = next;
                }
            }
            for (int i = 0; i < order.size() - 1; ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    this.orderAbsorbers.add(name + '/' + (String)order.get(i) + '/' + (String)order.get(j));
                }
            }
            return;
        }
        TreeElement el = this.findElement(name);
        if (el == null) {
            throw new FileNotFoundException(name);
        }
        TreeElement existingAttr = null;
        Iterator it = el.getChildNodes(TreeElement.class).iterator();
        while (it.hasNext()) {
            TreeAttribute attr;
            TreeElement sub = (TreeElement)it.next();
            if (!sub.getLocalName().equals("attr") || (attr = sub.getAttribute("name")) == null || !attr.getValue().equals(attrName)) continue;
            existingAttr = sub;
            break;
        }
        try {
            TreeElement attr = new TreeElement("attr", true);
            attr.addAttribute("name", attrName);
            if (v instanceof String) {
                String inStr = (String)v;
                String newValueMagic = "newvalue:";
                String methodValueMagic = "methodvalue:";
                if (inStr.startsWith(newValueMagic)) {
                    attr.addAttribute("newvalue", inStr.substring(newValueMagic.length()));
                } else if (inStr.startsWith(methodValueMagic)) {
                    attr.addAttribute("methodvalue", inStr.substring(methodValueMagic.length()));
                } else {
                    StringBuffer outStr = new StringBuffer();
                    for (int i = 0; i < inStr.length(); ++i) {
                        char c = inStr.charAt(i);
                        if (Character.isISOControl(c) || c == '&' || c == '<' || c == '>' || c == '\"' || c == '\'') {
                            outStr.append(WritableXMLFileSystem.encodeChar(c));
                            continue;
                        }
                        outStr.append(c);
                    }
                    attr.addAttribute("stringvalue", outStr.toString());
                }
            } else if (v instanceof URL) {
                attr.addAttribute("urlvalue", ((URL)v).toExternalForm());
            } else if (v instanceof Boolean) {
                attr.addAttribute("boolvalue", v.toString());
            } else if (v instanceof Character) {
                attr.addAttribute("charvalue", v.toString());
            } else if (v instanceof Integer) {
                attr.addAttribute("intvalue", v.toString());
            } else if (v != null) {
                throw new UnsupportedOperationException("XXX: " + v);
            }
            if (v != null && existingAttr == null) {
                WritableXMLFileSystem.appendWithIndent(el, (TreeChild)attr);
            } else if (v != null) {
                el.replaceChild((TreeChild)existingAttr, (TreeChild)attr);
            } else if (existingAttr != null) {
                WritableXMLFileSystem.deleteWithIndent((TreeChild)existingAttr);
            }
        }
        catch (InvalidArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (ReadOnlyException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
    }

    private static String encodeChar(char ch) {
        String encChar = Integer.toString(ch, 16);
        return "\\u" + "0000".substring(0, "0000".length() - encChar.length()).concat(encChar);
    }

    public void renameAttributes(String oldName, String newName) {
    }

    public void deleteAttributes(String name) {
    }

    public boolean readOnly(String name) {
        return false;
    }

    public String mimeType(String name) {
        return null;
    }

    public long size(String name) {
        try {
            return this.getContentsOf(name).length;
        }
        catch (FileNotFoundException fnfe) {
            return 0L;
        }
    }

    public void markUnimportant(String name) {
    }

    public Date lastModified(String name) {
        FileObject external;
        TreeElement el = this.findElement(name);
        if (el == null) {
            return new Date(0L);
        }
        TreeAttribute attr = el.getAttribute("url");
        if (attr == null) {
            return new Date(0L);
        }
        String u = attr.getValue();
        if (URI.create(u).isAbsolute()) {
            return new Date(0L);
        }
        try {
            external = URLMapper.findFileObject((URL)new URL(this.location, u));
        }
        catch (MalformedURLException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
            return new Date(0L);
        }
        if (external == null) {
            return new Date(0L);
        }
        return external.lastModified();
    }

    public void lock(String name) throws IOException {
    }

    public void unlock(String name) {
    }

    private static void appendWithIndent(TreeElement parent, TreeChild child) throws ReadOnlyException {
        block8: {
            TreeElement doc = parent;
            int depth = -2;
            while (doc != null) {
                doc = doc.getParentNode();
                ++depth;
            }
            TreeChild position = WritableXMLFileSystem.insertBefore(parent, child);
            try {
                if (position != null) {
                    parent.insertBefore(child, position);
                    parent.insertBefore((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((depth + 1) * 4)), position);
                } else {
                    if (parent.hasChildNodes()) {
                        parent.appendChild((TreeChild)new TreeText(WritableXMLFileSystem.spaces(4)));
                    } else {
                        parent.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces((depth + 1) * 4)));
                    }
                    parent.appendChild(child);
                    parent.appendChild((TreeChild)new TreeText("\n" + WritableXMLFileSystem.spaces(depth * 4)));
                }
                parent.normalize();
                TreeElement childe = (TreeElement)child;
                if (childe.getQName().equals("attr") && childe.getAttribute("name").getValue().indexOf(47) != -1) {
                    WritableXMLFileSystem.resort(parent);
                }
            }
            catch (InvalidArgumentException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)e);
            }
        }
    }

    private static TreeChild insertBefore(TreeElement parent, TreeChild child) throws ReadOnlyException {
        if (!(child instanceof TreeElement)) {
            return null;
        }
        TreeElement childe = (TreeElement)child;
        if (childe.getQName().equals("file") || childe.getQName().equals("folder")) {
            String name = childe.getAttribute("name").getValue();
            Iterator it = parent.getChildNodes(TreeElement.class).iterator();
            while (it.hasNext()) {
                String kidname;
                TreeAttribute attr;
                TreeElement kid = (TreeElement)it.next();
                if (!kid.getQName().equals("file") && !kid.getQName().equals("folder") || (attr = kid.getAttribute("name")) == null || (kidname = attr.getValue()).compareTo(name) <= 0) continue;
                return kid;
            }
            return null;
        }
        if (childe.getQName().equals("attr")) {
            String name = childe.getAttribute("name").getValue();
            int slash = name.indexOf(47);
            if (slash == -1) {
                Iterator it = parent.getChildNodes(TreeElement.class).iterator();
                while (it.hasNext()) {
                    TreeElement kid = (TreeElement)it.next();
                    if (kid.getQName().equals("file") || kid.getQName().equals("folder")) {
                        return kid;
                    }
                    if (kid.getQName().equals("attr")) {
                        String kidname;
                        TreeAttribute attr = kid.getAttribute("name");
                        if (attr == null || (kidname = attr.getValue()).compareTo(name) <= 0) continue;
                        return kid;
                    }
                    throw new AssertionError((Object)("Weird child: " + kid.getQName()));
                }
                return null;
            }
            return null;
        }
        throw new AssertionError((Object)("Weird child: " + childe.getQName()));
    }

    private static void resort(TreeElement parent) throws ReadOnlyException {
        List orderedItems;
        class Item {
            public TreeElement child;

            Item() {
            }

            boolean isAttr() {
                return this.child.getQName().equals("attr");
            }

            String getName() {
                TreeAttribute attr = this.child.getAttribute("name");
                return attr != null ? attr.getValue() : "";
            }

            boolean isOrderingAttr() {
                return this.isAttr() && this.getName().indexOf(47) != -1;
            }

            String getFormer() {
                String n = this.getName();
                return n.substring(0, n.indexOf(47));
            }

            String getLatter() {
                String n = this.getName();
                return n.substring(n.indexOf(47) + 1);
            }
        }
        LinkedHashSet<Item> items = new LinkedHashSet<Item>();
        TreeSet<Integer> indices = new TreeSet<Integer>();
        for (int i = 0; i < parent.getChildrenNumber(); ++i) {
            TreeChild child = (TreeChild)parent.getChildNodes().get(i);
            if (!(child instanceof TreeElement)) continue;
            Item item = new Item();
            item.child = (TreeElement)child;
            items.add(item);
            indices.add(new Integer(i));
        }
        LinkedHashMap edges = new LinkedHashMap();
        LinkedHashMap<String, Item> filesAndFolders = new LinkedHashMap<String, Item>();
        LinkedHashMap<String, Item> attrs = new LinkedHashMap<String, Item>();
        LinkedHashSet<String> orderedFilesAndFolders = new LinkedHashSet<String>();
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            String name = item.getName();
            if (item.isAttr()) {
                attrs.put(name, item);
                if (!item.isOrderingAttr()) continue;
                orderedFilesAndFolders.add(item.getFormer());
                orderedFilesAndFolders.add(item.getLatter());
                continue;
            }
            filesAndFolders.put(name, item);
        }
        class NameComparator
        implements Comparator {
            NameComparator() {
            }

            public int compare(Object o1, Object o2) {
                Item i1 = (Item)o1;
                Item i2 = (Item)o2;
                return i1.getName().compareTo(i2.getName());
            }
        }
        TreeSet<Item> sortedAttrs = new TreeSet<Item>(new NameComparator());
        TreeSet<Item> sortedFilesAndFolders = new TreeSet<Item>(new NameComparator());
        LinkedHashSet<Item> orderableItems = new LinkedHashSet<Item>();
        it = items.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            String name = item.getName();
            if (item.isAttr()) {
                if (item.isOrderingAttr()) {
                    Item latter;
                    Item former = (Item)filesAndFolders.get(item.getFormer());
                    if (former != null) {
                        LinkedHashSet<Item> formerConstraints = (LinkedHashSet<Item>)edges.get(former);
                        if (formerConstraints == null) {
                            formerConstraints = new LinkedHashSet<Item>();
                            edges.put(former, formerConstraints);
                        }
                        formerConstraints.add(item);
                    }
                    if ((latter = (Item)filesAndFolders.get(item.getLatter())) != null) {
                        LinkedHashSet<Item> constraints = new LinkedHashSet<Item>();
                        constraints.add(latter);
                        edges.put(item, constraints);
                    }
                    orderableItems.add(item);
                    continue;
                }
                sortedAttrs.add(item);
                continue;
            }
            if (orderedFilesAndFolders.contains(name)) {
                orderableItems.add(item);
                continue;
            }
            sortedFilesAndFolders.add(item);
        }
        try {
            orderedItems = Utilities.topologicalSort(orderableItems, edges);
        }
        catch (TopologicalSortException e) {
            return;
        }
        it = items.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            parent.removeChild((TreeChild)item.child);
        }
        ArrayList<Item> allOrderedItems = new ArrayList<Item>(sortedAttrs);
        allOrderedItems.addAll(orderedItems);
        allOrderedItems.addAll(sortedFilesAndFolders);
        if (!$assertionsDisabled && !new HashSet(allOrderedItems).equals(items)) {
            throw new AssertionError();
        }
        it = allOrderedItems.iterator();
        Iterator indexIt = indices.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            int index = (Integer)indexIt.next();
            parent.insertChildAt((TreeChild)item.child, index);
        }
    }

    private static String spaces(int size) {
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = 32;
        }
        return new String(chars);
    }

    private static void deleteWithIndent(TreeChild child) throws ReadOnlyException {
        TreeElement parent;
        block12: {
            TreeChild next = child.getNextSibling();
            if (next instanceof TreeText && ((TreeText)next).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                next.removeFromContext();
            } else {
                TreeChild previous = child.getPreviousSibling();
                if (previous instanceof TreeText && ((TreeText)previous).getData().matches("(\r|\n|\r\n)[ \t]+")) {
                    previous.removeFromContext();
                }
            }
            parent = (TreeElement)child.getParentNode();
            TreeObjectList list = parent.getChildNodes();
            boolean kill = true;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o == child) continue;
                if (!(o instanceof TreeText)) {
                    kill = false;
                    break;
                }
                if (((TreeText)o).getData().trim().length() <= 0) continue;
                kill = false;
                break;
            }
            if (kill) {
                try {
                    if (parent.getParentNode() instanceof TreeDocumentRoot) {
                        it = list.iterator();
                        while (it.hasNext()) {
                            ((TreeChild)it.next()).removeFromContext();
                        }
                        parent.appendChild((TreeChild)new TreeText("\n"));
                    } else {
                        TreeElement parent2 = new TreeElement(parent.getQName(), true);
                        TreeAttribute attr = parent.getAttribute("name");
                        if (attr != null) {
                            parent2.addAttribute("name", attr.getValue());
                        }
                        TreeParentNode grandparent = parent.getParentNode();
                        grandparent.replaceChild((TreeChild)parent, (TreeChild)parent2);
                        parent = parent2;
                    }
                }
                catch (InvalidArgumentException e) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError((Object)e);
                }
            }
        }
        child.removeFromContext();
        parent.normalize();
    }

    public void fileDeleted(FileEvent fe) {
        this.someFileChange(fe);
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.someFileChange((FileEvent)fe);
    }

    public void fileChanged(FileEvent fe) {
        this.someFileChange(fe);
    }

    private void someFileChange(FileEvent fe) {
        this.refreshResource("", true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("documentRoot")) {
            return;
        }
        if (this.cookie.getStatus() == 1 || this.cookie.getStatus() == 0) {
            try {
                this.doc = this.cookie.openDocumentRoot();
                Enumeration e = this.existingFileObjects(this.getRoot());
                while (e.hasMoreElements()) {
                    FileObject fo = (FileObject)e.nextElement();
                    this.refreshResource(fo.getPath(), true);
                }
            }
            catch (TreeException e) {
                Util.err.notify(1, (Throwable)e);
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
    }

    static {
        $assertionsDisabled = !WritableXMLFileSystem.class.desiredAssertionStatus();
    }
}

