/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.blueprints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.j2ee.blueprints.catalog.SolutionsCatalog;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbcatalog;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbcategory;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbsolution;
import org.netbeans.modules.j2ee.blueprints.catalog.bpcatalogxmlparser.Nbwriteup;
import org.netbeans.modules.j2ee.blueprints.ui.AntialiasedJLabel;
import org.netbeans.modules.j2ee.blueprints.ui.BluePrintsTabPanel;
import org.netbeans.modules.j2ee.blueprints.ui.BrowseHistory;
import org.netbeans.modules.j2ee.blueprints.ui.BrowseHistoryToken;
import org.netbeans.modules.j2ee.blueprints.ui.CategoryTab;
import org.netbeans.modules.j2ee.blueprints.ui.DesignTab;
import org.netbeans.modules.j2ee.blueprints.ui.ExampleTab;
import org.netbeans.modules.j2ee.blueprints.ui.HomeTab;
import org.netbeans.modules.j2ee.blueprints.ui.SolutionTab;

public class BluePrintsPanel
extends JPanel {
    private JPanel categoryPnl;
    private JPanel designPnl;
    private JComboBox entryCbx;
    private JPanel examplePnl;
    private JPanel homePnl;
    private JPopupMenu jPopupMenu1;
    private JPanel solutionPnl;
    private JLabel sunLogoLbl;
    private JTabbedPane tabbedPnl;
    private JLabel titleLbl;
    private JPanel titlePanel;
    private JLabel titleSubLbl;
    private JPanel titleSubPnl;
    private JPanel toolbarPanel;
    private static final String UI_RESOURCES_URL = "/org/netbeans/modules/j2ee/blueprints/ui/resources";
    private static final String ICON_CATEGORY = "/org/netbeans/modules/j2ee/blueprints/ui/resources/category.gif";
    private static final String ICON_ARTICLE = "/org/netbeans/modules/j2ee/blueprints/ui/resources/article.gif";
    private static ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle");
    static final String CATALOG_RESOURCES_URL = "/org/netbeans/modules/j2ee/blueprints/catalog/resources";
    public static final String TAB_CATEGORY = "categoryPnl";
    public static final String TAB_SOLUTION = "solutionPnl";
    public static final String TAB_DESIGN = "designPnl";
    public static final String TAB_EXAMPLE = "examplePnl";
    public static final String TAB_HOME = "homePnl";
    public final HashMap TABS = new HashMap();
    private SolutionsCatalog solutionsCatalog = SolutionsCatalog.getInstance();
    private BrowseHistory history = new BrowseHistory();
    private BrowseHistoryToken historyToken = new BrowseHistoryToken();
    private boolean navigating = false;
    private int lastSelectedIndex = -1;

    public BluePrintsPanel() {
        this.initComponents();
        this.initTabs();
        this.initComboBox();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.titlePanel = new JPanel();
        this.sunLogoLbl = new JLabel();
        this.titleSubPnl = new JPanel();
        this.titleLbl = new AntialiasedJLabel();
        this.titleSubLbl = new AntialiasedJLabel();
        this.toolbarPanel = new JPanel();
        this.entryCbx = new JComboBox();
        this.tabbedPnl = new JTabbedPane();
        this.categoryPnl = new CategoryTab(this);
        this.solutionPnl = new SolutionTab(this);
        this.designPnl = new DesignTab(this);
        this.examplePnl = new ExampleTab(this);
        this.homePnl = new HomeTab(this);
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.titlePanel.setLayout(new GridBagLayout());
        this.titlePanel.setOpaque(false);
        this.sunLogoLbl.setBackground(new Color(89, 79, 191));
        this.sunLogoLbl.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/j2ee/blueprints/ui/resources/logo_sun.gif")));
        this.sunLogoLbl.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.titlePanel.add((Component)this.sunLogoLbl, gridBagConstraints);
        this.titleSubPnl.setLayout(new GridBagLayout());
        this.titleLbl.setBackground(new Color(251, 226, 73));
        this.titleLbl.setFont(new Font("Dialog", 1, 24));
        this.titleLbl.setForeground(new Color(89, 79, 191));
        this.titleLbl.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("NB_title"));
        this.titleLbl.setBorder(BorderFactory.createEmptyBorder(1, 12, 1, 1));
        this.titleLbl.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.titleSubPnl.add((Component)this.titleLbl, gridBagConstraints);
        this.titleSubLbl.setBackground(new Color(251, 226, 73));
        this.titleSubLbl.setForeground(new Color(89, 79, 191));
        this.titleSubLbl.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("NB_subtitle"));
        this.titleSubLbl.setBorder(BorderFactory.createEmptyBorder(1, 12, 1, 1));
        this.titleSubLbl.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.titleSubPnl.add((Component)this.titleSubLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.titlePanel.add((Component)this.titleSubPnl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 7, 12);
        this.add((Component)this.titlePanel, gridBagConstraints);
        this.toolbarPanel.setLayout(new GridBagLayout());
        this.toolbarPanel.setOpaque(false);
        this.entryCbx.setMaximumRowCount(16);
        this.entryCbx.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                BluePrintsPanel.this.entryCbxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.toolbarPanel.add((Component)this.entryCbx, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 7, 1, 7);
        this.add((Component)this.toolbarPanel, gridBagConstraints);
        this.tabbedPnl.addTab(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString(TAB_CATEGORY), this.categoryPnl);
        this.tabbedPnl.addTab(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString(TAB_SOLUTION), this.solutionPnl);
        this.tabbedPnl.addTab(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString(TAB_DESIGN), this.designPnl);
        this.tabbedPnl.addTab(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString(TAB_EXAMPLE), this.examplePnl);
        this.tabbedPnl.addTab(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString(TAB_HOME), this.homePnl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 12);
        this.add((Component)this.tabbedPnl, gridBagConstraints);
    }

    private void entryCbxItemStateChanged(ItemEvent evt) {
        if (!this.navigating && this.lastSelectedIndex != this.entryCbx.getSelectedIndex()) {
            this.lastSelectedIndex = this.entryCbx.getSelectedIndex();
            this.selectNewEntry();
        }
    }

    public Nbcategory getSelectedCategory() {
        Object entry = this.entryCbx.getSelectedItem();
        if (!(entry instanceof Nbcategory)) {
            int index = this.entryCbx.getSelectedIndex();
            do {
                entry = this.entryCbx.getItemAt(--index);
            } while (index > 0 && !(entry instanceof Nbcategory));
        }
        return (Nbcategory)entry;
    }

    public Nbsolution getSelectedArticle() {
        Object entry = this.entryCbx.getSelectedItem();
        return entry instanceof Nbsolution ? (Nbsolution)entry : null;
    }

    public String getExampleId() {
        String result = null;
        Nbsolution solution = this.getSelectedArticle();
        if (solution != null) {
            result = solution.getExampleId();
        }
        return result;
    }

    private void initTabs() {
        this.TABS.put(TAB_CATEGORY, this.categoryPnl);
        this.TABS.put(TAB_SOLUTION, this.solutionPnl);
        this.TABS.put(TAB_DESIGN, this.designPnl);
        this.TABS.put(TAB_EXAMPLE, this.examplePnl);
        this.TABS.put(TAB_HOME, this.homePnl);
        this.tabbedPnl.removeAll();
    }

    private void initComboBox() {
        this.entryCbx.setRenderer(new EntryListCellRenderer());
        this.entryCbx.setModel(new EntryComboBoxModel());
        this.entryCbx.setSelectedIndex(0);
        this.history.clear();
        this.updateTabs();
        this.historyToken = this.createBrowseHistoryToken();
    }

    private void selectNewEntry() {
        this.historyToken.setScrollPosition(this.getScrollPosition());
        this.historyToken.setTab(this.getSelectedTabName());
        this.history.pushBackStack(this.historyToken);
        this.updateTabs();
        this.historyToken = this.createBrowseHistoryToken();
    }

    private void goForward() {
        if (!this.history.isForwardStackEmpty()) {
            this.navigateTo(this.history.forward(this.createBrowseHistoryToken()));
        }
    }

    private void goBack() {
        if (!this.history.isBackStackEmpty()) {
            this.navigateTo(this.history.back(this.createBrowseHistoryToken()));
        }
    }

    private BrowseHistoryToken createBrowseHistoryToken() {
        String category = this.getSelectedCategory().getId();
        Nbsolution solution = this.getSelectedArticle();
        String article = solution == null ? null : solution.getId();
        String tab = this.getSelectedTabName();
        int scrollPosition = this.getScrollPosition();
        return new BrowseHistoryToken(category, article, tab, scrollPosition);
    }

    private String getSelectedTabName() {
        Component selectedTab = this.tabbedPnl.getSelectedComponent();
        String result = null;
        Set entries = this.TABS.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != selectedTab) continue;
            result = (String)entry.getKey();
        }
        return result;
    }

    private int getScrollPosition() {
        int result = 0;
        Component selectedTab = this.tabbedPnl.getSelectedComponent();
        if (selectedTab != null) {
            result = ((BluePrintsTabPanel)selectedTab).getScrollPosition();
        }
        return result;
    }

    private void scrollTo(int position) {
        Component selectedTab = this.tabbedPnl.getSelectedComponent();
        if (selectedTab != null) {
            ((BluePrintsTabPanel)selectedTab).setScrollPosition(position);
        }
    }

    private void navigateTo(BrowseHistoryToken token) {
        if (token != null) {
            String category = token.getCategory();
            String article = token.getArticle();
            this.navigateTo(category, article);
            this.updateTabs();
            String tab = token.getTab();
            this.selectTab(tab);
            int scrollPosition = token.getScrollPosition();
            this.scrollTo(scrollPosition);
            this.historyToken = this.createBrowseHistoryToken();
        }
    }

    private void navigateTo(String category, String article) {
        this.navigating = true;
        if (category != null) {
            boolean foundCategory = false;
            int count = this.entryCbx.getItemCount();
            for (int i = 0; i < count; ++i) {
                Nbsolution s;
                Object entry = this.entryCbx.getItemAt(i);
                if (entry instanceof Nbcategory) {
                    Nbcategory c = (Nbcategory)entry;
                    if (c.getId().equals(category)) {
                        foundCategory = true;
                        if (article != null) continue;
                        this.entryCbx.setSelectedIndex(i);
                        break;
                    }
                    if (!foundCategory) continue;
                    break;
                }
                if (!foundCategory || !(s = (Nbsolution)this.entryCbx.getItemAt(i)).getId().equals(article)) continue;
                this.entryCbx.setSelectedIndex(i);
                break;
            }
        }
        this.navigating = false;
    }

    private void showHome() {
        this.tabbedPnl.removeAll();
        this.tabbedPnl.addTab(bundle.getString(TAB_HOME), (Component)this.TABS.get(TAB_HOME));
    }

    private void updateTabs() {
        Nbcategory category = this.getSelectedCategory();
        Nbsolution solution = this.getSelectedArticle();
        if (solution == null) {
            if (category.getId().equals("HOME")) {
                this.showHome();
            } else {
                this.tabbedPnl.removeAll();
                this.tabbedPnl.addTab(bundle.getString(TAB_CATEGORY), (Component)this.TABS.get(TAB_CATEGORY));
            }
        } else {
            this.tabbedPnl.removeAll();
            this.tabbedPnl.addTab(bundle.getString(TAB_SOLUTION), (Component)this.TABS.get(TAB_SOLUTION));
            this.tabbedPnl.addTab(bundle.getString(TAB_DESIGN), (Component)this.TABS.get(TAB_DESIGN));
            this.tabbedPnl.addTab(bundle.getString(TAB_EXAMPLE), (Component)this.TABS.get(TAB_EXAMPLE));
        }
        this.updateCategoryTab();
        this.updateSolutionTab();
        this.updateDesignTab();
        this.updateExampleTab();
        this.updateHomeTab();
    }

    private void selectTab(String tab) {
        this.tabbedPnl.setSelectedComponent((Component)this.TABS.get(tab));
    }

    private void updateCategoryTab() {
        ((BluePrintsTabPanel)this.categoryPnl).updateTab();
    }

    private void updateSolutionTab() {
        ((BluePrintsTabPanel)this.solutionPnl).updateTab();
    }

    private void updateHomeTab() {
        ((BluePrintsTabPanel)this.homePnl).updateTab();
    }

    private void updateDesignTab() {
        Nbwriteup writeup;
        Nbcategory category = this.getSelectedCategory();
        Nbsolution solution = this.getSelectedArticle();
        if (solution != null && ((writeup = solution.getNbwriteup()).getDesigndocPath() == null || writeup.getDesigndocPath().trim().equals(""))) {
            this.tabbedPnl.remove(this.designPnl);
        }
        ((BluePrintsTabPanel)this.designPnl).updateTab();
    }

    public void updateExampleTab() {
        String exampleIds;
        Nbcategory category = this.getSelectedCategory();
        Nbsolution solution = this.getSelectedArticle();
        if (solution != null && (exampleIds = solution.getExampleId()).trim().equals("")) {
            this.tabbedPnl.remove(this.examplePnl);
        }
        ((BluePrintsTabPanel)this.examplePnl).updateTab();
    }

    private static String getCatKeyName(String catName) {
        String nameKey = "category/" + catName.trim() + "/category-name";
        return nameKey;
    }

    private static String getCatKeyDesc(String catDesc) {
        String descKey = "category/" + catDesc.trim() + "/description";
        return descKey;
    }

    private static class EntryListCellRenderer
    extends DefaultListCellRenderer {
        private ImageIcon categoryIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/j2ee/blueprints/ui/resources/category.gif"));
        private ImageIcon articleIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/j2ee/blueprints/ui/resources/article.gif"));

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)result;
            ResourceBundle bundleBpcatalog = ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/BundleBpcatalog");
            String catName = null;
            String fullName = null;
            if (value instanceof Nbcategory) {
                Nbcategory category = (Nbcategory)value;
                label.setIcon(this.categoryIcon);
                try {
                    catName = bundleBpcatalog.getString(BluePrintsPanel.getCatKeyName(category.getId()));
                }
                catch (Exception e) {
                    catName = category.getCategoryName().trim();
                }
                label.setText(catName);
            } else if (value instanceof Nbsolution) {
                Nbsolution solution = (Nbsolution)value;
                label.setIcon(this.articleIcon);
                String solKey = "solution/" + solution.getId().trim() + "/full-name";
                try {
                    fullName = bundleBpcatalog.getString(solKey);
                }
                catch (Exception e) {
                    fullName = solution.getFullName().trim();
                }
                label.setText(fullName);
                label.setBorder(new EmptyBorder(0, 19, 0, 0));
            }
            return result;
        }
    }

    private class EntryComboBoxModel
    extends DefaultComboBoxModel {
        private ArrayList entries = new ArrayList();
        private boolean firstTime = true;

        public EntryComboBoxModel() {
            Nbcategory homeCategory = new Nbcategory();
            homeCategory.setId("HOME");
            homeCategory.setDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("homeCatDesc"));
            homeCategory.setCategoryName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/ui/Bundle").getString("homeCatName"));
            this.entries.add(homeCategory);
            Nbcatalog nbcatalog = BluePrintsPanel.this.solutionsCatalog.getCatalogXml();
            this.populateEntries(nbcatalog);
        }

        public int getSize() {
            return this.entries.size();
        }

        public Object getElementAt(int index) {
            return this.entries.get(index);
        }

        private void populateEntries(Nbcatalog nbcatalog) {
            Nbcategory[] cats = nbcatalog.getNbcategory();
            for (int categoryNum = 0; categoryNum < cats.length; ++categoryNum) {
                Nbcategory category = cats[categoryNum];
                if (category.getShowSpec().equals("true") && this.firstTime) {
                    Nbcategory enclCat = new Nbcategory();
                    String specname = category.getSpec();
                    enclCat.setId(specname);
                    enclCat.setDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/BundleBpcatalog").getString(BluePrintsPanel.getCatKeyName(specname)));
                    enclCat.setCategoryName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/blueprints/BundleBpcatalog").getString(BluePrintsPanel.getCatKeyDesc(specname)));
                    this.entries.add(enclCat);
                    this.firstTime = false;
                }
                this.entries.add(category);
                Nbsolution[] solutions = category.getNbsolution();
                for (int solutionNum = 0; solutionNum < solutions.length; ++solutionNum) {
                    this.entries.add(solutions[solutionNum]);
                }
            }
        }
    }
}

