/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl.config.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.websvc.wsdl.config.ConfigurationProxy;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class DDProvider {
    private static DDProvider ddProvider;
    private Map ddMap = new HashMap(5);
    private Map baseBeanMap = new HashMap(5);
    private Map errorMap = new HashMap(5);
    private FCA fileChangeListener = new FCA();

    private DDProvider() {
    }

    public static synchronized DDProvider getDefault() {
        if (ddProvider == null) {
            ddProvider = new DDProvider();
        }
        return ddProvider;
    }

    public Configuration getDDRoot(FileObject fo) throws IOException {
        ConfigurationProxy configuration;
        block7: {
            configuration = this.getFromCache(fo);
            if (configuration != null) {
                return configuration;
            }
            fo.addFileChangeListener((FileChangeListener)this.fileChangeListener);
            SAXParseException error = null;
            try {
                Configuration original = this.getOriginalFromCache(fo);
                if (original == null) {
                    error = this.parse(fo);
                    original = DDProvider.createConfiguration(fo.getInputStream());
                    this.baseBeanMap.put(fo, new WeakReference<Configuration>(original));
                } else {
                    error = (SAXParseException)this.errorMap.get(fo);
                }
                configuration = new ConfigurationProxy(original);
                if (error != null) {
                    configuration.setStatus(1);
                    configuration.setError(error);
                }
            }
            catch (SAXException ex) {
                configuration = new ConfigurationProxy(null);
                configuration.setStatus(2);
                if (ex instanceof SAXParseException) {
                    configuration.setError((SAXParseException)ex);
                }
                if (!(ex.getException() instanceof SAXParseException)) break block7;
                configuration.setError((SAXParseException)ex.getException());
            }
        }
        this.ddMap.put(fo, new WeakReference<ConfigurationProxy>(configuration));
        return configuration;
    }

    public Configuration getDDRootCopy(FileObject fo) throws IOException {
        return (Configuration)this.getDDRoot(fo).clone();
    }

    private ConfigurationProxy getFromCache(FileObject fo) throws IOException {
        WeakReference wr = (WeakReference)this.ddMap.get(fo);
        if (wr == null) {
            return null;
        }
        ConfigurationProxy configuration = (ConfigurationProxy)wr.get();
        if (configuration == null) {
            this.ddMap.remove(fo);
        }
        return configuration;
    }

    private Configuration getOriginalFromCache(FileObject fo) throws IOException {
        WeakReference wr = (WeakReference)this.baseBeanMap.get(fo);
        if (wr == null) {
            return null;
        }
        Configuration configuration = (Configuration)wr.get();
        if (configuration == null) {
            this.baseBeanMap.remove(fo);
            this.errorMap.remove(fo);
        }
        return configuration;
    }

    public Configuration getDDRoot(File f) throws IOException, SAXException {
        return DDProvider.createConfiguration(new FileInputStream(f));
    }

    private static Configuration createConfiguration(InputStream is) throws IOException, SAXException {
        try {
            return org.netbeans.modules.websvc.wsdl.config.impl.Configuration.createGraph(is);
        }
        catch (RuntimeException ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    public SAXParseException parse(FileObject fo) throws SAXException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            SAXParser parser = DDProvider.createSAXParserFactory().newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(errorHandler);
            reader.setEntityResolver(DDResolver.getInstance());
            reader.parse(new InputSource(fo.getInputStream()));
            SAXParseException error = errorHandler.getError();
            if (error != null) {
                return error;
            }
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex.getMessage());
        }
        catch (SAXException ex) {
            throw ex;
        }
        return null;
    }

    private static SAXParserFactory createSAXParserFactory() throws ParserConfigurationException {
        try {
            SAXParserFactory fact = SAXParserFactory.newInstance();
            if (fact != null) {
                try {
                    fact.getClass().getMethod("getSchema", new Class[0]);
                    return fact;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return (SAXParserFactory)Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").newInstance();
        }
        catch (Exception ex) {
            throw new ParserConfigurationException(ex.getMessage());
        }
    }

    private class FCA
    extends FileChangeAdapter {
        private FCA() {
        }

        public void fileChanged(FileEvent evt) {
            block14: {
                FileObject fo = evt.getFile();
                try {
                    ConfigurationProxy configuration = DDProvider.this.getFromCache(fo);
                    Configuration orig = DDProvider.this.getOriginalFromCache(fo);
                    if (configuration != null) {
                        try {
                            SAXParseException error = DDProvider.this.parse(fo);
                            if (error != null) {
                                configuration.setError(error);
                                configuration.setStatus(1);
                            } else {
                                configuration.setError(null);
                                configuration.setStatus(0);
                            }
                            Configuration original = DDProvider.createConfiguration(fo.getInputStream());
                            DDProvider.this.baseBeanMap.put(fo, new WeakReference<Configuration>(original));
                            DDProvider.this.errorMap.put(fo, configuration.getError());
                            if (configuration.getOriginal() == null) {
                                configuration.setOriginal(original);
                                break block14;
                            }
                            configuration.getOriginal().merge(original, 3);
                        }
                        catch (SAXException ex) {
                            if (ex instanceof SAXParseException) {
                                configuration.setError((SAXParseException)ex);
                            } else if (ex.getException() instanceof SAXParseException) {
                                configuration.setError((SAXParseException)ex.getException());
                            }
                            configuration.setStatus(2);
                            configuration.setOriginal(null);
                        }
                        break block14;
                    }
                    if (orig == null) break block14;
                    try {
                        Configuration original = DDProvider.createConfiguration(fo.getInputStream());
                        if (original.getClass().equals(orig.getClass())) {
                            orig.merge(original, 3);
                            break block14;
                        }
                        DDProvider.this.baseBeanMap.put(fo, new WeakReference<Configuration>(original));
                    }
                    catch (SAXException ex) {
                        DDProvider.this.baseBeanMap.remove(fo);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String resource = null;
            if ("http://java.sun.com/xml/ns/jax-rpc/ri/config".equals(systemId)) {
                resource = "/org/netbeans/modules/websvc/wsdl/resources/jax-rpc-ri-config_1_1.xsd";
            }
            if (resource == null) {
                return null;
            }
            URL url = this.getClass().getResource(resource);
            return new InputSource(url.toString());
        }
    }
}

