/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.StatementInfo;
import org.openide.ErrorManager;

public final class SQLExecuteHelper {
    private static final ErrorManager LOGGER;
    private static final boolean LOG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static SQLExecutionResults execute(String sqlScript, int startOffset, int endOffset, Connection conn, ProgressHandle progressHandle, SQLExecutionLogger executionLogger) {
        boolean cancelled = false;
        List statements = SQLExecuteHelper.getStatements(sqlScript, startOffset, endOffset);
        boolean computeResults = statements.size() == 1;
        ArrayList<SQLExecutionResult> resultList = new ArrayList<SQLExecutionResult>();
        long totalExecutionTime = 0L;
        Iterator i = statements.iterator();
        while (i.hasNext() && !(cancelled = Thread.currentThread().isInterrupted())) {
            StatementInfo info = (StatementInfo)i.next();
            String sql = info.getSQL();
            if (LOG) {
                LOGGER.log(1, "Executing: " + sql);
            }
            SQLExecutionResult result = null;
            Statement stmt = null;
            try {
                stmt = sql.startsWith("{") ? conn.prepareCall(sql) : conn.createStatement();
                boolean isResultSet = false;
                long startTime = System.currentTimeMillis();
                isResultSet = stmt instanceof PreparedStatement ? ((PreparedStatement)stmt).execute() : stmt.execute(sql);
                long executionTime = System.currentTimeMillis() - startTime;
                totalExecutionTime += executionTime;
                result = isResultSet ? new SQLExecutionResult(info, stmt, stmt.getResultSet(), executionTime) : new SQLExecutionResult(info, stmt, stmt.getUpdateCount(), executionTime);
            }
            catch (SQLException e) {
                result = new SQLExecutionResult(info, stmt, e);
            }
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            executionLogger.log(result);
            if (LOG) {
                LOGGER.log(1, "Result: " + result);
            }
            if (computeResults || result.getException() != null) {
                resultList.add(result);
                continue;
            }
            try {
                result.close();
            }
            catch (SQLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        if (!cancelled) {
            executionLogger.finish(totalExecutionTime);
        } else {
            if (LOG) {
                LOGGER.log(1, "Execution cancelled");
            }
            executionLogger.cancel();
        }
        SQLExecutionResults results = new SQLExecutionResults(resultList);
        if (!cancelled) {
            return results;
        }
        results.close();
        return null;
    }

    private static int[] getSupportedResultSetTypeConcurrency(Connection conn) throws SQLException {
        int concurrency;
        int type;
        DatabaseMetaData dmd = conn.getMetaData();
        if (!dmd.supportsResultSetConcurrency(type = 1004, concurrency = 1008) && !dmd.supportsResultSetConcurrency(type, concurrency = 1007)) {
            type = 1003;
        }
        return new int[]{type, concurrency};
    }

    private static List getStatements(String script, int startOffset, int endOffset) {
        List allStatements = SQLExecuteHelper.split(script);
        if (startOffset == 0 && endOffset == script.length()) {
            return allStatements;
        }
        ArrayList<StatementInfo> statements = new ArrayList<StatementInfo>();
        Iterator i = allStatements.iterator();
        while (i.hasNext()) {
            StatementInfo stmt = (StatementInfo)i.next();
            if (startOffset == endOffset) {
                if (stmt.getStartOffset() > startOffset || stmt.getEndOffset() < endOffset) continue;
                statements.add(stmt);
                continue;
            }
            if (stmt.getStartOffset() < startOffset || stmt.getEndOffset() > endOffset) continue;
            statements.add(stmt);
        }
        return Collections.unmodifiableList(statements);
    }

    static List split(String script) {
        return new SQLSplitter(script).getStatements();
    }

    static {
        $assertionsDisabled = !SQLExecuteHelper.class.desiredAssertionStatus();
        LOGGER = ErrorManager.getDefault().getInstance(SQLExecuteHelper.class.getName());
        LOG = LOGGER.isLoggable(1);
    }

    private static final class SQLSplitter {
        private static final int STATE_START = 0;
        private static final int STATE_MAYBE_LINE_COMMENT = 1;
        private static final int STATE_LINE_COMMENT = 2;
        private static final int STATE_MAYBE_BLOCK_COMMENT = 3;
        private static final int STATE_BLOCK_COMMENT = 4;
        private static final int STATE_MAYBE_END_BLOCK_COMMENT = 5;
        private static final int STATE_STRING = 6;
        private String sql;
        private int sqlLength;
        private StringBuffer statement = new StringBuffer();
        private List statements = new ArrayList();
        private int pos = 0;
        private int line = -1;
        private int column;
        private boolean wasEOL = true;
        private int startOffset;
        private int startLine;
        private int startColumn;
        private int endOffset;
        private int state = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SQLSplitter(String sql) {
            if (!$assertionsDisabled && sql == null) {
                throw new AssertionError();
            }
            this.sql = sql;
            this.sqlLength = sql.length();
            this.parse();
        }

        private void parse() {
            block9: while (this.pos < this.sqlLength) {
                char ch = this.sql.charAt(this.pos);
                if (ch == '\r') {
                    if (!LOG) continue;
                    LOGGER.log(1, "The SQL string contained non-supported \r characters.");
                    continue;
                }
                if (this.wasEOL) {
                    ++this.line;
                    this.column = 0;
                    this.wasEOL = false;
                } else {
                    ++this.column;
                }
                if (ch == '\n') {
                    this.wasEOL = true;
                }
                switch (this.state) {
                    case 0: {
                        if (ch == '-') {
                            this.state = 1;
                        }
                        if (ch == '/') {
                            this.state = 3;
                        }
                        if (ch != '\'') break;
                        this.state = 6;
                        break;
                    }
                    case 1: {
                        if (ch == '-') {
                            this.state = 2;
                            break;
                        }
                        this.state = 0;
                        this.statement.append('-');
                        this.endOffset = this.pos;
                        break;
                    }
                    case 2: {
                        if (ch != '\n') break;
                        this.state = 0;
                        ++this.pos;
                        continue block9;
                    }
                    case 3: {
                        if (ch == '*') {
                            this.state = 4;
                            break;
                        }
                        this.statement.append('/');
                        this.endOffset = this.pos;
                        if (ch == '/') break;
                        this.state = 0;
                        break;
                    }
                    case 4: {
                        if (ch != '*') break;
                        this.state = 5;
                        break;
                    }
                    case 5: {
                        if (ch == '/') {
                            this.state = 0;
                            ++this.pos;
                            continue block9;
                        }
                        if (ch == '*') break;
                        this.state = 4;
                        break;
                    }
                    case 6: {
                        if (ch != '\n' && ch != '\'') break;
                        this.state = 0;
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                if (this.state == 0 && ch == ';') {
                    this.addStatement();
                    this.statement.setLength(0);
                } else if (!(this.state != 0 && this.state != 6 || this.statement.length() <= 0 && Character.isWhitespace(ch))) {
                    if (this.statement.length() == 0) {
                        this.startOffset = this.pos;
                        this.endOffset = this.pos;
                        this.startLine = this.line;
                        this.startColumn = this.column;
                    }
                    this.statement.append(ch);
                    if (this.state == 6 || !Character.isWhitespace(ch)) {
                        this.endOffset = this.pos + 1;
                    }
                }
                ++this.pos;
            }
            this.addStatement();
        }

        private void addStatement() {
            String sql = this.statement.toString().trim();
            if (sql.length() <= 0) {
                return;
            }
            StatementInfo info = new StatementInfo(sql, this.startOffset, this.startLine, this.startColumn, this.endOffset);
            this.statements.add(info);
        }

        public List getStatements() {
            return Collections.unmodifiableList(this.statements);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$db$sql$execute$SQLExecuteHelper == null ? (class$org$netbeans$modules$db$sql$execute$SQLExecuteHelper = SQLExecuteHelper.class$("org.netbeans.modules.db.sql.execute.SQLExecuteHelper")) : class$org$netbeans$modules$db$sql$execute$SQLExecuteHelper).desiredAssertionStatus();
        }
    }
}

