/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.core;

import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class SQLOptions
extends SystemOption {
    private static final long serialVersionUID = -3200264376265775809L;
    private static final String PROP_FETCH_STEP = "fetchStep";
    private static final int DEFAULT_FETCH_STEP = 200;

    public static SQLOptions getDefault() {
        return (SQLOptions)SharedClassObject.findObject((Class)SQLOptions.class, (boolean)true);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)SQLOptions.class, (String)"LBL_SQLOptions");
    }

    public int getFetchStep() {
        Object data = this.getProperty(PROP_FETCH_STEP);
        if (data != null) {
            return SQLOptions.convertToInt((String)data, 200);
        }
        return 200;
    }

    public void setFetchStep(int value) {
        this.putProperty(PROP_FETCH_STEP, String.valueOf(value), true);
    }

    private static int convertToInt(String str, int def) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }
}

