/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BreakpointsTreeModel
implements TreeModel {
    private static final Comparator BREAKPOINTS_COMPARATOR = new BreakpointsComparator();
    private Listener listener;
    private Vector listeners = new Vector();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            TreeSet<Object> l = new TreeSet<Object>(BREAKPOINTS_COMPARATOR);
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                if (bs[i].getGroupName().equals("")) {
                    l.add(bs[i]);
                    continue;
                }
                l.add(bs[i].getGroupName());
            }
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            if (to == 0) {
                return new ArrayList(l).toArray();
            }
            to = Math.min(l.size(), to);
            from = Math.min(l.size(), from);
            return new ArrayList(l).subList(from, to).toArray();
        }
        if (parent instanceof String) {
            String groupName = (String)parent;
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            TreeSet<Breakpoint> l = new TreeSet<Breakpoint>(BREAKPOINTS_COMPARATOR);
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                if (!bs[i].getGroupName().equals(groupName)) continue;
                l.add(bs[i]);
            }
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            if (to == 0) {
                return new ArrayList(l).toArray();
            }
            to = Math.min(l.size(), to);
            from = Math.min(l.size(), from);
            return new ArrayList(l).subList(from, to).toArray();
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return this.getChildren(node, 0, 0).length;
        }
        if (node instanceof String) {
            return this.getChildren(node, 0, 0).length;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Breakpoint) {
            return true;
        }
        if (node instanceof String) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTreeChanged(ModelEvent me) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(me);
        }
    }

    private static class BreakpointsComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o1.getClass() == o2.getClass()) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (o1 instanceof String) {
                if (o2 instanceof String) {
                    return ((String)o1).compareTo((String)o2);
                }
                return -1;
            }
            if (o2 instanceof String) {
                return 1;
            }
            return ((Breakpoint)o1).toString().compareTo(((Breakpoint)o2).toString());
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;

        public Listener(BreakpointsTreeModel tm) {
            this.model = new WeakReference<BreakpointsTreeModel>(tm);
            DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                bs[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private BreakpointsTreeModel getModel() {
            BreakpointsTreeModel m = (BreakpointsTreeModel)this.model.get();
            if (m == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
                Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                int k = bs.length;
                for (int i = 0; i < k; ++i) {
                    bs[i].removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return m;
        }

        public void breakpointAdded(Breakpoint breakpoint) {
            BreakpointsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
            BreakpointsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireTreeChanged();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BreakpointsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            if (!(evt.getSource() instanceof Breakpoint)) {
                return;
            }
            if (evt.getPropertyName() == "groupName") {
                m.fireTreeChanged();
            } else {
                m.fireTreeChanged((ModelEvent)new ModelEvent.NodeChanged((Object)m, evt.getSource()));
            }
        }
    }
}

